/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class HardwareDescription
implements Serializable {
    private static final long serialVersionUID = 3380016608300325361L;
    public static final String FIELD_NAME_CPU_CORES = "cpuCores";
    public static final String FIELD_NAME_SIZE_PHYSICAL_MEMORY = "physicalMemory";
    public static final String FIELD_NAME_SIZE_JVM_HEAP = "freeMemory";
    public static final String FIELD_NAME_SIZE_MANAGED_MEMORY = "managedMemory";
    @JsonProperty(value="cpuCores")
    private final int numberOfCPUCores;
    @JsonProperty(value="physicalMemory")
    private final long sizeOfPhysicalMemory;
    @JsonProperty(value="freeMemory")
    private final long sizeOfJvmHeap;
    @JsonProperty(value="managedMemory")
    private final long sizeOfManagedMemory;

    @JsonCreator
    public HardwareDescription(@JsonProperty(value="cpuCores") int numberOfCPUCores, @JsonProperty(value="physicalMemory") long sizeOfPhysicalMemory, @JsonProperty(value="freeMemory") long sizeOfJvmHeap, @JsonProperty(value="managedMemory") long sizeOfManagedMemory) {
        this.numberOfCPUCores = numberOfCPUCores;
        this.sizeOfPhysicalMemory = sizeOfPhysicalMemory;
        this.sizeOfJvmHeap = sizeOfJvmHeap;
        this.sizeOfManagedMemory = sizeOfManagedMemory;
    }

    public int getNumberOfCPUCores() {
        return this.numberOfCPUCores;
    }

    public long getSizeOfPhysicalMemory() {
        return this.sizeOfPhysicalMemory;
    }

    public long getSizeOfJvmHeap() {
        return this.sizeOfJvmHeap;
    }

    public long getSizeOfManagedMemory() {
        return this.sizeOfManagedMemory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HardwareDescription that = (HardwareDescription)o;
        return this.numberOfCPUCores == that.numberOfCPUCores && this.sizeOfPhysicalMemory == that.sizeOfPhysicalMemory && this.sizeOfJvmHeap == that.sizeOfJvmHeap && this.sizeOfManagedMemory == that.sizeOfManagedMemory;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfCPUCores, this.sizeOfPhysicalMemory, this.sizeOfJvmHeap, this.sizeOfManagedMemory);
    }

    public String toString() {
        return String.format("cores=%d, physMem=%d, heap=%d, managed=%d", this.numberOfCPUCores, this.sizeOfPhysicalMemory, this.sizeOfJvmHeap, this.sizeOfManagedMemory);
    }

    public static HardwareDescription extractFromSystem(long managedMemory) {
        int numberOfCPUCores = Hardware.getNumberCPUCores();
        long sizeOfJvmHeap = Runtime.getRuntime().maxMemory();
        long sizeOfPhysicalMemory = Hardware.getSizeOfPhysicalMemory();
        return new HardwareDescription(numberOfCPUCores, sizeOfPhysicalMemory, sizeOfJvmHeap, managedMemory);
    }
}

