/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ListTypeInfo<T>
extends TypeInformation<List<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<T> elementTypeInfo;

    public ListTypeInfo(Class<T> elementTypeClass) {
        this.elementTypeInfo = ListTypeInfo.of(Preconditions.checkNotNull(elementTypeClass, "elementTypeClass"));
    }

    public ListTypeInfo(TypeInformation<T> elementTypeInfo) {
        this.elementTypeInfo = Preconditions.checkNotNull(elementTypeInfo, "elementTypeInfo");
    }

    public TypeInformation<T> getElementTypeInfo() {
        return this.elementTypeInfo;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<List<T>> getTypeClass() {
        return List.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<List<T>> createSerializer(ExecutionConfig config) {
        TypeSerializer<T> elementTypeSerializer = this.elementTypeInfo.createSerializer(config);
        return new ListSerializer<T>(elementTypeSerializer);
    }

    @Override
    public String toString() {
        return "List<" + this.elementTypeInfo + '>';
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListTypeInfo) {
            ListTypeInfo other = (ListTypeInfo)obj;
            return other.canEqual(this) && this.elementTypeInfo.equals(other.elementTypeInfo);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.elementTypeInfo.hashCode() + 1;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

