/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogFileTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogFileTask.class);
    private final Path logPath;
    private final boolean isOverwrite;
    protected ch.qos.logback.classic.Logger fileLogger;
    private FileAppender<ILoggingEvent> fileAppender;
    private PatternLayoutEncoder ple;

    public AbstractLogFileTask(String logPath, boolean isOverwrite) {
        this.logPath = Paths.get(logPath, new String[0]);
        this.isOverwrite = isOverwrite;
    }

    @Override
    public void run() {
        try {
            Path logDir = this.logPath.getParent();
            if (!Files.isDirectory(logDir, new LinkOption[0])) {
                log.info("Created log dir {}", (Object)logDir);
                Files.createDirectories(logDir, new FileAttribute[0]);
            }
            if (this.isOverwrite) {
                Files.deleteIfExists(this.logPath);
            }
            this.fileLogger = this.createFileLogger();
            this.doRun();
        }
        catch (Throwable t) {
            log.warn("Failed to run task.", t);
            if (this.fileLogger != null) {
                this.fileLogger.error("Failed to run task.", t);
            }
            this.processException(t);
        }
        finally {
            this.doFinally();
            if (this.ple != null) {
                this.ple.stop();
            }
            if (this.fileAppender != null) {
                this.fileAppender.stop();
            }
            if (this.fileLogger != null) {
                this.fileLogger.detachAppender(this.fileAppender);
            }
        }
    }

    private ch.qos.logback.classic.Logger createFileLogger() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.ple = new PatternLayoutEncoder();
        this.ple.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS,Asia/Singapore} %-5p - %m%n");
        this.ple.setContext((Context)lc);
        this.ple.start();
        this.fileAppender = new FileAppender();
        this.fileAppender.setFile(this.logPath.toString());
        this.fileAppender.setEncoder((Encoder)this.ple);
        this.fileAppender.setContext((Context)lc);
        this.fileAppender.start();
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)Thread.currentThread().getName());
        logger.addAppender(this.fileAppender);
        logger.setLevel(Level.INFO);
        logger.setAdditive(false);
        return logger;
    }

    protected abstract void doRun() throws Throwable;

    protected abstract void processException(Throwable var1);

    protected abstract void doFinally();
}

