/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.system.entity.Role;
import org.apache.streampark.console.system.entity.RoleMenu;
import org.apache.streampark.console.system.mapper.RoleMapper;
import org.apache.streampark.console.system.mapper.RoleMenuMapper;
import org.apache.streampark.console.system.service.MemberService;
import org.apache.streampark.console.system.service.RoleMenuServie;
import org.apache.streampark.console.system.service.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, Role>
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private MemberService memberService;
    @Autowired
    private RoleMenuServie roleMenuService;

    @Override
    public IPage<Role> page(Role role, RestRequest request) {
        Page page = MybatisPager.getPage(request);
        return ((RoleMapper)this.baseMapper).findRole(page, role);
    }

    @Override
    public Role findByName(String roleName) {
        return (Role)((RoleMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(Role::getRoleName, (Object)roleName));
    }

    @Override
    public void createRole(Role role) {
        Date date = new Date();
        role.setCreateTime(date);
        role.setModifyTime(date);
        this.save(role);
        String[] menuIds = role.getMenuId().split(",");
        this.setRoleMenus(role, menuIds);
    }

    @Override
    public void deleteRole(Long roleId) {
        Role role = (Role)Optional.ofNullable(this.getById(roleId)).orElseThrow(() -> new ApiAlertException(String.format("Role id [%s] not found. Delete role failed.", roleId)));
        List<Long> userIdsByRoleId = this.memberService.findUserIdsByRoleId(roleId);
        ApiAlertException.throwIfFalse(userIdsByRoleId == null || userIdsByRoleId.isEmpty(), String.format("There are some users of role %s, delete role failed, please unbind it first.", role.getRoleName()));
        this.removeById(roleId);
        this.roleMenuService.deleteByRoleId(roleId);
    }

    @Override
    public void updateRole(Role role) {
        role.setModifyTime(new Date());
        ((RoleMapper)this.baseMapper).updateById(role);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RoleMenu::getRoleId, (Object)role.getRoleId());
        this.roleMenuMapper.delete((Wrapper)queryWrapper);
        String menuId = role.getMenuId();
        if (StringUtils.contains((CharSequence)menuId, (CharSequence)"100018") && !StringUtils.contains((CharSequence)menuId, (CharSequence)"100015")) {
            menuId = menuId + "," + "100015";
        }
        String[] menuIds = menuId.split(",");
        this.setRoleMenus(role, menuIds);
    }

    private void setRoleMenus(Role role, String[] menuIds) {
        Arrays.stream(menuIds).forEach(menuId -> {
            RoleMenu rm = new RoleMenu();
            rm.setMenuId(Long.valueOf(menuId));
            rm.setRoleId(role.getRoleId());
            this.roleMenuMapper.insert(rm);
        });
    }
}

