/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluent;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceFluentImpl;
import java.util.Objects;

public class EndpointSliceBuilder
extends EndpointSliceFluentImpl<EndpointSliceBuilder>
implements VisitableBuilder<EndpointSlice, EndpointSliceBuilder> {
    EndpointSliceFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSliceBuilder() {
        this(true);
    }

    public EndpointSliceBuilder(Boolean validationEnabled) {
        this(new EndpointSlice(), validationEnabled);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointSlice(), validationEnabled);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent, EndpointSlice instance) {
        this(fluent, instance, true);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent, EndpointSlice instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddressType(instance.getAddressType());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    public EndpointSliceBuilder(EndpointSlice instance) {
        this(instance, (Boolean)true);
    }

    public EndpointSliceBuilder(EndpointSlice instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddressType(instance.getAddressType());
        this.withApiVersion(instance.getApiVersion());
        this.withEndpoints(instance.getEndpoints());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPorts(instance.getPorts());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EndpointSlice build() {
        EndpointSlice buildable = new EndpointSlice(this.fluent.getAddressType(), this.fluent.getApiVersion(), this.fluent.getEndpoints(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getPorts());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSliceBuilder that = (EndpointSliceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

