/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.CheckPointStatus;
import org.apache.streampark.console.core.enums.FlinkAppState;

public class AlertTemplate
implements Serializable {
    private String title;
    private String subject;
    private String jobName;
    private String status;
    private Integer type;
    private String startTime;
    private String endTime;
    private String duration;
    private String link;
    private String cpFailureRateInterval;
    private Integer cpMaxFailureInterval;
    private Boolean restart;
    private Integer restartIndex;
    private Integer totalRestart;
    private boolean atAll = false;

    private static AlertTemplate of(Application application) {
        AlertTemplate template = new AlertTemplate();
        template.setJobName(application.getJobName());
        if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            String format = "%s/proxy/%s/";
            String url = String.format(format, YarnUtils.getRMWebAppURL((boolean)false), application.getClusterId());
            template.setLink(url);
        } else {
            template.setLink(null);
        }
        if (application.getStartTime() != null) {
            template.setStartTime(DateUtils.format((Date)application.getStartTime(), (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
            if (application.getEndTime() != null) {
                long duration = application.getEndTime().getTime() - application.getStartTime().getTime();
                if (duration > 0L) {
                    template.setEndTime(DateUtils.format((Date)application.getEndTime(), (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
                    template.setDuration(DateUtils.toStringDuration((long)duration));
                } else {
                    template.setStartTime("-");
                    template.setEndTime("-");
                    template.setDuration("-");
                }
            } else {
                template.setEndTime("-");
                template.setDuration("-");
            }
        } else {
            template.setStartTime("-");
            template.setEndTime("-");
            template.setDuration("-");
        }
        boolean needRestart = application.isNeedRestartOnFailed() && application.getRestartCount() > 0;
        template.setRestart(needRestart);
        if (needRestart) {
            template.setRestartIndex(application.getRestartCount());
            template.setTotalRestart(application.getRestartSize());
        }
        return template;
    }

    public static AlertTemplate of(Application application, FlinkAppState appState) {
        AlertTemplate template = AlertTemplate.of(application);
        template.setType(1);
        template.setTitle(String.format("Notify: %s %s", application.getJobName(), appState.name()));
        template.setSubject(String.format("StreamPark Alert: %s %s", template.getJobName(), appState));
        template.setStatus(appState.name());
        return template;
    }

    public static AlertTemplate of(Application application, CheckPointStatus checkPointStatus) {
        AlertTemplate template = AlertTemplate.of(application);
        template.setType(2);
        template.setCpFailureRateInterval(DateUtils.toStringDuration((long)(application.getCpFailureRateInterval() * 1000 * 60)));
        template.setCpMaxFailureInterval(application.getCpMaxFailureInterval());
        template.setTitle(String.format("Notify: %s checkpoint FAILED", application.getJobName()));
        template.setSubject(String.format("StreamPark Alert: %s, checkPoint is Failed", template.getJobName()));
        return template;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getType() {
        return this.type;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getLink() {
        return this.link;
    }

    public String getCpFailureRateInterval() {
        return this.cpFailureRateInterval;
    }

    public Integer getCpMaxFailureInterval() {
        return this.cpMaxFailureInterval;
    }

    public Boolean getRestart() {
        return this.restart;
    }

    public Integer getRestartIndex() {
        return this.restartIndex;
    }

    public Integer getTotalRestart() {
        return this.totalRestart;
    }

    public boolean isAtAll() {
        return this.atAll;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setCpFailureRateInterval(String cpFailureRateInterval) {
        this.cpFailureRateInterval = cpFailureRateInterval;
    }

    public void setCpMaxFailureInterval(Integer cpMaxFailureInterval) {
        this.cpMaxFailureInterval = cpMaxFailureInterval;
    }

    public void setRestart(Boolean restart) {
        this.restart = restart;
    }

    public void setRestartIndex(Integer restartIndex) {
        this.restartIndex = restartIndex;
    }

    public void setTotalRestart(Integer totalRestart) {
        this.totalRestart = totalRestart;
    }

    public void setAtAll(boolean atAll) {
        this.atAll = atAll;
    }
}

