/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import javax.annotation.Nullable;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.SavePointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/savepoint"})
public class SavePointController {
    private static final Logger log = LoggerFactory.getLogger(SavePointController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private SavePointService savePointService;

    @PostMapping(value={"history"})
    @PermissionScope(app="#sp.appId", team="#sp.teamId")
    public RestResponse history(SavePoint sp, RestRequest request) {
        IPage<SavePoint> page = this.savePointService.page(sp, request);
        return RestResponse.success(page);
    }

    @PostMapping(value={"delete"})
    @RequiresPermissions(value={"savepoint:delete"})
    @PermissionScope(app="#sp.appId", team="#sp.teamId")
    public RestResponse delete(SavePoint sp) throws InternalException {
        SavePoint savePoint = (SavePoint)this.savePointService.getById(sp.getId());
        Application application = (Application)this.applicationService.getById(savePoint.getAppId());
        Boolean deleted = this.savePointService.delete(sp.getId(), application);
        return RestResponse.success(deleted);
    }

    @PostMapping(value={"trigger"})
    @RequiresPermissions(value={"savepoint:trigger"})
    @PermissionScope(app="#savePoint.appId", team="#savePoint.teamId")
    public RestResponse trigger(SavePoint savePoint, @Nullable String savepointPath) {
        this.savePointService.trigger(savePoint.getAppId(), savepointPath);
        return RestResponse.success(true);
    }
}

