/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.NormalizableKey;

@Internal
public class DoubleValueComparator
extends TypeComparator<DoubleValue> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final DoubleValue reference = new DoubleValue();
    private final DoubleValue tempReference = new DoubleValue();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public DoubleValueComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(DoubleValue record) {
        return record.hashCode();
    }

    @Override
    public void setReference(DoubleValue toCompare) {
        toCompare.copyTo(this.reference);
    }

    @Override
    public boolean equalToReference(DoubleValue candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<DoubleValue> referencedComparator) {
        DoubleValue otherRef = ((DoubleValueComparator)referencedComparator).reference;
        int comp = otherRef.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(DoubleValue first, DoubleValue second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.reference.read(firstSource);
        this.tempReference.read(secondSource);
        int comp = this.reference.compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(DoubleValue.class);
    }

    @Override
    public int getNormalizeKeyLen() {
        NormalizableKey key = (NormalizableKey)((Object)this.reference);
        return key.getMaxNormalizedKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(DoubleValue record, MemorySegment target, int offset, int numBytes) {
        NormalizableKey key = (NormalizableKey)((Object)record);
        key.copyNormalizedKey(target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public TypeComparator<DoubleValue> duplicate() {
        return new DoubleValueComparator(this.ascendingComparison);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(DoubleValue record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleValue readWithKeyDenormalization(DoubleValue reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

