/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.JobStatusWatcherConfig;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.event.FlinkJobStatusChangeEvent;
import org.apache.streampark.flink.kubernetes.helper.KubernetesDeploymentHelper$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.FlinkHistoryArchives$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkJobStatusWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import org.apache.streampark.flink.kubernetes.watcher.JobDetail;
import org.apache.streampark.flink.kubernetes.watcher.JobDetails;
import org.apache.streampark.flink.kubernetes.watcher.JobDetails$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyLong;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0010 \u00011B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\t\u0002\u0011)\u0019!C\u0002\u000b\"A\u0011\n\u0001B\u0001B\u0003%a\t\u0003\u0005K\u0001\t\u0015\r\u0011b\u0001L\u0011!y\u0005A!A!\u0002\u0013a\u0005\"\u0002)\u0001\t\u0003\t\u0006bB,\u0001\u0005\u0004%Y\u0001\u0017\u0005\u0007?\u0002\u0001\u000b\u0011B-\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0013\t\u0007\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0011%y\u0007\u00011A\u0001B\u0003&!\rC\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\b!9\u00111\u0002\u0001\u0005B\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!!\u0018\u0001\t\u0003\ty\u0006\u0003\u0005\u0002f\u0001\u0001K\u0011BA4\u0011!\ty\u0007\u0001Q\u0005\n\u0005E\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\tY\n\u0001C\u0005\u0003;C\u0001\"a,\u0001A\u0013%\u0011\u0011W\u0004\b\u00033|\u0002\u0012AAn\r\u0019qr\u0004#\u0001\u0002^\"1\u0001K\u0007C\u0001\u0003?Dq!!9\u001b\t\u0003\t\u0019\u000fC\u0005\u0002nj\t\n\u0011\"\u0001\u0002p\n)b\t\\5oW*{'m\u0015;biV\u001cx+\u0019;dQ\u0016\u0014(B\u0001\u0011\"\u0003\u001d9\u0018\r^2iKJT!AI\u0012\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002%K\u0005)a\r\\5oW*\u0011aeJ\u0001\u000bgR\u0014X-Y7qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001[MZ\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025s5\tQG\u0003\u00027o\u0005!Q\u000f^5m\u0015\tAT%\u0001\u0004d_6lwN\\\u0005\u0003uU\u0012a\u0001T8hO\u0016\u0014\bC\u0001\u001f>\u001b\u0005y\u0012B\u0001  \u000511E.\u001b8l/\u0006$8\r[3s\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0005\u0013U\"A\u0011\n\u0005\r\u000b#A\u0006&pEN#\u0018\r^;t/\u0006$8\r[3s\u0007>tg-[4\u0002\u001f]\fGo\u00195D_:$(o\u001c7mKJ,\u0012A\u0012\t\u0003\u0003\u001eK!\u0001S\u0011\u0003/\u0019c\u0017N\\6LqM<\u0016\r^2i\u0007>tGO]8mY\u0016\u0014\u0018\u0001E<bi\u000eD7i\u001c8ue>dG.\u001a:!\u0003!)g/\u001a8u\u0005V\u001cX#\u0001'\u0011\u0005\u0005k\u0015B\u0001(\"\u00059\u0019\u0005.\u00198hK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)\t\u0011f\u000bF\u0002T)V\u0003\"\u0001\u0010\u0001\t\u000b\u00113\u00019\u0001$\t\u000b)3\u00019\u0001'\t\u000f}2\u0001\u0013!a\u0001\u0001\u0006\tBO]1dWR\u000b7o[#yK\u000e,Ho\u001c:\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001X\u0018\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002_7\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002%Q\u0014\u0018mY6UCN\\W\t_3dkR|'\u000fI\u0001\u000ei&lWM]*dQ\u0016$W\u000f\\3\u0016\u0003\t\u0004$aY7\u0011\u0007\u0011L7.D\u0001f\u0015\tafM\u0003\u00027O*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016f\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007C\u00017n\u0019\u0001!\u0011B\\\u0006\u0002\u0002\u0003\u0005)\u0011\u00019\u0003\u0007}#\u0013'\u0001\buS6,'oU2iK\u0012,H.\u001a\u0011\u0012\u0005E$\bC\u0001\u0018s\u0013\t\u0019xFA\u0004O_RD\u0017N\\4\u0011\u00059*\u0018B\u0001<0\u0005\r\te._\u0001\u0012i&lWM]*dQ\u0016$W\u000f\\3`I\u0015\fHCA=}!\tq#0\u0003\u0002|_\t!QK\\5u\u0011\u001di(\"!AA\u0002y\f1\u0001\u001f\u00132a\ry\u00181\u0001\t\u0005I&\f\t\u0001E\u0002m\u0003\u0007!\u0011B\u001c?\u0002\u0002\u0003\u0005)\u0011\u00019\u0002\u000f\u0011|7\u000b^1siR\t\u00110\u0001\u0004e_N#x\u000e]\u0001\bI>\u001cEn\\:f\u0003\u001d!wnV1uG\"\fq\u0002^8vG\"\u001cVm]:j_:TuN\u0019\u000b\u0005\u0003'\t)\u0003E\u0003/\u0003+\tI\"C\u0002\u0002\u0018=\u0012aa\u00149uS>t\u0007\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0011%A\u0003n_\u0012,G.\u0003\u0003\u0002$\u0005u!a\u0003&pEN#\u0018\r^;t\u0007ZCq!a\n\u0011\u0001\u0004\tI#A\u0004ue\u0006\u001c7.\u00133\u0011\t\u0005m\u00111F\u0005\u0005\u0003[\tiBA\u0004Ue\u0006\u001c7.\u00133)\t\u0005\u0015\u0012\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003w\tQA[1wCbLA!a\u0010\u00026\t9aj\u001c8ok2d\u0017A\u0005;pk\u000eD7+Z:tS>t\u0017\t\u001c7K_\n$B!!\u0012\u0002\\AA\u0011qIA+\u0003S\tIB\u0004\u0003\u0002J\u0005E\u0003cAA&_5\u0011\u0011Q\n\u0006\u0004\u0003\u001fZ\u0013A\u0002\u001fs_>$h(C\u0002\u0002T=\na\u0001\u0015:fI\u00164\u0017\u0002BA,\u00033\u00121!T1q\u0015\r\t\u0019f\f\u0005\b\u0003O\t\u0002\u0019AA\u0015\u0003M!x.^2i\u0003B\u0004H.[2bi&|gNS8c)\u0011\t\u0019\"!\u0019\t\u000f\u0005\u001d\"\u00031\u0001\u0002*!\"\u0011\u0011MA\u0019\u0003-)\b\u000fZ1uKN#\u0018\r^3\u0015\u000be\fI'a\u001b\t\u000f\u0005\u001d2\u00031\u0001\u0002*!9\u0011QN\nA\u0002\u0005e\u0011\u0001\u00036pEN#\u0018\r^3\u0002\u0015%tg-\u001a:Ti\u0006$X\r\u0006\u0003\u0002\u0014\u0005M\u0004bBA;)\u0001\u0007\u0011\u0011F\u0001\u0003S\u0012\fq\u0002\\5ti*{'m\u001d#fi\u0006LGn\u001d\u000b\u0005\u0003w\n\u0019\tE\u0003/\u0003+\ti\bE\u0002=\u0003\u007fJ1!!! \u0005)QuN\u0019#fi\u0006LGn\u001d\u0005\b\u0003\u000b+\u0002\u0019AAD\u0003)\u0019G.^:uKJ\\U-\u001f\t\u0005\u00037\tI)\u0003\u0003\u0002\f\u0006u!AC\"mkN$XM]&fs\u0006!2-\u00197m\u0015>\u00147o\u0014<feZLWm^:Ba&$B!a\u001f\u0002\u0012\"9\u00111\u0013\fA\u0002\u0005U\u0015a\u0002:fgR,&\u000f\u001c\t\u0005\u0003\u000f\n9*\u0003\u0003\u0002\u001a\u0006e#AB*ue&tw-\u0001\fj]\u001a,'o\u0015;bi\u00164%o\\7LqM,e/\u001a8u)\u0011\ty*a+\u0015\t\u0005M\u0011\u0011\u0015\u0005\b\u0003G;\u00029AAS\u00031\u0001x\u000e\u001c7F[&$H+[7f!\rq\u0013qU\u0005\u0004\u0003S{#\u0001\u0002'p]\u001eDq!a\n\u0018\u0001\u0004\tI\u0003\u000b\u0003\u0002,\u0006E\u0012!E5oM\u0016\u0014hI]8n!J,7)Y2iKR!\u00111WAe!\u0011\t),!1\u000f\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/\"\u0003\u0015)g.^7t\u0013\u0011\ty,!/\u0002\u001b\u0019c\u0017N\\6K_\n\u001cF/\u0019;f\u0013\u0011\t\u0019-!2\u0003\u000bY\u000bG.^3\n\u0007\u0005\u001dwFA\u0006F]VlWM]1uS>t\u0007bBAf1\u0001\u0007\u0011\u0011D\u0001\taJ,7)Y2iK\"\u001a\u0001!a4\u0011\t\u0005E\u0017Q[\u0007\u0003\u0003'T1\u0001XA\u001b\u0013\u0011\t9.a5\u0003\u0015QC'/Z1e'\u00064W-A\u000bGY&t7NS8c'R\fG/^:XCR\u001c\u0007.\u001a:\u0011\u0005qR2C\u0001\u000e.)\t\tY.A\u000fj]\u001a,'O\u00127j].TuNY*uCR,gI]8n!\u0016\u00148/[:u)\u0019\t\u0019,!:\u0002j\"9\u0011q\u001d\u000fA\u0002\u0005M\u0016aB2veJ,g\u000e\u001e\u0005\b\u0003Wd\u0002\u0019AAZ\u0003!\u0001(/\u001a<j_V\u001c\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r*\u001a\u0001)a=,\u0005\u0005U\b\u0003BA|\u0003\u007fl!!!?\u000b\t\u0005m\u0018Q`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000e0\u0013\u0011\u0011\t!!?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
@ThreadSafe
public class FlinkJobStatusWatcher
implements Logger,
FlinkWatcher {
    private final JobStatusWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private ScheduledFuture<?> timerSchedule;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private final int org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM;
    private final ScheduledThreadPoolExecutor watchExecutor;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    public static JobStatusWatcherConfig $lessinit$greater$default$1() {
        return FlinkJobStatusWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    public static Enumeration.Value inferFlinkJobStateFromPersist(Enumeration.Value value, Enumeration.Value value2) {
        return FlinkJobStatusWatcher$.MODULE$.inferFlinkJobStateFromPersist(value, value2);
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public int org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM;
    }

    @Override
    public ScheduledThreadPoolExecutor watchExecutor() {
        return this.watchExecutor;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM_$eq(int x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$CPU_NUM = x$1;
    }

    @Override
    public void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$watchExecutor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.watchExecutor = x$1;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.watchExecutor().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher started.");
    }

    @Override
    public void doStop() {
        Object object = !this.timerSchedule().isCancelled() ? BoxesRunTime.boxToBoolean((boolean)this.timerSchedule().cancel(true)) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher stopped.");
    }

    @Override
    public void doClose() {
        this.trackTaskExecutor().shutdownNow();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher closed.");
    }

    @Override
    public void doWatch() {
        Object object = new Object();
        try {
            FlinkJobStatusWatcher flinkJobStatusWatcher = this;
            synchronized (flinkJobStatusWatcher) {
                Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getAllWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                });
                Set appFuture = (Set)((SetLike)trackIds.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$doWatch$4(x$2)))).map((Function1 & Serializable & scala.Serializable)id -> {
                    void var2_2;
                    Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.touchApplicationJob((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                    future.onComplete((Function1 & Serializable & scala.Serializable)x$3 -> {
                        FlinkJobStatusWatcher.$anonfun$doWatch$7(this, id, x$3);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)this.trackTaskExecutor());
                    return var2_2;
                }, Set$.MODULE$.canBuildFrom());
                Set sessionIds = (Set)trackIds.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$doWatch$9(x$4)));
                Set sessionCluster = ((TraversableOnce)sessionIds.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toClusterKey().toString()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Set)x$6._2(), Iterable$.MODULE$.canBuildFrom())).toSet();
                Set sessionFuture = (Set)sessionCluster.map((Function1 & Serializable & scala.Serializable)trackId -> {
                    void var2_2;
                    Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.touchSessionAllJob((TrackId)trackId), (ExecutionContext)this.trackTaskExecutor());
                    future.onComplete((Function1 & Serializable & scala.Serializable)x$7 -> {
                        FlinkJobStatusWatcher.$anonfun$doWatch$14(this, trackId, x$7);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)this.trackTaskExecutor());
                    return var2_2;
                }, Set$.MODULE$.canBuildFrom());
                Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)appFuture, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$9 -> {
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("[FlinkJobStatusWatcher] tracking flink job status on kubernetes native application mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(10).append(" trackIds=").append(trackIds$1.mkString(",")).toString()).toString());
                    return BoxedUnit.UNIT;
                });
                Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)sessionFuture, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$10 -> {
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("[FlinkJobStatusWatcher] tracking flink job status on kubernetes native session mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(10).append(" trackIds=").append(trackIds$1.mkString(",")).toString()).toString());
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Option<JobStatusCV> touchSessionJob(@Nonnull TrackId trackId) {
        return this.touchSessionAllJob(trackId).find((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$touchSessionJob$1(trackId, id))).map((Function1 & Serializable & scala.Serializable)x$11 -> (JobStatusCV)x$11._2()).orElse((Function0 & Serializable & scala.Serializable)() -> this.inferState(trackId));
    }

    private Map<TrackId, JobStatusCV> touchSessionAllJob(TrackId trackId) {
        Map map;
        Some some;
        JobDetails details;
        long pollEmitTime = System.currentTimeMillis();
        Option<JobDetails> jobDetails = this.listJobsDetails(ClusterKey$.MODULE$.of(trackId));
        Option<JobDetails> option = jobDetails;
        if (option instanceof Some && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(details = (JobDetails)(some = (Some)option).value()).jobs())).nonEmpty()) {
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])details.jobs())).map((Function1 & Serializable & scala.Serializable)d -> {
                JobStatusCV jobStatus = d.toJobStatusCV(pollEmitTime, System.currentTimeMillis());
                String x$1 = d.jid();
                Object x$2 = null;
                Enumeration.Value x$3 = trackId.copy$default$1();
                String x$4 = trackId.copy$default$2();
                String x$5 = trackId.copy$default$3();
                String x$6 = trackId.copy$default$6();
                Properties x$7 = trackId.copy$default$7();
                TrackId trackItem = trackId.copy(x$3, x$4, x$5, null, x$1, x$6, x$7);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)trackItem), (Object)jobStatus);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        return map;
    }

    public Option<JobStatusCV> touchApplicationJob(@Nonnull TrackId trackId) {
        long pollEmitTime = System.currentTimeMillis();
        Option<JobDetails> jobDetails = this.listJobsDetails(ClusterKey$.MODULE$.of(trackId));
        return jobDetails.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((JobDetails)jobDetails.get()).jobs())).isEmpty() ? this.inferStateFromK8sEvent(trackId, pollEmitTime) : new Some((Object)((JobDetail)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((JobDetails)jobDetails.get()).jobs())).head()).toJobStatusCV(pollEmitTime, System.currentTimeMillis()));
    }

    private void updateState(TrackId trackId, JobStatusCV jobState) {
        JobStatusCV latest = this.watchController().jobStatuses().get(trackId);
        if (jobState.diff(latest)) {
            this.watchController().jobStatuses().put(trackId, jobState);
            this.watchController().trackIds().update(trackId);
            this.eventBus().postSync(new FlinkJobStatusChangeEvent(trackId, jobState));
        }
        if (FlinkJobState$.MODULE$.isEndState(jobState.jobState())) {
            Enumeration.Value value = trackId.executeMode();
            Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.APPLICATION();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                BoxedUnit boxedUnit;
                boolean deployExists = KubernetesRetriever$.MODULE$.isDeploymentExists(trackId.namespace(), trackId.clusterId());
                if (!deployExists) {
                    this.watchController().endpoints().invalidate(trackId.toClusterKey());
                    this.watchController().unWatching(trackId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                Enumeration.Value value4 = FlinkK8sExecuteMode$.MODULE$.SESSION();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    this.watchController().unWatching(trackId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Option<JobStatusCV> inferState(TrackId id) {
        pollEmitTime$lzy = new LazyLong();
        preCache = this.watchController().jobStatuses().get(id);
        v0 = state = this.inferFromPreCache(preCache);
        var6_5 = FlinkJobState$.MODULE$.SILENT();
        if ((v0 != null ? v0.equals(var6_5) == false : var6_5 != null) || preCache == null) ** GOTO lbl-1000
        v1 = preCache.jobState();
        var7_6 = FlinkJobState$.MODULE$.SILENT();
        if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = nonFirstSilent = false;
        }
        if (nonFirstSilent) {
            x$1 = state;
            x$2 = id.jobId();
            x$3 = preCache.pollEmitTime();
            x$4 = preCache.pollAckTime();
            x$5 = JobStatusCV$.MODULE$.apply$default$3();
            x$6 = JobStatusCV$.MODULE$.apply$default$4();
            x$7 = JobStatusCV$.MODULE$.apply$default$5();
            x$8 = JobStatusCV$.MODULE$.apply$default$6();
            x$9 = JobStatusCV$.MODULE$.apply$default$7();
            v3 = new JobStatusCV(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$3, x$4);
        } else {
            x$10 = state;
            x$11 = id.jobId();
            x$12 = FlinkJobStatusWatcher.pollEmitTime$2(pollEmitTime$lzy);
            x$13 = System.currentTimeMillis();
            x$14 = JobStatusCV$.MODULE$.apply$default$3();
            x$15 = JobStatusCV$.MODULE$.apply$default$4();
            x$16 = JobStatusCV$.MODULE$.apply$default$5();
            x$17 = JobStatusCV$.MODULE$.apply$default$6();
            x$18 = JobStatusCV$.MODULE$.apply$default$7();
            v3 = new JobStatusCV(x$10, x$11, x$14, x$15, x$16, x$17, x$18, x$12, x$13);
        }
        jobState = v3;
        return Option$.MODULE$.apply((Object)jobState);
    }

    private Option<JobDetails> listJobsDetails(ClusterKey clusterKey) {
        Option option;
        Object object = new Object();
        try {
            option = (Option)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String clusterRestUrl = (String)this.watchController().getClusterRestUrl(clusterKey).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$listJobsDetails$2(x$12))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                return this.callJobsOverviewsApi(clusterRestUrl);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Option option;
                this.logger().warn("Failed to visit remote flink jobs on kubernetes-native-mode cluster, and the retry access logic is performed.");
                String clusterRestUrl = (String)this.watchController().refreshClusterRestUrl(clusterKey).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.callJobsOverviewsApi(clusterRestUrl));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Option s = (Option)success.value();
                    this.logger().info("The retry is successful.");
                    option = s;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().warn(new StringBuilder(57).append("The retry fetch failed, final status failed, errorStack=").append(e.getMessage()).append(".").toString());
                    option = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
                return option;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<JobDetails> callJobsOverviewsApi(String restUrl) {
        return JobDetails$.MODULE$.as(Request.get((String)new StringBuilder(14).append(restUrl).append("/jobs/overview").toString()).connectTimeout(KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC()).execute().returnContent().asString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<JobStatusCV> inferStateFromK8sEvent(@Nonnull TrackId trackId, long pollEmitTime) {
        Some some;
        Enumeration.Value jobState;
        Enumeration.Value value;
        JobStatusCV latest;
        block10: {
            Enumeration.Value value2;
            block8: {
                boolean isConnection;
                block11: {
                    block9: {
                        latest = this.watchController().jobStatuses().get(trackId);
                        TrackId trackId2 = trackId;
                        if (!this.watchController().canceling().has(trackId2)) break block9;
                        this.logger().info(new StringBuilder(21).append("trackId ").append(trackId.toString()).append(" is canceling").toString());
                        this.watchController().trackIds().invalidate(trackId2);
                        value = FlinkJobState$.MODULE$.CANCELED();
                        break block10;
                    }
                    boolean deployExists = KubernetesRetriever$.MODULE$.isDeploymentExists(trackId.namespace(), trackId.clusterId());
                    isConnection = KubernetesDeploymentHelper$.MODULE$.checkConnection();
                    if (!deployExists) break block11;
                    boolean deployError = KubernetesDeploymentHelper$.MODULE$.isDeploymentError(trackId.namespace(), trackId.clusterId());
                    if (!deployError) {
                        this.logger().info("Task Enter the initialization process.");
                        value2 = FlinkJobState$.MODULE$.K8S_INITIALIZING();
                        break block8;
                    } else if (isConnection) {
                        this.logger().info("Enter the task failure deletion process.");
                        KubernetesDeploymentHelper$.MODULE$.watchPodTerminatedLog(trackId.namespace(), trackId.clusterId(), trackId.jobId());
                        value2 = FlinkJobState$.MODULE$.FAILED();
                        break block8;
                    } else {
                        value2 = this.inferFromPreCache(latest);
                    }
                    break block8;
                }
                if (isConnection) {
                    this.logger().info("The deployment is deleted and enters the task failure process.");
                    value2 = FlinkJobState$.MODULE$.of(FlinkHistoryArchives$.MODULE$.getJobStateFromArchiveFile(trackId));
                } else {
                    value2 = this.inferFromPreCache(latest);
                }
            }
            value = value2;
        }
        Enumeration.Value x$1 = jobState = value;
        String x$2 = trackId.jobId();
        long x$3 = pollEmitTime;
        long x$4 = System.currentTimeMillis();
        String x$5 = JobStatusCV$.MODULE$.apply$default$3();
        long x$6 = JobStatusCV$.MODULE$.apply$default$4();
        long x$7 = JobStatusCV$.MODULE$.apply$default$5();
        long x$8 = JobStatusCV$.MODULE$.apply$default$6();
        int x$9 = JobStatusCV$.MODULE$.apply$default$7();
        JobStatusCV jobStatusCV = new JobStatusCV(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$3, x$4);
        Enumeration.Value value3 = jobState;
        Enumeration.Value value4 = FlinkJobState$.MODULE$.SILENT();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null) && latest != null) {
            Enumeration.Value value5 = latest.jobState();
            Enumeration.Value value6 = FlinkJobState$.MODULE$.SILENT();
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                long x$10 = latest.pollEmitTime();
                long x$11 = latest.pollAckTime();
                Enumeration.Value x$12 = jobStatusCV.copy$default$1();
                String x$13 = jobStatusCV.copy$default$2();
                String x$14 = jobStatusCV.copy$default$3();
                long x$15 = jobStatusCV.copy$default$4();
                long x$16 = jobStatusCV.copy$default$5();
                long x$17 = jobStatusCV.copy$default$6();
                int x$18 = jobStatusCV.copy$default$7();
                Some some2 = new Some((Object)jobStatusCV.copy(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$10, x$11));
                some = some2;
                return some;
            }
        }
        some = new Some((Object)jobStatusCV);
        return some;
    }

    private Enumeration.Value inferFromPreCache(JobStatusCV preCache) {
        Enumeration.Value value;
        JobStatusCV jobStatusCV = preCache;
        if (jobStatusCV == null) {
            value = FlinkJobState$.MODULE$.SILENT();
        } else {
            Enumeration.Value value2 = jobStatusCV.jobState();
            Enumeration.Value value3 = FlinkJobState$.MODULE$.SILENT();
            value = !(value2 != null ? !value2.equals(value3) : value3 != null) && System.currentTimeMillis() - jobStatusCV.pollAckTime() >= (long)(this.conf.silentStateJobKeepTrackingSec() * 1000) ? FlinkJobState$.MODULE$.LOST() : FlinkJobState$.MODULE$.SILENT();
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$doWatch$4(TrackId x$2) {
        Enumeration.Value value = x$2.executeMode();
        Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.APPLICATION();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ void $anonfun$doWatch$7(FlinkJobStatusWatcher $this, TrackId id$1, Try x$3) {
        Option option = (Option)x$3.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobStatusCV jobState = (JobStatusCV)some.value();
            String x$1 = jobState.jobId();
            Enumeration.Value x$2 = id$1.copy$default$1();
            String x$32 = id$1.copy$default$2();
            String x$4 = id$1.copy$default$3();
            Long x$5 = id$1.copy$default$4();
            String x$6 = id$1.copy$default$6();
            Properties x$7 = id$1.copy$default$7();
            $this.updateState(id$1.copy(x$2, x$32, x$4, x$5, x$1, x$6, x$7), jobState);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$doWatch$9(TrackId x$4) {
        Enumeration.Value value = x$4.executeMode();
        Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.SESSION();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$doWatch$15(TrackId trackId$1, Tuple2 x$8) {
        String string = ((TrackId)x$8._1()).jobId();
        String string2 = trackId$1.jobId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$doWatch$14(FlinkJobStatusWatcher $this, TrackId trackId$1, Try x$7) {
        Option option = x$7.toOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            Option option2 = map.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$doWatch$15(trackId$1, x$8)));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Tuple2 job = (Tuple2)some2.value();
                Long x$82 = trackId$1.appId();
                Enumeration.Value x$9 = ((TrackId)job._1()).copy$default$1();
                String x$10 = ((TrackId)job._1()).copy$default$2();
                String x$11 = ((TrackId)job._1()).copy$default$3();
                String x$12 = ((TrackId)job._1()).copy$default$5();
                String x$13 = ((TrackId)job._1()).copy$default$6();
                Properties x$14 = ((TrackId)job._1()).copy$default$7();
                $this.updateState(((TrackId)job._1()).copy(x$9, x$10, x$11, x$82, x$12, x$13, x$14), (JobStatusCV)job._2());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Option<JobStatusCV> option3 = $this.touchSessionJob(trackId$1);
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    JobStatusCV state = (JobStatusCV)some3.value();
                    if (FlinkJobState$.MODULE$.isEndState(state.jobState())) {
                        $this.watchController().unWatching(trackId$1);
                    }
                    $this.eventBus().postSync(new FlinkJobStatusChangeEvent(trackId$1, state));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$touchSessionJob$1(TrackId trackId$2, Tuple2 id) {
        String string = ((TrackId)id._1()).jobId();
        String string2 = trackId$2.jobId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Enumeration.Value value = ((JobStatusCV)id._2()).jobState();
        Enumeration.Value value2 = FlinkJobState$.MODULE$.SILENT();
        if (value == null) {
            if (value2 == null) return false;
            return true;
        } else if (value.equals(value2)) return false;
        return true;
    }

    private static final /* synthetic */ long pollEmitTime$lzycompute$1(LazyLong pollEmitTime$lzy$1) {
        long l;
        LazyLong lazyLong = pollEmitTime$lzy$1;
        synchronized (lazyLong) {
            l = pollEmitTime$lzy$1.initialized() ? pollEmitTime$lzy$1.value() : pollEmitTime$lzy$1.initialize(System.currentTimeMillis());
        }
        return l;
    }

    private static final long pollEmitTime$2(LazyLong pollEmitTime$lzy$1) {
        return pollEmitTime$lzy$1.initialized() ? pollEmitTime$lzy$1.value() : FlinkJobStatusWatcher.pollEmitTime$lzycompute$1(pollEmitTime$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$listJobsDetails$2(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).nonEmpty();
    }

    public FlinkJobStatusWatcher(JobStatusWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        Logger.$init$((Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.watchExecutor());
    }
}

