/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.batch.builder;

import java.util.Optional;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.batch.MyBatisBatchItemWriter;
import org.springframework.core.convert.converter.Converter;

public class MyBatisBatchItemWriterBuilder<T> {
    private SqlSessionTemplate sqlSessionTemplate;
    private SqlSessionFactory sqlSessionFactory;
    private String statementId;
    private Boolean assertUpdates;
    private Converter<T, ?> itemToParameterConverter;

    public MyBatisBatchItemWriterBuilder<T> sqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
        return this;
    }

    public MyBatisBatchItemWriterBuilder<T> sqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public MyBatisBatchItemWriterBuilder<T> statementId(String statementId) {
        this.statementId = statementId;
        return this;
    }

    public MyBatisBatchItemWriterBuilder<T> assertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
        return this;
    }

    public MyBatisBatchItemWriterBuilder<T> itemToParameterConverter(Converter<T, ?> itemToParameterConverter) {
        this.itemToParameterConverter = itemToParameterConverter;
        return this;
    }

    public MyBatisBatchItemWriter<T> build() {
        MyBatisBatchItemWriter writer = new MyBatisBatchItemWriter();
        writer.setSqlSessionTemplate(this.sqlSessionTemplate);
        writer.setSqlSessionFactory(this.sqlSessionFactory);
        writer.setStatementId(this.statementId);
        Optional.ofNullable(this.assertUpdates).ifPresent(writer::setAssertUpdates);
        Optional.ofNullable(this.itemToParameterConverter).ifPresent(writer::setItemToParameterConverter);
        return writer;
    }
}

