/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.collect.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.collect.CollectorResult;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollectorException;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Maven31CollectorResult;
import org.apache.maven.shared.transfer.dependencies.collect.internal.MavenDependencyCollector;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.repository.RemoteRepository;

class Maven31DependencyCollector
implements MavenDependencyCollector {
    private final RepositorySystem repositorySystem;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> aetherRepositories;

    Maven31DependencyCollector(RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager, RepositorySystemSession session, List<RemoteRepository> aetherRepositories) {
        this.repositorySystem = repositorySystem;
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.aetherRepositories = aetherRepositories;
    }

    @Override
    public CollectorResult collectDependencies(Dependency root) throws DependencyCollectorException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        CollectRequest request = new CollectRequest();
        request.setRoot(Maven31DependencyCollector.toDependency(root, typeRegistry));
        return this.collectDependencies(request);
    }

    @Override
    public CollectorResult collectDependencies(DependableCoordinate root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getType());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), root.getClassifier(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)aetherArtifact, null));
        return this.collectDependencies(request);
    }

    @Override
    public CollectorResult collectDependencies(Model root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)aetherArtifact, null));
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        ArrayList<org.eclipse.aether.graph.Dependency> aetherDependencies = new ArrayList<org.eclipse.aether.graph.Dependency>(root.getDependencies().size());
        for (Dependency mavenDependency : root.getDependencies()) {
            aetherDependencies.add(Maven31DependencyCollector.toDependency(mavenDependency, typeRegistry));
        }
        request.setDependencies(aetherDependencies);
        if (root.getDependencyManagement() != null) {
            ArrayList<org.eclipse.aether.graph.Dependency> aetherManagerDependencies = new ArrayList<org.eclipse.aether.graph.Dependency>(root.getDependencyManagement().getDependencies().size());
            for (Dependency mavenDependency : root.getDependencyManagement().getDependencies()) {
                aetherManagerDependencies.add(Maven31DependencyCollector.toDependency(mavenDependency, typeRegistry));
            }
            request.setManagedDependencies(aetherManagerDependencies);
        }
        return this.collectDependencies(request);
    }

    private CollectorResult collectDependencies(CollectRequest request) throws DependencyCollectorException {
        request.setRepositories(this.aetherRepositories);
        try {
            return new Maven31CollectorResult(this.repositorySystem.collectDependencies(this.session, request));
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    private static org.eclipse.aether.graph.Dependency toDependency(Dependency root, ArtifactTypeRegistry typeRegistry) throws DependencyCollectorException {
        Class[] argClasses = new Class[]{Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{root, typeRegistry};
        return (org.eclipse.aether.graph.Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
    }
}

