/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.service.ApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/history"})
public class ApplicationHistoryController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationHistoryController.class);
    @Autowired
    private ApplicationService applicationService;

    @PostMapping(value={"uploadJars"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listUploadJars() {
        List<String> jars = this.applicationService.historyUploadJars();
        return RestResponse.success(jars);
    }

    @PostMapping(value={"k8sNamespaces"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listK8sNamespace() {
        List<String> namespaces = this.applicationService.getRecentK8sNamespace();
        return RestResponse.success(namespaces);
    }

    @PostMapping(value={"k8sClusterId"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse recentK8sClusterId() {
        List<String> clusterIds = this.applicationService.getRecentK8sClusterId();
        return RestResponse.success(clusterIds);
    }

    @PostMapping(value={"flinkBaseImages"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listFlinkBaseImage() {
        List<String> images = this.applicationService.getRecentFlinkBaseImage();
        return RestResponse.success(images);
    }

    @PostMapping(value={"flinkPodTemplates"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listPodTemplate() {
        List<String> templates = this.applicationService.getRecentK8sPodTemplate();
        return RestResponse.success(templates);
    }

    @PostMapping(value={"flinkJmPodTemplates"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listJmPodTemplate() {
        List<String> templates = this.applicationService.getRecentK8sJmPodTemplate();
        return RestResponse.success(templates);
    }

    @PostMapping(value={"flinkTmPodTemplates"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listTmPodTemplate() {
        List<String> templates = this.applicationService.getRecentK8sTmPodTemplate();
        return RestResponse.success(templates);
    }
}

