/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.common.util.HttpClientUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.enums.StopFrom;
import org.apache.streampark.console.core.metrics.flink.CheckPoints;
import org.apache.streampark.console.core.metrics.flink.JobsOverview;
import org.apache.streampark.console.core.metrics.flink.Overview;
import org.apache.streampark.console.core.metrics.yarn.YarnAppInfo;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.SavepointService;
import org.apache.streampark.console.core.service.alert.AlertService;
import org.apache.streampark.console.core.task.CheckpointProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FlinkAppHttpWatcher {
    private static final Logger log = LoggerFactory.getLogger(FlinkAppHttpWatcher.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private AlertService alertService;
    @Autowired
    private CheckpointProcessor checkpointProcessor;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private SavepointService savepointService;
    private static final long WATCHING_INTERVAL = 5000L;
    private static final long OPTION_INTERVAL = 10000L;
    private static final int HTTP_TIMEOUT = 5000;
    private static final Cache<Long, Byte> SAVEPOINT_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Cache<Long, Byte> STARTING_CACHE = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Cache<Long, Date> LOST_CACHE = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Map<Long, Application> WATCHING_APPS = new ConcurrentHashMap<Long, Application>(0);
    private static final Map<Long, StopFrom> STOP_FROM_MAP = new ConcurrentHashMap<Long, StopFrom>(0);
    private static final Cache<Long, Byte> CANCELING_CACHE = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Cache<Long, StateChangeEvent> PREVIOUS_STATUS = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build();
    private static final Map<Long, Long> CANCELLED_JOB_MAP = new ConcurrentHashMap<Long, Long>(0);
    private static final Map<Long, FlinkCluster> FLINK_CLUSTER_MAP = new ConcurrentHashMap<Long, FlinkCluster>(0);
    private static final Map<Long, OptionState> OPTIONING = new ConcurrentHashMap<Long, OptionState>(0);
    private Long lastWatchingTime = 0L;
    private Long lastOptionTime = 0L;
    private static final Byte DEFAULT_FLAG_BYTE = Byte.valueOf("0");
    private static final int CPU_NUM = Math.max(4, Runtime.getRuntime().availableProcessors() * 2);
    private static final ExecutorService watchExecutor = new ThreadPoolExecutor(CPU_NUM, CPU_NUM * 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-flink-app-watching"));

    @PostConstruct
    public void initialize() {
        WATCHING_APPS.clear();
        List applications = this.applicationService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Application::getTracking, (Object)1)).notIn(Application::getExecutionMode, (Collection)ExecutionMode.getKubernetesMode()));
        applications.forEach(app -> WATCHING_APPS.put(app.getId(), (Application)app));
    }

    @PreDestroy
    public void doStop() {
        log.info("[StreamPark][FlinkAppHttpWatcher] StreamPark Console will be shutdown,persistent application to database.");
        WATCHING_APPS.forEach((k, v) -> this.applicationService.persistMetrics((Application)v));
    }

    @Scheduled(fixedDelay=1000L)
    public void start() {
        if (this.lastWatchingTime == null || !OPTIONING.isEmpty()) {
            this.watch();
        } else if (System.currentTimeMillis() - this.lastOptionTime <= 10000L) {
            this.watch();
        } else if (System.currentTimeMillis() - this.lastWatchingTime >= 5000L) {
            this.watch();
        }
    }

    private void watch() {
        this.lastWatchingTime = System.currentTimeMillis();
        for (Application application : WATCHING_APPS.values()) {
            watchExecutor.execute(() -> {
                try {
                    this.getFromFlinkRestApi(application);
                    this.cleanupLost(application);
                }
                catch (Exception flinkException) {
                    log.warn("[StreamPark] get state from flink failed ", (Throwable)flinkException);
                    try {
                        this.getFromYarnRestApi(application);
                        this.cleanupLost(application);
                    }
                    catch (Exception yarnException) {
                        log.error("[StreamPark] get state from yarn failed :", (Throwable)flinkException);
                        this.doStateFailed(application);
                    }
                }
            });
        }
    }

    private void cleanupLost(Application application) {
        LOST_CACHE.invalidate((Object)application.getId());
    }

    private void doStateFailed(Application application) {
        StopFrom stopFrom = this.getStopFrom(application);
        OptionState optionState = OPTIONING.get(application.getId());
        if (optionState == null || !optionState.equals(OptionState.STARTING)) {
            if (application.getState().intValue() != FlinkAppState.MAPPING.getValue()) {
                log.error("[StreamPark][FlinkAppHttpWatcher] getFromFlinkRestApi and getFromYarnRestApi error,job failed,savepoint expired!");
                if (StopFrom.NONE.equals(stopFrom)) {
                    Date lostTime = (Date)LOST_CACHE.getIfPresent((Object)application.getId());
                    if (lostTime == null) {
                        LOST_CACHE.put((Object)application.getId(), (Object)new Date());
                    } else if (DateUtils.toSecondDuration((Date)lostTime, (Date)new Date()) >= 30L) {
                        this.savepointService.expire(application.getId());
                        application.setState(FlinkAppState.LOST.getValue());
                        WATCHING_APPS.remove(application.getId());
                        LOST_CACHE.invalidate((Object)application.getId());
                    }
                } else {
                    application.setState(FlinkAppState.CANCELED.getValue());
                }
            }
            application.setEndTime(new Date());
            this.cleanSavepoint(application);
            this.cleanOptioning(optionState, application.getId());
            this.doPersistMetrics(application, true);
            FlinkAppState appState = application.getFlinkAppStateEnum();
            if (appState.equals(FlinkAppState.FAILED) || appState.equals(FlinkAppState.LOST)) {
                this.alertService.alert(application, application.getFlinkAppStateEnum());
                if (appState.equals(FlinkAppState.FAILED)) {
                    try {
                        this.applicationService.start(application, true);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void getFromFlinkRestApi(Application application) throws Exception {
        JobsOverview.Job jobOverview;
        FlinkAppState currentState;
        StopFrom stopFrom = this.getStopFrom(application);
        JobsOverview jobsOverview = this.httpJobsOverview(application);
        ExecutionMode execMode = application.getExecutionModeEnum();
        Optional<Object> optional = ExecutionMode.YARN_APPLICATION.equals((Object)execMode) || ExecutionMode.YARN_PER_JOB.equals((Object)execMode) ? (jobsOverview.getJobs().size() > 1 ? jobsOverview.getJobs().stream().filter(a -> StringUtils.equals((CharSequence)application.getJobId(), (CharSequence)a.getId())).findFirst() : jobsOverview.getJobs().stream().findFirst()) : jobsOverview.getJobs().stream().filter(x -> x.getId().equals(application.getJobId())).findFirst();
        if (optional.isPresent() && !FlinkAppState.OTHER.equals(currentState = FlinkAppState.of((jobOverview = (JobsOverview.Job)optional.get()).getState()))) {
            try {
                this.handleJobOverview(application, jobOverview);
            }
            catch (Exception e) {
                log.error("get flink jobOverview error: {}", (Object)e.getMessage(), (Object)e);
            }
            try {
                this.handleCheckPoints(application);
            }
            catch (Exception e) {
                log.error("get flink jobOverview error: {}", (Object)e.getMessage(), (Object)e);
            }
            OptionState optionState = OPTIONING.get(application.getId());
            if (currentState.equals(FlinkAppState.RUNNING)) {
                this.handleRunningState(application, optionState, currentState);
            } else {
                this.handleNotRunState(application, optionState, currentState, stopFrom);
            }
        }
    }

    private StopFrom getStopFrom(Application application) {
        return STOP_FROM_MAP.getOrDefault(application.getId(), null) == null ? StopFrom.NONE : STOP_FROM_MAP.get(application.getId());
    }

    private void handleJobOverview(Application application, JobsOverview.Job jobOverview) throws IOException {
        long startTime = jobOverview.getStartTime();
        long endTime = jobOverview.getEndTime();
        if (application.getStartTime() == null || startTime != application.getStartTime().getTime()) {
            application.setStartTime(new Date(startTime));
        }
        if (endTime != -1L && (application.getEndTime() == null || endTime != application.getEndTime().getTime())) {
            application.setEndTime(new Date(endTime));
        }
        application.setJobId(jobOverview.getId());
        application.setDuration(jobOverview.getDuration());
        application.setTotalTask(jobOverview.getTasks().getTotal());
        application.setOverview(jobOverview.getTasks());
        if (STARTING_CACHE.getIfPresent((Object)application.getId()) != null) {
            Overview override = this.httpOverview(application);
            if (override != null && override.getSlotsTotal() > 0) {
                application.setTotalTM(override.getTaskmanagers());
                application.setTotalSlot(override.getSlotsTotal());
                application.setAvailableSlot(override.getSlotsAvailable());
            }
            STARTING_CACHE.invalidate((Object)application.getId());
        }
    }

    private void handleCheckPoints(Application application) throws Exception {
        CheckPoints checkPoints = this.httpCheckpoints(application);
        if (checkPoints != null) {
            this.checkpointProcessor.process(application, checkPoints);
        }
    }

    private void handleRunningState(Application application, OptionState optionState, FlinkAppState currentState) {
        Long appId = application.getId();
        if (OptionState.STARTING.equals(optionState)) {
            Application latestApp = WATCHING_APPS.get(appId);
            ReleaseState releaseState = latestApp.getReleaseState();
            switch (releaseState) {
                case NEED_RESTART: 
                case NEED_ROLLBACK: {
                    LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(Application::getId, (Object)appId)).set(Application::getRelease, (Object)ReleaseState.DONE.get());
                    this.applicationService.update((Wrapper)updateWrapper);
                    break;
                }
            }
        }
        if (SAVEPOINT_CACHE.getIfPresent((Object)appId) != null) {
            application.setOptionState(OptionState.SAVEPOINTING.getValue());
        } else {
            application.setOptionState(OptionState.NONE.getValue());
        }
        application.setState(currentState.getValue());
        this.doPersistMetrics(application, false);
        this.cleanOptioning(optionState, appId);
    }

    private void doPersistMetrics(Application application, boolean stopWatch) {
        Long appId = application.getId();
        if (FlinkAppState.isEndState(application.getState())) {
            application.setOverview(null);
            application.setTotalTM(null);
            application.setTotalSlot(null);
            application.setTotalTask(null);
            application.setAvailableSlot(null);
            application.setJmMemory(null);
            application.setTmMemory(null);
            FlinkAppHttpWatcher.unWatching(appId);
        } else if (stopWatch) {
            FlinkAppHttpWatcher.unWatching(appId);
        } else {
            WATCHING_APPS.put(appId, application);
        }
        StateChangeEvent event = (StateChangeEvent)PREVIOUS_STATUS.getIfPresent((Object)appId);
        StateChangeEvent nowEvent = StateChangeEvent.of(application);
        if (!nowEvent.equals(event)) {
            PREVIOUS_STATUS.put((Object)appId, (Object)nowEvent);
            this.applicationService.persistMetrics(application);
        }
    }

    private void handleNotRunState(Application application, OptionState optionState, FlinkAppState currentState, StopFrom stopFrom) throws Exception {
        switch (currentState) {
            case CANCELLING: {
                CANCELING_CACHE.put((Object)application.getId(), (Object)DEFAULT_FLAG_BYTE);
                this.cleanSavepoint(application);
                application.setState(currentState.getValue());
                this.doPersistMetrics(application, false);
                break;
            }
            case CANCELED: {
                log.info("[StreamPark][FlinkAppHttpWatcher] getFromFlinkRestApi, job state {}, stop tracking and delete stopFrom!", (Object)currentState.name());
                this.cleanSavepoint(application);
                application.setState(currentState.getValue());
                if (StopFrom.NONE.equals(stopFrom) || this.applicationService.checkAlter(application)) {
                    if (StopFrom.NONE.equals(stopFrom)) {
                        log.info("[StreamPark][FlinkAppHttpWatcher] getFromFlinkRestApi, job cancel is not form StreamPark,savepoint expired!");
                        this.savepointService.expire(application.getId());
                    }
                    FlinkAppHttpWatcher.stopCanceledJob(application.getId());
                    this.alertService.alert(application, FlinkAppState.CANCELED);
                }
                STOP_FROM_MAP.remove(application.getId());
                this.doPersistMetrics(application, true);
                this.cleanOptioning(optionState, application.getId());
                break;
            }
            case FAILED: {
                this.cleanSavepoint(application);
                STOP_FROM_MAP.remove(application.getId());
                application.setState(FlinkAppState.FAILED.getValue());
                this.doPersistMetrics(application, true);
                this.alertService.alert(application, FlinkAppState.FAILED);
                this.applicationService.start(application, true);
                break;
            }
            case RESTARTING: {
                log.info("[StreamPark][FlinkAppHttpWatcher] getFromFlinkRestApi, job state {},add to starting", (Object)currentState.name());
                STARTING_CACHE.put((Object)application.getId(), (Object)DEFAULT_FLAG_BYTE);
                break;
            }
            default: {
                application.setState(currentState.getValue());
                this.doPersistMetrics(application, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getFromYarnRestApi(Application application) throws Exception {
        log.debug("[StreamPark][FlinkAppHttpWatcher] getFromYarnRestApi starting...");
        StopFrom stopFrom = this.getStopFrom(application);
        OptionState optionState = OPTIONING.get(application.getId());
        Byte flag = (Byte)CANCELING_CACHE.getIfPresent((Object)application.getId());
        if (flag != null) {
            log.info("[StreamPark][FlinkAppHttpWatcher] previous state: canceling.");
            FlinkAppState flinkAppState = FlinkAppState.CANCELED;
            try {
                YarnAppInfo yarnAppInfo = this.httpYarnAppInfo(application);
                if (yarnAppInfo == null) return;
                String state = yarnAppInfo.getApp().getFinalStatus();
                flinkAppState = FlinkAppState.of(state);
                return;
            }
            finally {
                if (StopFrom.NONE.equals(stopFrom)) {
                    log.error("[StreamPark][FlinkAppHttpWatcher] query previous state was canceling and stopFrom NotFound,savepoint expired!");
                    this.savepointService.expire(application.getId());
                    if (flinkAppState == FlinkAppState.KILLED || flinkAppState == FlinkAppState.FAILED) {
                        this.alertService.alert(application, flinkAppState);
                    }
                }
                application.setState(flinkAppState.getValue());
                this.cleanSavepoint(application);
                this.cleanOptioning(optionState, application.getId());
                this.doPersistMetrics(application, true);
            }
        }
        YarnAppInfo yarnAppInfo = this.httpYarnAppInfo(application);
        if (yarnAppInfo == null) {
            if (ExecutionMode.REMOTE.equals((Object)application.getExecutionModeEnum())) return;
            throw new RuntimeException("[StreamPark][FlinkAppHttpWatcher] getFromYarnRestApi failed ");
        }
        try {
            String state = yarnAppInfo.getApp().getFinalStatus();
            FlinkAppState flinkAppState = FlinkAppState.of(state);
            if (FlinkAppState.OTHER.equals(flinkAppState)) {
                String trackingUrl = yarnAppInfo.getApp().getTrackingUrl();
                if (trackingUrl == null || trackingUrl.equals(application.getJobManagerUrl())) return;
                application.setJobManagerUrl(trackingUrl);
                this.applicationService.updateJobManagerUrl(application.getId(), trackingUrl);
                this.applicationLogService.updateJobManagerUrl(application.getClusterId(), trackingUrl);
                return;
            }
            if (FlinkAppState.KILLED.equals(flinkAppState)) {
                if (StopFrom.NONE.equals(stopFrom)) {
                    log.error("[StreamPark][FlinkAppHttpWatcher] getFromYarnRestApi,job was killed and stopFrom NotFound,savepoint expired!");
                    this.savepointService.expire(application.getId());
                }
                flinkAppState = FlinkAppState.CANCELED;
                this.cleanSavepoint(application);
                application.setEndTime(new Date());
            }
            if (FlinkAppState.SUCCEEDED.equals(flinkAppState)) {
                flinkAppState = FlinkAppState.FINISHED;
            }
            application.setState(flinkAppState.getValue());
            this.cleanOptioning(optionState, application.getId());
            this.doPersistMetrics(application, true);
            if (!flinkAppState.equals(FlinkAppState.FAILED) && !flinkAppState.equals(FlinkAppState.LOST) && (!flinkAppState.equals(FlinkAppState.CANCELED) || !StopFrom.NONE.equals(stopFrom)) && !this.applicationService.checkAlter(application)) return;
            this.alertService.alert(application, flinkAppState);
            FlinkAppHttpWatcher.stopCanceledJob(application.getId());
            if (!flinkAppState.equals(FlinkAppState.FAILED)) return;
            this.applicationService.start(application, true);
            return;
        }
        catch (Exception e) {
            if (ExecutionMode.REMOTE.equals((Object)application.getExecutionModeEnum())) return;
            throw new RuntimeException("[StreamPark][FlinkAppHttpWatcher] getFromYarnRestApi error,", e);
        }
    }

    private void cleanOptioning(OptionState optionState, Long key) {
        if (optionState != null) {
            this.lastOptionTime = System.currentTimeMillis();
            OPTIONING.remove(key);
        }
    }

    public void cleanSavepoint(Application application) {
        application.setOptionState(OptionState.NONE.getValue());
        StateChangeEvent event = (StateChangeEvent)PREVIOUS_STATUS.getIfPresent((Object)application.getId());
        if (event != null && event.getOptionState() == OptionState.SAVEPOINTING) {
            this.doPersistMetrics(application, false);
        }
        SAVEPOINT_CACHE.invalidate((Object)application.getId());
    }

    public static void setOptionState(Long appId, OptionState state) {
        if (FlinkAppHttpWatcher.isKubernetesApp(appId)) {
            return;
        }
        log.info("[StreamPark][FlinkAppHttpWatcher] setOptioning");
        OPTIONING.put(appId, state);
        if (state.equals(OptionState.CANCELLING)) {
            STOP_FROM_MAP.put(appId, StopFrom.STREAMPARK);
        }
    }

    public static void doWatching(Application application) {
        if (application.isKubernetesModeJob()) {
            return;
        }
        log.info("[StreamPark][FlinkAppHttpWatcher] add app to tracking,appId:{}", (Object)application.getId());
        WATCHING_APPS.put(application.getId(), application);
        STARTING_CACHE.put((Object)application.getId(), (Object)DEFAULT_FLAG_BYTE);
    }

    public static void addSavepoint(Long appId) {
        if (FlinkAppHttpWatcher.isKubernetesApp(appId)) {
            return;
        }
        log.info("[StreamPark][FlinkAppHttpWatcher] add app to savepoint,appId:{}", (Object)appId);
        SAVEPOINT_CACHE.put((Object)appId, (Object)DEFAULT_FLAG_BYTE);
        StateChangeEvent event = (StateChangeEvent)PREVIOUS_STATUS.getIfPresent((Object)appId);
        if (event != null) {
            event.setOptionState(OptionState.SAVEPOINTING);
            PREVIOUS_STATUS.put((Object)appId, (Object)event);
        }
    }

    public static void unWatching(Long appId) {
        if (FlinkAppHttpWatcher.isKubernetesApp(appId)) {
            return;
        }
        log.info("[StreamPark][FlinkAppHttpWatcher] stop app,appId:{}", (Object)appId);
        WATCHING_APPS.remove(appId);
    }

    public static void stopCanceledJob(Long appId) {
        if (!CANCELLED_JOB_MAP.containsKey(appId)) {
            return;
        }
        log.info("flink job canceled app appId:{} by useId:{}", (Object)appId, (Object)CANCELLED_JOB_MAP.get(appId));
        CANCELLED_JOB_MAP.remove(appId);
    }

    public static void addCanceledApp(Long appId, Long userId) {
        log.info("flink job addCanceledApp app appId:{}, useId:{}", (Object)appId, (Object)userId);
        CANCELLED_JOB_MAP.put(appId, userId);
    }

    public static Long getCanceledJobUserId(Long appId) {
        return CANCELLED_JOB_MAP.get(appId) == null ? Long.valueOf(-1L) : CANCELLED_JOB_MAP.get(appId);
    }

    public static Collection<Application> getWatchingApps() {
        return WATCHING_APPS.values();
    }

    private static boolean isKubernetesApp(Long appId) {
        Application app = WATCHING_APPS.get(appId);
        if (app == null) {
            return false;
        }
        return app.isKubernetesModeJob();
    }

    private YarnAppInfo httpYarnAppInfo(Application application) throws Exception {
        String reqURL = "ws/v1/cluster/apps/".concat(application.getClusterId());
        return this.yarnRestRequest(reqURL, YarnAppInfo.class);
    }

    private Overview httpOverview(Application application) throws IOException {
        String appId = application.getClusterId();
        if (appId != null && (application.getExecutionModeEnum().equals((Object)ExecutionMode.YARN_APPLICATION) || application.getExecutionModeEnum().equals((Object)ExecutionMode.YARN_PER_JOB))) {
            String reqURL;
            if (StringUtils.isEmpty((CharSequence)application.getJobManagerUrl())) {
                String format = "proxy/%s/overview";
                reqURL = String.format(format, appId);
            } else {
                String format = "%s/overview";
                reqURL = String.format(format, application.getJobManagerUrl());
            }
            return this.yarnRestRequest(reqURL, Overview.class);
        }
        return null;
    }

    private JobsOverview httpJobsOverview(Application application) throws Exception {
        String flinkUrl = "jobs/overview";
        ExecutionMode execMode = application.getExecutionModeEnum();
        if (ExecutionMode.isYarnMode((ExecutionMode)execMode)) {
            String reqURL;
            if (StringUtils.isEmpty((CharSequence)application.getJobManagerUrl())) {
                String format = "proxy/%s/jobs/overview";
                reqURL = String.format(format, application.getClusterId());
            } else {
                String format = "%s/jobs/overview";
                reqURL = String.format(format, application.getJobManagerUrl());
            }
            return this.yarnRestRequest(reqURL, JobsOverview.class);
        }
        if (application.getJobId() != null && ExecutionMode.isRemoteMode((ExecutionMode)execMode)) {
            return this.httpRemoteCluster(application.getFlinkClusterId(), cluster -> {
                String remoteUrl = cluster.getAddress() + "/" + "jobs/overview";
                JobsOverview jobsOverview = this.httpRestRequest(remoteUrl, JobsOverview.class);
                if (jobsOverview != null) {
                    List<JobsOverview.Job> jobs = jobsOverview.getJobs().stream().filter(x -> x.getId().equals(application.getJobId())).collect(Collectors.toList());
                    jobsOverview.setJobs(jobs);
                }
                return jobsOverview;
            });
        }
        return null;
    }

    private CheckPoints httpCheckpoints(Application application) throws Exception {
        String flinkUrl = "jobs/%s/checkpoints";
        ExecutionMode execMode = application.getExecutionModeEnum();
        if (ExecutionMode.isYarnMode((ExecutionMode)execMode)) {
            String reqURL;
            if (StringUtils.isEmpty((CharSequence)application.getJobManagerUrl())) {
                String format = "proxy/%s/jobs/%s/checkpoints";
                reqURL = String.format(format, application.getClusterId(), application.getJobId());
            } else {
                String format = "%s/jobs/%s/checkpoints";
                reqURL = String.format(format, application.getJobManagerUrl(), application.getJobId());
            }
            return this.yarnRestRequest(reqURL, CheckPoints.class);
        }
        if (application.getJobId() != null && ExecutionMode.isRemoteMode((ExecutionMode)execMode)) {
            return this.httpRemoteCluster(application.getFlinkClusterId(), cluster -> {
                String remoteUrl = cluster.getAddress() + "/" + String.format("jobs/%s/checkpoints", application.getJobId());
                return this.httpRestRequest(remoteUrl, CheckPoints.class);
            });
        }
        return null;
    }

    private <T> T yarnRestRequest(String url, Class<T> clazz) throws IOException {
        String result = YarnUtils.restRequest((String)url, (int)5000);
        return JacksonUtils.read(result, clazz);
    }

    private <T> T httpRestRequest(String url, Class<T> clazz) throws IOException {
        String result = HttpClientUtils.httpGetRequest((String)url, (RequestConfig)RequestConfig.custom().setConnectTimeout(5000).build());
        if (null == result) {
            return null;
        }
        return JacksonUtils.read(result, clazz);
    }

    public boolean isWatchingApp(Long id) {
        return WATCHING_APPS.containsKey(id);
    }

    private <T> T httpRemoteCluster(Long clusterId, Callback<FlinkCluster, T> function) throws Exception {
        FlinkCluster flinkCluster = this.getFlinkRemoteCluster(clusterId, false);
        try {
            return function.call(flinkCluster);
        }
        catch (Exception e) {
            flinkCluster = this.getFlinkRemoteCluster(clusterId, true);
            return function.call(flinkCluster);
        }
    }

    private FlinkCluster getFlinkRemoteCluster(Long clusterId, boolean flush) {
        FlinkCluster flinkCluster = FLINK_CLUSTER_MAP.get(clusterId);
        if (flinkCluster == null || flush) {
            flinkCluster = (FlinkCluster)this.flinkClusterService.getById(clusterId);
            FLINK_CLUSTER_MAP.put(clusterId, flinkCluster);
        }
        return flinkCluster;
    }

    static class StateChangeEvent {
        private Long id;
        private String jobId;
        private FlinkAppState appState;
        private OptionState optionState;
        private String jobManagerUrl;

        StateChangeEvent() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StateChangeEvent that = (StateChangeEvent)object;
            return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.appState, that.appState) && Objects.equals(this.optionState, that.optionState) && Objects.equals(this.jobManagerUrl, that.jobManagerUrl);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.jobId, this.appState, this.optionState, this.jobManagerUrl);
        }

        public static StateChangeEvent of(Application application) {
            StateChangeEvent event = new StateChangeEvent();
            event.setId(application.getId());
            event.setOptionState(OptionState.of(application.getOptionState()));
            event.setAppState(application.getFlinkAppStateEnum());
            event.setJobId(application.getJobId());
            event.setJobManagerUrl(application.getJobManagerUrl());
            return event;
        }

        public Long getId() {
            return this.id;
        }

        public String getJobId() {
            return this.jobId;
        }

        public FlinkAppState getAppState() {
            return this.appState;
        }

        public OptionState getOptionState() {
            return this.optionState;
        }

        public String getJobManagerUrl() {
            return this.jobManagerUrl;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public void setAppState(FlinkAppState appState) {
            this.appState = appState;
        }

        public void setOptionState(OptionState optionState) {
            this.optionState = optionState;
        }

        public void setJobManagerUrl(String jobManagerUrl) {
            this.jobManagerUrl = jobManagerUrl;
        }
    }

    static interface Callback<T, R> {
        public R call(T var1) throws Exception;
    }
}

