/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.ListKeyGroupedIterator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class GroupReduceOperatorBase<IN, OUT, FT extends GroupReduceFunction<IN, OUT>>
extends SingleInputOperator<IN, OUT, FT> {
    private Ordering groupOrder;
    private boolean combinable;
    private Partitioner<?> customPartitioner;

    public GroupReduceOperatorBase(UserCodeWrapper<FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, int[] keyPositions, String name) {
        super(udf, operatorInfo, keyPositions, name);
    }

    public GroupReduceOperatorBase(FT udf, UnaryOperatorInformation<IN, OUT> operatorInfo, int[] keyPositions, String name) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions, name);
    }

    public GroupReduceOperatorBase(Class<? extends FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, int[] keyPositions, String name) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, keyPositions, name);
    }

    public GroupReduceOperatorBase(UserCodeWrapper<FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(udf, operatorInfo, name);
    }

    public GroupReduceOperatorBase(FT udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, name);
    }

    public GroupReduceOperatorBase(Class<? extends FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, name);
    }

    public void setGroupOrder(Ordering order) {
        this.groupOrder = order;
    }

    public Ordering getGroupOrder() {
        return this.groupOrder;
    }

    public void setCombinable(boolean combinable) {
        if (combinable && !GroupCombineFunction.class.isAssignableFrom(this.userFunction.getUserCodeClass())) {
            throw new IllegalArgumentException("Cannot set a UDF as combinable if it does not implement the interface " + GroupCombineFunction.class.getName());
        }
        this.combinable = combinable;
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public void setCustomPartitioner(Partitioner<?> customPartitioner) {
        if (customPartitioner != null) {
            int[] keys = this.getKeyColumns(0);
            if (keys == null || keys.length == 0) {
                throw new IllegalArgumentException("Cannot use custom partitioner for a non-grouped GroupReduce (AllGroupReduce)");
            }
            if (keys.length > 1) {
                throw new IllegalArgumentException("Cannot use the key partitioner for composite keys (more than one key field)");
            }
        }
        this.customPartitioner = customPartitioner;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    private TypeComparator<IN> getTypeComparator(TypeInformation<IN> typeInfo, int[] sortColumns, boolean[] sortOrderings, ExecutionConfig executionConfig) {
        if (typeInfo instanceof CompositeType) {
            return ((CompositeType)typeInfo).createComparator(sortColumns, sortOrderings, 0, executionConfig);
        }
        if (typeInfo instanceof AtomicType) {
            return ((AtomicType)((Object)typeInfo)).createComparator(sortOrderings[0], executionConfig);
        }
        throw new InvalidProgramException("Input type of GroupReduce must be one of composite types or atomic types.");
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN> inputData, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        int[] keyColumns;
        GroupReduceFunction function = (GroupReduceFunction)this.userFunction.getUserCodeObject();
        OperatorInformation operatorInfo = this.getOperatorInfo();
        TypeInformation inputType = ((UnaryOperatorInformation)operatorInfo).getInputType();
        int[] sortColumns = keyColumns = this.getKeyColumns(0);
        boolean[] sortOrderings = new boolean[sortColumns.length];
        if (this.groupOrder != null) {
            sortColumns = ArrayUtils.addAll((int[])sortColumns, (int[])this.groupOrder.getFieldPositions());
            sortOrderings = ArrayUtils.addAll((boolean[])sortOrderings, (boolean[])this.groupOrder.getFieldSortDirections());
        }
        if (sortColumns.length == 0) {
            Preconditions.checkArgument(sortOrderings.length == 0);
        } else {
            final TypeComparator sortComparator = this.getTypeComparator(inputType, sortColumns, sortOrderings, executionConfig);
            Collections.sort(inputData, new Comparator<IN>(){

                @Override
                public int compare(IN o1, IN o2) {
                    return sortComparator.compare(o1, o2);
                }
            });
        }
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, this.parameters);
        ArrayList result = new ArrayList();
        if (inputData.size() > 0) {
            TypeSerializer inputSerializer = inputType.createSerializer(executionConfig);
            if (keyColumns.length == 0) {
                TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig);
                ArrayList inputDataCopy = new ArrayList(inputData.size());
                for (IN in : inputData) {
                    inputDataCopy.add(inputSerializer.copy(in));
                }
                CopyingListCollector collector = new CopyingListCollector(result, outSerializer);
                function.reduce(inputDataCopy, collector);
            } else {
                boolean[] keyOrderings = new boolean[keyColumns.length];
                TypeComparator comparator = this.getTypeComparator(inputType, keyColumns, keyOrderings, executionConfig);
                ListKeyGroupedIterator<IN> keyedIterator = new ListKeyGroupedIterator<IN>(inputData, inputSerializer, comparator);
                TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig);
                CopyingListCollector collector = new CopyingListCollector(result, outSerializer);
                while (keyedIterator.nextKey()) {
                    function.reduce(keyedIterator.getValues(), collector);
                }
            }
        }
        FunctionUtils.closeFunction(function);
        return result;
    }
}

