/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import freemarker.template.Template;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.net.util.Base64;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.util.FreemarkerUtils;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertDingTalkParams;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.bean.RobotResponse;
import org.apache.streampark.console.core.service.alert.AlertNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
@Lazy
public class DingTalkAlertNotifyServiceImpl
implements AlertNotifyService {
    private static final Logger log = LoggerFactory.getLogger(DingTalkAlertNotifyServiceImpl.class);
    private Template template;
    private final RestTemplate alertRestTemplate;

    public DingTalkAlertNotifyServiceImpl(RestTemplate alertRestTemplate) {
        this.alertRestTemplate = alertRestTemplate;
    }

    @PostConstruct
    public void loadTemplateFile() throws Exception {
        String template = "alert-dingTalk.ftl";
        this.template = FreemarkerUtils.loadTemplateFile(template);
    }

    @Override
    public boolean doAlert(AlertConfigWithParams alertConfig, AlertTemplate alertTemplate) throws AlertException {
        AlertDingTalkParams dingTalkParams = alertConfig.getDingTalkParams();
        try {
            ArrayList contactList = new ArrayList();
            String contacts = dingTalkParams.getContacts();
            if (StringUtils.hasLength((String)contacts)) {
                Collections.addAll(contactList, contacts.split(","));
            }
            String title = alertTemplate.getTitle();
            if (!contactList.isEmpty()) {
                StringJoiner joiner = new StringJoiner(",@", title + " @", "");
                contactList.forEach(joiner::add);
                title = joiner.toString();
            }
            HashMap<String, Serializable> contactMap = new HashMap<String, Serializable>();
            contactMap.put("atMobiles", contactList);
            contactMap.put("isAtAll", Boolean.valueOf(BooleanUtils.toBoolean((Boolean)dingTalkParams.getIsAtAll())));
            String markdown = FreemarkerUtils.format(this.template, alertTemplate);
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("title", title);
            content.put("text", markdown);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("msgtype", "markdown");
            body.put("markdown", content);
            body.put("at", contactMap);
            this.sendMessage(dingTalkParams, body);
            return true;
        }
        catch (AlertException alertException) {
            throw alertException;
        }
        catch (Exception e) {
            throw new AlertException("Failed send dingTalk alert", e);
        }
    }

    private void sendMessage(AlertDingTalkParams params, Map<String, Object> body) throws AlertException {
        RobotResponse robotResponse;
        String url = this.getWebhook(params);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            robotResponse = (RobotResponse)this.alertRestTemplate.postForObject(url, (Object)entity, RobotResponse.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to request DingTalk robot alarm,\nurl:{}", (Object)url, (Object)e);
            throw new AlertException(String.format("Failed to request DingTalk robot alert,\nurl:%s", url), e);
        }
        if (robotResponse == null) {
            throw new AlertException(String.format("Failed to request DingTalk robot alert,\nurl:%s", url));
        }
        if (robotResponse.getErrcode() != 0) {
            throw new AlertException(String.format("Failed to request DingTalk robot alert,\nurl:%s,\nerrorCode:%d,\nerrorMsg:%s", url, robotResponse.getErrcode(), robotResponse.getErrmsg()));
        }
    }

    private String getWebhook(AlertDingTalkParams params) {
        String url;
        String urlPrefix = "https://oapi.dingtalk.com/robot/send";
        if (StringUtils.hasLength((String)params.getAlertDingURL())) {
            urlPrefix = params.getAlertDingURL().replaceFirst("\\?.*", "");
        }
        if (params.getSecretEnable().booleanValue()) {
            Long timestamp = System.currentTimeMillis();
            url = String.format("%s?access_token=%s&timestamp=%d&sign=%s", urlPrefix, params.getToken(), timestamp, this.getSign(params.getSecretToken(), timestamp));
        } else {
            url = String.format("%s?access_token=%s", urlPrefix, params.getToken());
        }
        if (log.isDebugEnabled()) {
            log.debug("The alarm robot url of DingTalk contains signature is {}", (Object)url);
        }
        return url;
    }

    private String getSign(String secret, Long timestamp) throws AlertException {
        try {
            String stringToSign = timestamp + "\n" + secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
            if (log.isDebugEnabled()) {
                log.debug("Calculate the signature success, sign:{}", (Object)sign);
            }
            return sign;
        }
        catch (Exception e) {
            throw new AlertException("Calculate the signature failed.", e);
        }
    }
}

