/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admission.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionRequest;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponse;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponseBuilder;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponseFluentImpl;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionReview;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionReviewFluent;
import java.util.Objects;

public class AdmissionReviewFluentImpl<A extends AdmissionReviewFluent<A>>
extends BaseFluent<A>
implements AdmissionReviewFluent<A> {
    private String apiVersion;
    private String kind;
    private AdmissionRequest request;
    private AdmissionResponseBuilder response;

    public AdmissionReviewFluentImpl() {
    }

    public AdmissionReviewFluentImpl(AdmissionReview instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public AdmissionRequest getRequest() {
        return this.request;
    }

    @Override
    public A withRequest(AdmissionRequest request) {
        this.request = request;
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null;
    }

    @Override
    @Deprecated
    public AdmissionResponse getResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public AdmissionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public A withResponse(AdmissionResponse response) {
        this._visitables.get("response").remove(this.response);
        if (response != null) {
            this.response = new AdmissionResponseBuilder(response);
            this._visitables.get("response").add(this.response);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> withNewResponse() {
        return new ResponseNestedImpl();
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
        return new ResponseNestedImpl(item);
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editResponse() {
        return this.withNewResponseLike(this.getResponse());
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : new AdmissionResponseBuilder().build());
    }

    @Override
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdmissionReviewFluentImpl that = (AdmissionReviewFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.request, this.response, super.hashCode());
    }

    public class ResponseNestedImpl<N>
    extends AdmissionResponseFluentImpl<AdmissionReviewFluent.ResponseNested<N>>
    implements AdmissionReviewFluent.ResponseNested<N>,
    Nested<N> {
        private final AdmissionResponseBuilder builder;

        ResponseNestedImpl(AdmissionResponse item) {
            this.builder = new AdmissionResponseBuilder(this, item);
        }

        ResponseNestedImpl() {
            this.builder = new AdmissionResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)AdmissionReviewFluentImpl.this.withResponse(this.builder.build());
        }

        @Override
        public N endResponse() {
            return this.and();
        }
    }
}

