/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.shaded.guava30.com.google.common.io.Files;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;

public class PodTemplateMountDecorator
extends AbstractKubernetesStepDecorator {
    private final AbstractKubernetesParameters kubernetesComponentConf;
    private final String podTemplateConfigMapName;

    public PodTemplateMountDecorator(AbstractKubernetesParameters kubernetesComponentConf) {
        this.kubernetesComponentConf = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesComponentConf);
        this.podTemplateConfigMapName = "pod-template-" + kubernetesComponentConf.getClusterId();
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        if (!this.getTaskManagerPodTemplateFile().isPresent()) {
            return flinkPod;
        }
        Pod mountedPod = this.decoratePod(flinkPod.getPodWithoutMainContainer());
        Container mountedMainContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(flinkPod.getMainContainer()).addNewVolumeMount().withName("pod-template-volume")).withMountPath("/opt/flink/pod-template")).endVolumeMount()).build();
        return new FlinkPod.Builder(flinkPod).withPod(mountedPod).withMainContainer(mountedMainContainer).build();
    }

    private Pod decoratePod(Pod pod) {
        ArrayList<KeyToPath> keyToPaths = new ArrayList<KeyToPath>();
        keyToPaths.add(((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey("taskmanager-pod-template.yaml")).withPath("taskmanager-pod-template.yaml")).build());
        Volume podTemplateVolume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName("pod-template-volume")).withNewConfigMap().withName(this.podTemplateConfigMapName)).withItems(keyToPaths)).endConfigMap()).build();
        return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editSpec().addNewVolumeLike(podTemplateVolume).endVolume()).endSpec()).build();
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        return this.getTaskManagerPodTemplateFile().map(FunctionUtils.uncheckedFunction(file -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("taskmanager-pod-template.yaml", Files.toString((File)file, (Charset)StandardCharsets.UTF_8));
            ConfigMap flinkConfConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapBuilder)new ConfigMapBuilder().withApiVersion("v1")).withNewMetadata().withName(this.podTemplateConfigMapName)).withLabels(this.kubernetesComponentConf.getCommonLabels())).endMetadata()).addToData(data)).build();
            return Collections.singletonList(flinkConfConfigMap);
        })).orElse(Collections.emptyList());
    }

    private Optional<File> getTaskManagerPodTemplateFile() {
        return this.kubernetesComponentConf.getFlinkConfiguration().getOptional(KubernetesConfigOptions.TASK_MANAGER_POD_TEMPLATE).map(file -> {
            File podTemplateFile = new File((String)file);
            if (!podTemplateFile.exists()) {
                throw new FlinkRuntimeException(String.format("Pod template file %s does not exist.", file));
            }
            return podTemplateFile;
        });
    }
}

