/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.CompressedSerializedValue;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class InputGateDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -7143441863165366704L;
    private final IntermediateDataSetID consumedResultId;
    private final ResultPartitionType consumedPartitionType;
    @Nonnegative
    private final int consumedSubpartitionIndex;
    private transient ShuffleDescriptor[] inputChannels;
    private TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> serializedInputChannels;

    @VisibleForTesting
    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, @Nonnegative int consumedSubpartitionIndex, ShuffleDescriptor[] inputChannels) throws IOException {
        this(consumedResultId, consumedPartitionType, consumedSubpartitionIndex, new TaskDeploymentDescriptor.NonOffloaded<ShuffleDescriptor[]>((SerializedValue<ShuffleDescriptor[]>)CompressedSerializedValue.fromObject((Object)inputChannels)));
    }

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, @Nonnegative int consumedSubpartitionIndex, TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> serializedInputChannels) {
        this.consumedResultId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)consumedResultId);
        this.consumedPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)consumedPartitionType)));
        this.consumedSubpartitionIndex = consumedSubpartitionIndex;
        this.serializedInputChannels = (TaskDeploymentDescriptor.MaybeOffloaded)Preconditions.checkNotNull(serializedInputChannels);
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    @Nonnegative
    public int getConsumedSubpartitionIndex() {
        return this.consumedSubpartitionIndex;
    }

    public void loadBigData(@Nullable PermanentBlobService blobService, JobID jobId) throws IOException, ClassNotFoundException {
        if (this.serializedInputChannels instanceof TaskDeploymentDescriptor.Offloaded) {
            PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)this.serializedInputChannels).serializedValueKey;
            Preconditions.checkNotNull((Object)blobService);
            CompressedSerializedValue serializedValue = CompressedSerializedValue.fromBytes((byte[])blobService.readFile(jobId, blobKey));
            this.serializedInputChannels = new TaskDeploymentDescriptor.NonOffloaded<ShuffleDescriptor[]>((SerializedValue<ShuffleDescriptor[]>)serializedValue);
            Preconditions.checkNotNull(this.serializedInputChannels);
        }
    }

    public ShuffleDescriptor[] getShuffleDescriptors() {
        block3: {
            try {
                if (this.inputChannels != null) break block3;
                if (this.serializedInputChannels instanceof TaskDeploymentDescriptor.NonOffloaded) {
                    TaskDeploymentDescriptor.NonOffloaded nonOffloadedSerializedValue = (TaskDeploymentDescriptor.NonOffloaded)this.serializedInputChannels;
                    this.inputChannels = (ShuffleDescriptor[])nonOffloadedSerializedValue.serializedValue.deserializeValue(this.getClass().getClassLoader());
                    break block3;
                }
                throw new IllegalStateException("Trying to work with offloaded serialized shuffle descriptors.");
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Could not deserialize shuffle descriptors.", e);
            }
        }
        return this.inputChannels;
    }

    public String toString() {
        return String.format("InputGateDeploymentDescriptor [result id: %s, consumed subpartition index: %d, input channels: %s]", this.consumedResultId.toString(), this.consumedSubpartitionIndex, Arrays.toString(this.getShuffleDescriptors()));
    }
}

