/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.mapper.FlinkEnvMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class FlinkEnvServiceImpl
extends ServiceImpl<FlinkEnvMapper, FlinkEnv>
implements FlinkEnvService {
    private static final Logger log = LoggerFactory.getLogger(FlinkEnvServiceImpl.class);
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private ApplicationService applicationService;

    @Override
    public Integer check(FlinkEnv version) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkEnv::getFlinkName, (Object)version.getFlinkName());
        if (version.getId() != null) {
            queryWrapper.ne(FlinkEnv::getId, (Object)version.getId());
        }
        if (this.count((Wrapper)queryWrapper) > 0L) {
            return 1;
        }
        String lib = version.getFlinkHome().concat("/lib");
        File flinkLib = new File(lib);
        if (flinkLib.exists() && flinkLib.isDirectory()) {
            int distSize = flinkLib.listFiles(f -> f.getName().matches("flink-dist.*\\.jar")).length;
            if (distSize > 1) {
                return 2;
            }
        } else {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean create(FlinkEnv version) throws Exception {
        long count = ((FlinkEnvMapper)this.baseMapper).selectCount(null);
        version.setIsDefault(count == 0L);
        version.setCreateTime(new Date());
        version.doSetVersion();
        version.doSetFlinkConf();
        return this.save(version);
    }

    @Override
    public void delete(Long id) {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(id);
        this.checkOrElseAlert(flinkEnv);
        Long count = ((FlinkEnvMapper)this.baseMapper).selectCount(null);
        ApiAlertException.throwIfFalse(count <= 1L || flinkEnv.getIsDefault() == false, "The flink home is set as default, please change it first.");
        ((FlinkEnvMapper)this.baseMapper).deleteById(id);
    }

    @Override
    public void update(FlinkEnv version) throws IOException {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(version.getId());
        this.checkOrElseAlert(flinkEnv);
        flinkEnv.setDescription(version.getDescription());
        flinkEnv.setFlinkName(version.getFlinkName());
        if (!version.getFlinkHome().equals(flinkEnv.getFlinkHome())) {
            flinkEnv.setFlinkHome(version.getFlinkHome());
            flinkEnv.doSetFlinkConf();
            flinkEnv.doSetVersion();
        }
        this.updateById(flinkEnv);
    }

    @Override
    public void setDefault(Long id) {
        ((FlinkEnvMapper)this.baseMapper).setDefault(id);
    }

    @Override
    public FlinkEnv getByAppId(Long appId) {
        return ((FlinkEnvMapper)this.baseMapper).getByAppId(appId);
    }

    @Override
    public FlinkEnv getDefault() {
        return (FlinkEnv)((FlinkEnvMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(FlinkEnv::getIsDefault, (Object)true));
    }

    @Override
    public FlinkEnv getByIdOrDefault(Long id) {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(id);
        if (flinkEnv == null) {
            return this.getDefault();
        }
        return flinkEnv;
    }

    @Override
    public void syncConf(Long id) {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(id);
        flinkEnv.doSetFlinkConf();
        this.updateById(flinkEnv);
    }

    @Override
    public void validity(Long id) {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(id);
        this.checkOrElseAlert(flinkEnv);
    }

    @Override
    public IPage<FlinkEnv> findPage(FlinkEnv flinkEnv, RestRequest restRequest) {
        Page page = MybatisPager.getPage(restRequest);
        return ((FlinkEnvMapper)this.baseMapper).findPage(page, flinkEnv);
    }

    @Override
    public Properties getFlinkConfig(FlinkEnv flinkEnv, Application application) {
        String flinkYamlString = DeflaterUtils.unzipString((String)flinkEnv.getFlinkConf());
        Properties flinkConfig = new Properties();
        HashMap config = PropertiesUtils.loadFlinkConfYaml((String)flinkYamlString);
        for (Map.Entry entry : config.entrySet()) {
            String value = (String)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)application.getJobName())) {
                value = value.replaceAll("\\$\\{job(Name|name)}|\\$job(Name|name)", application.getJobName());
            }
            if (application.getId() != null) {
                value = value.replaceAll("\\$\\{job(Id|id)}|\\$job(Id|id)", application.getId().toString());
            }
            flinkConfig.setProperty((String)entry.getKey(), value);
        }
        return flinkConfig;
    }

    private void checkOrElseAlert(FlinkEnv flinkEnv) {
        ApiAlertException.throwIfNull(flinkEnv, "The flink home does not exist, please check.");
        ApiAlertException.throwIfTrue(this.flinkClusterService.existsByFlinkEnvId(flinkEnv.getId()), "The flink home is still in use by some flink cluster, please check.");
        ApiAlertException.throwIfTrue(this.applicationService.existsJobByFlinkEnvId(flinkEnv.getId()), "The flink home is still in use by some application, please check.");
    }
}

