/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AbstractCompatibilityTransformer;
import org.codehaus.plexus.util.IOUtil;

public class IncludeResourceTransformer
extends AbstractCompatibilityTransformer {
    File file;
    String resource;
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String r) {
        return false;
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return this.file != null && this.file.exists();
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        JarEntry jarEntry = new JarEntry(this.resource);
        jarEntry.setTime(this.time);
        try (FileInputStream in = new FileInputStream(this.file);){
            jos.putNextEntry(jarEntry);
            IOUtil.copy((InputStream)in, (OutputStream)jos);
        }
    }

    public String toString() {
        return "IncludeResourceTransformer {resource: '" + this.resource + "'}";
    }
}

