/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Qualifier;
import org.sonatype.guice.asm.AnnotationVisitor;
import org.sonatype.guice.asm.Type;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.bean.scanners.EmptyClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QualifierCache
extends EmptyClassVisitor {
    private static final String QUALIFIER_DESC = Type.getDescriptor(Qualifier.class);
    private final Map<String, Class<?>> cachedResults = new HashMap();
    private boolean isQualified;

    QualifierCache() {
    }

    public Class<Annotation> qualify(ClassSpace space, String desc) {
        if (!this.cachedResults.containsKey(desc)) {
            this.isQualified = false;
            String name = desc.substring(1, desc.length() - 1);
            ClassSpaceScanner.accept(this, space.getResource(name + ".class"));
            this.cachedResults.put(desc, this.isQualified ? space.loadClass(name.replace('/', '.')) : null);
        }
        return this.cachedResults.get(desc);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.isQualified |= QUALIFIER_DESC.equals(desc);
        return null;
    }
}

