/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlay;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUserOverlay
implements ContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUserOverlay.class);
    private final UserGroupInformation ugi;

    public HadoopUserOverlay(@Nullable UserGroupInformation ugi) {
        this.ugi = ugi;
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        if (this.ugi != null) {
            container.getEnvironmentVariables().put("HADOOP_USER_NAME", this.ugi.getUserName());
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        UserGroupInformation ugi;

        public Builder fromEnvironment(Configuration globalConfiguration) throws IOException {
            this.ugi = UserGroupInformation.getCurrentUser();
            return this;
        }

        public HadoopUserOverlay build() {
            return new HadoopUserOverlay(this.ugi);
        }
    }
}

