/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointScheduling;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.Executing;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;

class StopWithSavepoint
extends StateWithExecutionGraph {
    private final Context context;
    private final ClassLoader userCodeClassLoader;
    private final CompletableFuture<String> operationFuture;
    private final CheckpointScheduling checkpointScheduling;
    private boolean hasFullyFinished = false;
    @Nullable
    private String savepoint = null;
    @Nullable
    private Throwable operationFailureCause;

    StopWithSavepoint(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, CheckpointScheduling checkpointScheduling, Logger logger, ClassLoader userCodeClassLoader, CompletableFuture<String> savepointFuture) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger);
        this.context = context;
        this.userCodeClassLoader = userCodeClassLoader;
        this.checkpointScheduling = checkpointScheduling;
        this.operationFuture = new CompletableFuture();
        FutureUtils.assertNoException((CompletableFuture)savepointFuture.handle((savepointLocation, throwable) -> {
            context.runIfState(this, () -> this.handleSavepointCompletion((String)savepointLocation, (Throwable)throwable), Duration.ZERO);
            return null;
        }));
    }

    private void handleSavepointCompletion(@Nullable String savepoint, @Nullable Throwable throwable) {
        if (this.hasFullyFinished) {
            Preconditions.checkState((throwable == null ? 1 : 0) != 0, (Object)"A savepoint should never fail after a job has been terminated via stop-with-savepoint.");
            this.completeOperationAndGoToFinished(savepoint);
        } else if (throwable != null) {
            this.operationFailureCause = throwable;
            this.checkpointScheduling.startCheckpointScheduler();
            this.context.goToExecuting(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler());
        } else {
            this.savepoint = savepoint;
        }
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        this.operationFuture.completeExceptionally(new FlinkException("Stop with savepoint operation could not be completed.", this.operationFailureCause));
        super.onLeave(newState);
    }

    @Override
    public void cancel() {
        this.context.goToCanceling(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler());
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.RUNNING;
    }

    @Override
    public void handleGlobalFailure(Throwable cause) {
        this.handleAnyFailure(cause);
    }

    @Override
    boolean updateTaskExecutionState(TaskExecutionStateTransition taskExecutionStateTransition) {
        boolean successfulUpdate = this.getExecutionGraph().updateState(taskExecutionStateTransition);
        if (successfulUpdate && taskExecutionStateTransition.getExecutionState() == ExecutionState.FAILED) {
            Throwable cause = taskExecutionStateTransition.getError(this.userCodeClassLoader);
            this.handleAnyFailure(cause == null ? new FlinkException("Unknown failure cause. Probably related to FLINK-21376.") : cause);
        }
        return successfulUpdate;
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        if (globallyTerminalState == JobStatus.FINISHED) {
            if (this.savepoint == null) {
                this.hasFullyFinished = true;
            } else {
                this.completeOperationAndGoToFinished(this.savepoint);
            }
        } else {
            this.handleAnyFailure(new FlinkException("Job did not reach the FINISHED state while performing stop-with-savepoint."));
        }
    }

    private void completeOperationAndGoToFinished(String savepoint) {
        this.operationFuture.complete(savepoint);
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.getExecutionGraph()));
    }

    private void handleAnyFailure(Throwable cause) {
        this.operationFailureCause = cause;
        Executing.FailureResult failureResult = this.context.howToHandleFailure(cause);
        if (failureResult.canRestart()) {
            this.getLogger().info("Restarting job.", failureResult.getFailureCause());
            this.context.goToRestarting(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), failureResult.getBackoffTime());
        } else {
            this.getLogger().info("Failing job.", failureResult.getFailureCause());
            this.context.goToFailing(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler(), failureResult.getFailureCause());
        }
    }

    CompletableFuture<String> getOperationFuture() {
        return this.operationFuture;
    }

    static class Factory
    implements StateFactory<StopWithSavepoint> {
        private final Context context;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final CheckpointScheduling checkpointScheduling;
        private final Logger logger;
        private final ClassLoader userCodeClassLoader;
        private final CompletableFuture<String> savepointFuture;

        Factory(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, CheckpointScheduling checkpointScheduling, Logger logger, ClassLoader userCodeClassLoader, CompletableFuture<String> savepointFuture) {
            this.context = context;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.checkpointScheduling = checkpointScheduling;
            this.logger = logger;
            this.userCodeClassLoader = userCodeClassLoader;
            this.savepointFuture = savepointFuture;
        }

        @Override
        public Class<StopWithSavepoint> getStateClass() {
            return StopWithSavepoint.class;
        }

        @Override
        public StopWithSavepoint getState() {
            return new StopWithSavepoint(this.context, this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.checkpointScheduling, this.logger, this.userCodeClassLoader, this.savepointFuture);
        }
    }

    static interface Context
    extends StateWithExecutionGraph.Context {
        public Executing.FailureResult howToHandleFailure(Throwable var1);

        public void goToCanceling(ExecutionGraph var1, ExecutionGraphHandler var2, OperatorCoordinatorHandler var3);

        public void goToRestarting(ExecutionGraph var1, ExecutionGraphHandler var2, OperatorCoordinatorHandler var3, Duration var4);

        public void goToFailing(ExecutionGraph var1, ExecutionGraphHandler var2, OperatorCoordinatorHandler var3, Throwable var4);

        public void goToExecuting(ExecutionGraph var1, ExecutionGraphHandler var2, OperatorCoordinatorHandler var3);

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

