/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.sink;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.util.UserCodeClassLoader;

@Experimental
public interface Sink<InputT, CommT, WriterStateT, GlobalCommT>
extends Serializable {
    public SinkWriter<InputT, CommT, WriterStateT> createWriter(InitContext var1, List<WriterStateT> var2) throws IOException;

    public Optional<SimpleVersionedSerializer<WriterStateT>> getWriterStateSerializer();

    public Optional<Committer<CommT>> createCommitter() throws IOException;

    public Optional<GlobalCommitter<CommT, GlobalCommT>> createGlobalCommitter() throws IOException;

    public Optional<SimpleVersionedSerializer<CommT>> getCommittableSerializer();

    public Optional<SimpleVersionedSerializer<GlobalCommT>> getGlobalCommittableSerializer();

    default public Collection<String> getCompatibleStateNames() {
        return Collections.emptyList();
    }

    public static interface ProcessingTimeService {
        public long getCurrentProcessingTime();

        public void registerProcessingTimer(long var1, ProcessingTimeCallback var3);

        public static interface ProcessingTimeCallback {
            public void onProcessingTime(long var1) throws IOException, InterruptedException;
        }
    }

    public static interface InitContext {
        public UserCodeClassLoader getUserCodeClassLoader();

        public MailboxExecutor getMailboxExecutor();

        public ProcessingTimeService getProcessingTimeService();

        public int getSubtaskId();

        public int getNumberOfParallelSubtasks();

        public SinkWriterMetricGroup metricGroup();

        public OptionalLong getRestoredCheckpointId();
    }
}

