/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.util.Preconditions;

public class FlinkPod {
    private final Pod podWithoutMainContainer;
    private final Container mainContainer;

    public FlinkPod(Pod podWithoutMainContainer, Container mainContainer) {
        this.podWithoutMainContainer = podWithoutMainContainer;
        this.mainContainer = mainContainer;
    }

    public Pod getPodWithoutMainContainer() {
        return this.podWithoutMainContainer;
    }

    public Container getMainContainer() {
        return this.mainContainer;
    }

    public FlinkPod copy() {
        return new FlinkPod(new PodBuilder(this.getPodWithoutMainContainer()).build(), new ContainerBuilder(this.getMainContainer()).build());
    }

    public static class Builder {
        private Pod podWithoutMainContainer;
        private Container mainContainer;

        public Builder() {
            this.podWithoutMainContainer = ((PodBuilder)((PodBuilder)new PodBuilder().withNewMetadata().endMetadata()).withNewSpec().endSpec()).build();
            this.mainContainer = new ContainerBuilder().build();
        }

        public Builder(FlinkPod flinkPod) {
            Preconditions.checkNotNull((Object)flinkPod);
            this.podWithoutMainContainer = (Pod)Preconditions.checkNotNull((Object)flinkPod.getPodWithoutMainContainer());
            this.mainContainer = (Container)Preconditions.checkNotNull((Object)flinkPod.getMainContainer());
        }

        public Builder withPod(Pod pod) {
            this.podWithoutMainContainer = (Pod)Preconditions.checkNotNull((Object)pod);
            return this;
        }

        public Builder withMainContainer(Container mainContainer) {
            this.mainContainer = (Container)Preconditions.checkNotNull((Object)mainContainer);
            return this;
        }

        public FlinkPod build() {
            return new FlinkPod(this.podWithoutMainContainer, this.mainContainer);
        }
    }
}

