/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.ingress;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.client.program.ClusterClient;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.conf.K8sFlinkConfig$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Maa\u0002\u0006\f!\u0003\r\t\u0001\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\bI\u0001\u0011\r\u0011\"\u0001&\u0011!q\u0003\u0001#b\u0001\n\u0003y\u0003\"\u0002\u001e\u0001\r\u0003Y\u0004\"B.\u0001\r\u0003a\u0006\"B1\u0001\t\u0003\u0011\u0007\"B4\u0001\t\u0003A\u0007\"B8\u0001\t\u0003\u0001\b\"\u0002:\u0001\t\u0003\u0019(aD%oOJ,7o]*ue\u0006$XmZ=\u000b\u00051i\u0011aB5oOJ,7o\u001d\u0006\u0003\u001d=\t!b[;cKJtW\r^3t\u0015\t\u0001\u0012#A\u0003gY&t7N\u0003\u0002\u0013'\u0005Q1\u000f\u001e:fC6\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0005\u0002\"A\u0007\u0012\n\u0005\rZ\"\u0001B+oSR\f1DU#T)~\u001bVI\u0015,J\u0007\u0016{\u0016\nR#O)&3\u0015jQ!U\u0013>sU#\u0001\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u00027b]\u001eT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\t11\u000b\u001e:j]\u001e\fA\"\u001b8he\u0016\u001c8o\u00117bgN,\u0012\u0001\r\t\u0003car!A\r\u001c\u0011\u0005MZR\"\u0001\u001b\u000b\u0005U:\u0012A\u0002\u001fs_>$h(\u0003\u000287\u00051\u0001K]3eK\u001aL!!L\u001d\u000b\u0005]Z\u0012!D4fi&swM]3tgV\u0013H\u000eF\u0002=/f#\"\u0001M\u001f\t\ry\"A\u00111\u0001@\u00035\u0019G.^:uKJ\u001cE.[3oiB\u0019!\u0004\u0011\"\n\u0005\u0005[\"\u0001\u0003\u001fcs:\fW.\u001a 1\u0005\rs\u0005c\u0001#K\u00196\tQI\u0003\u0002G\u000f\u00069\u0001O]8he\u0006l'B\u0001%J\u0003\u0019\u0019G.[3oi*\u0011\u0001cE\u0005\u0003\u0017\u0016\u0013Qb\u00117vgR,'o\u00117jK:$\bCA'O\u0019\u0001!\u0011bT\u001f\u0002\u0002\u0003\u0005)\u0011\u0001)\u0003\u0007}#\u0013'\u0005\u0002R)B\u0011!DU\u0005\u0003'n\u0011qAT8uQ&tw\r\u0005\u0002\u001b+&\u0011ak\u0007\u0002\u0004\u0003:L\b\"\u0002-\u0005\u0001\u0004\u0001\u0014!\u00038b[\u0016\u001c\u0006/Y2f\u0011\u0015QF\u00011\u00011\u0003%\u0019G.^:uKJLE-\u0001\td_:4\u0017nZ;sK&swM]3tgR!\u0011%X0a\u0011\u0015qV\u00011\u00011\u0003)!w.\\1j]:\u000bW.\u001a\u0005\u00065\u0016\u0001\r\u0001\r\u0005\u00061\u0016\u0001\r\u0001M\u0001\u001caJ,\u0007/\u0019:f\u0013:<'/Z:t)\u0016l\u0007\u000f\\1uK\u001aKG.Z:\u0015\u0007A\u001aW\rC\u0003e\r\u0001\u0007\u0001'\u0001\bck&dGmV8sWN\u0004\u0018mY3\t\u000b\u00194\u0001\u0019\u0001\u0019\u0002!%twM]3tgR+W\u000e\u001d7bi\u0016\u001c\u0018a\u00062vS2$\u0017J\\4sKN\u001c\u0018I\u001c8pi\u0006$\u0018n\u001c8t)\rIG.\u001c\t\u0005c)\u0004\u0004'\u0003\u0002ls\t\u0019Q*\u00199\t\u000bi;\u0001\u0019\u0001\u0019\t\u000b9<\u0001\u0019\u0001\u0019\u0002\u00139\fW.Z:qC\u000e,\u0017A\u00052vS2$\u0017J\\4sKN\u001cH*\u00192fYN$\"![9\t\u000biC\u0001\u0019\u0001\u0019\u0002#\u001d,GoT<oKJ\u0014VMZ3sK:\u001cW\rF\u0004u\u0003\u0007\t)!a\u0002\u0011\u0005U|X\"\u0001<\u000b\u0005]D\u0018!B7pI\u0016d'BA={\u0003\r\t\u0007/\u001b\u0006\u0003\u001dmT!\u0001`?\u0002\u000f\u0019\f'M]5dq)\ta0\u0001\u0002j_&\u0019\u0011\u0011\u0001<\u0003\u001d=;h.\u001a:SK\u001a,'/\u001a8dK\")\u0001,\u0003a\u0001a!)!,\u0003a\u0001a!1\u0001*\u0003a\u0001\u0003\u0013\u0001B!a\u0003\u0002\u00105\u0011\u0011Q\u0002\u0006\u0003\u0011jLA!!\u0005\u0002\u000e\t9B)\u001a4bk2$8*\u001e2fe:,G/Z:DY&,g\u000e\u001e")
public interface IngressStrategy {
    public void org$apache$streampark$flink$kubernetes$ingress$IngressStrategy$_setter_$REST_SERVICE_IDENTIFICATION_$eq(String var1);

    public String REST_SERVICE_IDENTIFICATION();

    public static /* synthetic */ String ingressClass$(IngressStrategy $this) {
        return $this.ingressClass();
    }

    default public String ingressClass() {
        return (String)InternalConfigHolder$.MODULE$.get(K8sFlinkConfig$.MODULE$.ingressClass());
    }

    public String getIngressUrl(String var1, String var2, Function0<ClusterClient<?>> var3);

    public void configureIngress(String var1, String var2, String var3);

    public static /* synthetic */ String prepareIngressTemplateFiles$(IngressStrategy $this, String buildWorkspace, String ingressTemplates) {
        return $this.prepareIngressTemplateFiles(buildWorkspace, ingressTemplates);
    }

    default public String prepareIngressTemplateFiles(String buildWorkspace, String ingressTemplates) {
        String string;
        File workspaceDir = new File(buildWorkspace);
        Object object = !workspaceDir.exists() ? BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir()) : BoxedUnit.UNIT;
        if (ingressTemplates.isEmpty()) {
            string = null;
        } else {
            String outputPath = new StringBuilder(13).append(buildWorkspace).append("/ingress.yaml").toString();
            File outputFile = new File(outputPath);
            FileUtils.write((File)outputFile, (CharSequence)ingressTemplates, (String)"UTF-8");
            string = outputPath;
        }
        return string;
    }

    public static /* synthetic */ Map buildIngressAnnotations$(IngressStrategy $this, String clusterId, String namespace) {
        return $this.buildIngressAnnotations(clusterId, namespace);
    }

    default public Map<String, String> buildIngressAnnotations(String clusterId, String namespace) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/rewrite-target"), (Object)"/$2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/proxy-body-size"), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/configuration-snippet"), (Object)new StringBuilder(100).append("rewrite ^(/").append(clusterId).append(")$ $1/ permanent; sub_filter '<base href=\"./\">' '<base href=\"/").append(namespace).append("/").append(clusterId).append("/\">'; sub_filter_once off;").toString())}));
    }

    public static /* synthetic */ Map buildIngressLabels$(IngressStrategy $this, String clusterId) {
        return $this.buildIngressLabels(clusterId);
    }

    default public Map<String, String> buildIngressLabels(String clusterId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flink-native-kubernetes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"ingress")}));
    }

    public static /* synthetic */ OwnerReference getOwnerReference$(IngressStrategy $this, String nameSpace, String clusterId, DefaultKubernetesClient client) {
        return $this.getOwnerReference(nameSpace, clusterId, client);
    }

    default public OwnerReference getOwnerReference(String nameSpace, String clusterId, DefaultKubernetesClient client) {
        Deployment deployment = (Deployment)((Gettable)((Nameable)client.apps().deployments().inNamespace(nameSpace)).withName(clusterId)).get();
        Predef$.MODULE$.require(deployment != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deployment with name ").append(clusterId).append(" not found in namespace ").append(nameSpace).toString());
        return ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withUid(deployment.getMetadata().getUid())).withApiVersion("apps/v1")).withKind("Deployment")).withName(clusterId)).withController(Predef$.MODULE$.boolean2Boolean(true))).withBlockOwnerDeletion(Predef$.MODULE$.boolean2Boolean(true))).build();
    }

    public static void $init$(IngressStrategy $this) {
        $this.org$apache$streampark$flink$kubernetes$ingress$IngressStrategy$_setter_$REST_SERVICE_IDENTIFICATION_$eq("rest");
    }
}

