/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.BooleanColumnSummary;
import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.StringColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.BooleanSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.DoubleSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.FloatSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.IntegerSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.LongSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.ShortSummaryAggregator;
import org.apache.flink.api.java.summarize.aggregation.StringSummaryAggregator;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

@Internal
public abstract class ValueSummaryAggregator<VT extends Value, PT, R, A extends Aggregator<PT, R>>
implements Aggregator<VT, R> {
    private A aggregator = this.initPrimitiveAggregator();

    @Override
    public void aggregate(VT value) {
        if (value != null) {
            this.aggregator.aggregate(this.getValue(value));
        } else {
            this.aggregator.aggregate(null);
        }
    }

    @Override
    public void combine(Aggregator<VT, R> otherSameType) {
        ValueSummaryAggregator other = (ValueSummaryAggregator)otherSameType;
        this.aggregator.combine(other.aggregator);
    }

    @Override
    public R result() {
        return this.aggregator.result();
    }

    protected abstract A initPrimitiveAggregator();

    protected abstract PT getValue(VT var1);

    public static class StringValueSummaryAggregator
    extends ValueSummaryAggregator<StringValue, String, StringColumnSummary, StringSummaryAggregator> {
        @Override
        protected StringSummaryAggregator initPrimitiveAggregator() {
            return new StringSummaryAggregator();
        }

        @Override
        protected String getValue(StringValue value) {
            return value.getValue();
        }
    }

    public static class BooleanValueSummaryAggregator
    extends ValueSummaryAggregator<BooleanValue, Boolean, BooleanColumnSummary, BooleanSummaryAggregator> {
        @Override
        protected BooleanSummaryAggregator initPrimitiveAggregator() {
            return new BooleanSummaryAggregator();
        }

        @Override
        protected Boolean getValue(BooleanValue value) {
            return value.getValue();
        }
    }

    public static class DoubleValueSummaryAggregator
    extends ValueSummaryAggregator<DoubleValue, Double, NumericColumnSummary<Double>, DoubleSummaryAggregator> {
        @Override
        protected DoubleSummaryAggregator initPrimitiveAggregator() {
            return new DoubleSummaryAggregator();
        }

        @Override
        protected Double getValue(DoubleValue value) {
            return value.getValue();
        }
    }

    public static class FloatValueSummaryAggregator
    extends ValueSummaryAggregator<FloatValue, Float, NumericColumnSummary<Float>, FloatSummaryAggregator> {
        @Override
        protected FloatSummaryAggregator initPrimitiveAggregator() {
            return new FloatSummaryAggregator();
        }

        @Override
        protected Float getValue(FloatValue value) {
            return Float.valueOf(value.getValue());
        }
    }

    public static class LongValueSummaryAggregator
    extends ValueSummaryAggregator<LongValue, Long, NumericColumnSummary<Long>, LongSummaryAggregator> {
        @Override
        protected LongSummaryAggregator initPrimitiveAggregator() {
            return new LongSummaryAggregator();
        }

        @Override
        protected Long getValue(LongValue value) {
            return value.getValue();
        }
    }

    public static class IntegerValueSummaryAggregator
    extends ValueSummaryAggregator<IntValue, Integer, NumericColumnSummary<Integer>, IntegerSummaryAggregator> {
        @Override
        protected IntegerSummaryAggregator initPrimitiveAggregator() {
            return new IntegerSummaryAggregator();
        }

        @Override
        protected Integer getValue(IntValue value) {
            return value.getValue();
        }
    }

    public static class ShortValueSummaryAggregator
    extends ValueSummaryAggregator<ShortValue, Short, NumericColumnSummary<Short>, ShortSummaryAggregator> {
        @Override
        protected ShortSummaryAggregator initPrimitiveAggregator() {
            return new ShortSummaryAggregator();
        }

        @Override
        protected Short getValue(ShortValue value) {
            return value.getValue();
        }
    }
}

