/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class HistoryServerOptions {
    public static final ConfigOption<Long> HISTORY_SERVER_ARCHIVE_REFRESH_INTERVAL = ConfigOptions.key("historyserver.archive.fs.refresh-interval").defaultValue(10000L).withDescription("Interval in milliseconds for refreshing the archived job directories.");
    public static final ConfigOption<String> HISTORY_SERVER_ARCHIVE_DIRS = ConfigOptions.key("historyserver.archive.fs.dir").noDefaultValue().withDescription("Comma separated list of directories to fetch archived jobs from. The history server will monitor these directories for archived jobs. You can configure the JobManager to archive jobs to a directory via `jobmanager.archive.fs.dir`.");
    public static final ConfigOption<Boolean> HISTORY_SERVER_CLEANUP_EXPIRED_JOBS = ConfigOptions.key("historyserver.archive.clean-expired-jobs").defaultValue(false).withDescription(String.format("Whether HistoryServer should cleanup jobs that are no longer present `%s`.", HISTORY_SERVER_ARCHIVE_DIRS.key()));
    public static final ConfigOption<String> HISTORY_SERVER_WEB_DIR = ConfigOptions.key("historyserver.web.tmpdir").noDefaultValue().withDescription("This configuration parameter allows defining the Flink web directory to be used by the history server web interface. The web interface will copy its static files into the directory.");
    public static final ConfigOption<String> HISTORY_SERVER_WEB_ADDRESS = ConfigOptions.key("historyserver.web.address").noDefaultValue().withDescription("Address of the HistoryServer's web interface.");
    public static final ConfigOption<Integer> HISTORY_SERVER_WEB_PORT = ConfigOptions.key("historyserver.web.port").defaultValue(8082).withDescription("Port of the HistoryServers's web interface.");
    public static final ConfigOption<Long> HISTORY_SERVER_WEB_REFRESH_INTERVAL = ConfigOptions.key("historyserver.web.refresh-interval").defaultValue(10000L).withDescription("The refresh interval for the HistoryServer web-frontend in milliseconds.");
    public static final ConfigOption<Boolean> HISTORY_SERVER_WEB_SSL_ENABLED = ConfigOptions.key("historyserver.web.ssl.enabled").defaultValue(false).withDescription("Enable HTTPs access to the HistoryServer web frontend. This is applicable only when the global SSL flag security.ssl.enabled is set to true.");
    public static final ConfigOption<Integer> HISTORY_SERVER_RETAINED_JOBS = ConfigOptions.key("historyserver.archive.retained-jobs").intType().defaultValue(-1).withDescription(Description.builder().text(String.format("The maximum number of jobs to retain in each archive directory defined by `%s`. ", HISTORY_SERVER_ARCHIVE_DIRS.key())).text("If set to `-1`(default), there is no limit to the number of archives. ").text("If set to `0` or less than `-1` HistoryServer will throw an %s. ", TextElement.code("IllegalConfigurationException")).build());

    private HistoryServerOptions() {
    }
}

