/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.AssertUtils;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.enums.CandidateType;
import org.apache.streampark.console.core.enums.EffectiveType;
import org.apache.streampark.console.core.mapper.FlinkSqlMapper;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.EffectiveService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.flink.core.FlinkSqlValidationResult;
import org.apache.streampark.flink.proxy.FlinkShimsProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class FlinkSqlServiceImpl
extends ServiceImpl<FlinkSqlMapper, FlinkSql>
implements FlinkSqlService {
    private static final Logger log = LoggerFactory.getLogger(FlinkSqlServiceImpl.class);
    @Autowired
    private EffectiveService effectiveService;
    @Autowired
    private ApplicationBackUpService backUpService;
    @Autowired
    private FlinkEnvService flinkEnvService;
    private static final String FLINKSQL_VALIDATOR_CLASS = "org.apache.streampark.flink.core.FlinkSqlValidator";

    @Override
    public FlinkSql getEffective(Long appId, boolean decode) {
        FlinkSql flinkSql = ((FlinkSqlMapper)this.baseMapper).getEffective(appId);
        if (flinkSql != null && decode) {
            flinkSql.setSql(DeflaterUtils.unzipString((String)flinkSql.getSql()));
        }
        return flinkSql;
    }

    @Override
    public FlinkSql getLatestFlinkSql(Long appId, boolean decode) {
        Page page = new Page();
        page.setCurrent(0L).setSize(1L).setSearchCount(false);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkSql::getAppId, (Object)appId)).orderByDesc(FlinkSql::getVersion);
        Page flinkSqlPage = (Page)((FlinkSqlMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        if (!flinkSqlPage.getRecords().isEmpty()) {
            FlinkSql flinkSql = (FlinkSql)flinkSqlPage.getRecords().get(0);
            if (decode) {
                flinkSql.setSql(DeflaterUtils.unzipString((String)flinkSql.getSql()));
            }
            return flinkSql;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(FlinkSql flinkSql) {
        Integer version = ((FlinkSqlMapper)this.baseMapper).getLatestVersion(flinkSql.getAppId());
        flinkSql.setVersion(version == null ? 1 : version + 1);
        String sql = DeflaterUtils.zipString((String)flinkSql.getSql());
        flinkSql.setSql(sql);
        this.save(flinkSql);
        this.setCandidate(CandidateType.NEW, flinkSql.getAppId(), flinkSql.getId());
    }

    @Override
    public void setCandidate(CandidateType candidateType, Long appId, Long sqlId) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FlinkSql::getAppId, (Object)appId)).set(FlinkSql::getCandidate, (Object)CandidateType.NONE.get()));
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FlinkSql::getId, (Object)sqlId)).set(FlinkSql::getCandidate, (Object)candidateType.get()));
    }

    @Override
    public List<FlinkSql> history(Application application) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkSql::getAppId, (Object)application.getId())).orderByDesc(FlinkSql::getVersion);
        List sqlList = ((FlinkSqlMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        FlinkSql effective = this.getEffective(application.getId(), false);
        if (effective != null && !sqlList.isEmpty()) {
            for (FlinkSql sql : sqlList) {
                if (!sql.getId().equals(effective.getId())) continue;
                sql.setEffective(true);
                break;
            }
        }
        return sqlList;
    }

    @Override
    public FlinkSql getCandidate(Long appId, CandidateType candidateType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkSql::getAppId, (Object)appId);
        if (candidateType == null) {
            queryWrapper.gt(FlinkSql::getCandidate, (Object)CandidateType.NONE.get());
        } else {
            queryWrapper.eq(FlinkSql::getCandidate, (Object)candidateType.get());
        }
        return (FlinkSql)((FlinkSqlMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public void toEffective(Long appId, Long sqlId) {
        this.effectiveService.saveOrUpdate(appId, EffectiveType.FLINKSQL, sqlId);
    }

    @Override
    public void cleanCandidate(Long id) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FlinkSql::getId, (Object)id)).set(FlinkSql::getCandidate, (Object)CandidateType.NONE.get()));
    }

    @Override
    public void removeApp(Long appId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkSql::getAppId, (Object)appId);
        ((FlinkSqlMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void rollback(Application application) {
        FlinkSql sql = this.getCandidate(application.getId(), CandidateType.HISTORY);
        AssertUtils.notNull((Object)sql);
        try {
            FlinkSql effectiveSql = this.getEffective(application.getId(), false);
            AssertUtils.notNull((Object)effectiveSql);
            this.backUpService.rollbackFlinkSql(application, sql);
        }
        catch (Exception e) {
            log.error("Backup and Roll back FlinkSql before start failed.");
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public FlinkSqlValidationResult verifySql(String sql, Long versionId) {
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(versionId);
        return (FlinkSqlValidationResult)FlinkShimsProxy.proxyVerifySql((FlinkVersion)flinkEnv.getFlinkVersion(), classLoader -> {
            try {
                Class<?> clazz = classLoader.loadClass(FLINKSQL_VALIDATOR_CLASS);
                Method method = clazz.getDeclaredMethod("verifySql", String.class);
                method.setAccessible(true);
                Object result = method.invoke(null, sql);
                if (result == null) {
                    return null;
                }
                return (FlinkSqlValidationResult)FlinkShimsProxy.getObject((ClassLoader)this.getClass().getClassLoader(), (Object)result);
            }
            catch (Throwable e) {
                log.error("verifySql invocationTargetException: {}", (Object)Utils.stringifyException((Throwable)e));
                return null;
            }
        });
    }

    @Override
    public List<FlinkSql> getByTeamId(Long teamId) {
        return ((FlinkSqlMapper)this.baseMapper).getByTeamId(teamId);
    }

    @Override
    public IPage<FlinkSql> page(Long appId, RestRequest request) {
        request.setSortField("version");
        Page page = MybatisPager.getPage(request);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkSql::getAppId, (Object)appId);
        IPage sqlList = ((FlinkSqlMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        FlinkSql effectiveSql = ((FlinkSqlMapper)this.baseMapper).getEffective(appId);
        if (effectiveSql != null) {
            for (FlinkSql sql : sqlList.getRecords()) {
                if (!sql.getId().equals(effectiveSql.getId())) continue;
                sql.setEffective(true);
                break;
            }
        }
        return sqlList;
    }
}

