/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.commons.ObjectClassMappingConfig;
import net.tirasa.connid.bundles.ldap.schema.LdapSchema;
import net.tirasa.connid.bundles.ldap.search.DefaultSearchStrategy;
import net.tirasa.connid.bundles.ldap.sync.LdapSyncStrategy;
import net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.EqualsHashCodeBuilder;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.operations.SyncOp;

public class LdapConfiguration
extends AbstractConfiguration {
    public static final int DEFAULT_PORT = 389;
    private static final String DEFAULT_ID_ATTRIBUTE = "entryUUID";
    private String host;
    private int port = 389;
    private boolean ssl;
    private boolean startTLSEnabled = false;
    private String[] failover = new String[0];
    private String principal;
    private GuardedString credentials;
    private String[] baseContexts = new String[0];
    private String passwordAttribute = "userPassword";
    private String accountSearchFilter = null;
    private String groupSearchFilter = null;
    private String anyObjectSearchFilter = null;
    private String groupMemberAttribute = "uniqueMember";
    private boolean maintainLdapGroupMembership = false;
    private boolean maintainPosixGroupMembership = false;
    private boolean addPrincipalToNewGroups = false;
    private String passwordHashAlgorithm;
    private boolean respectResourcePasswordPolicyChangeAfterReset;
    private boolean useVlvControls = false;
    private String vlvSortAttribute = "uid";
    private String uidAttribute = "entryUUID";
    private String gidAttribute = "entryUUID";
    private String aoidAttribute = "entryUUID";
    private boolean readSchema = true;
    private String[] baseContextsToSynchronize = new String[0];
    private String[] objectClassesToSynchronize = new String[]{"inetOrgPerson"};
    private String[] attributesToSynchronize = new String[0];
    private String[] modifiersNamesToFilterOut = new String[0];
    private String accountSynchronizationFilter;
    private int changeLogBlockSize = 100;
    private String changeNumberAttribute = "changeNumber";
    private String changeLogContext = "cn=changelog";
    private boolean changeLogPagingSupport = false;
    private boolean filterWithOrInsteadOfAnd;
    private boolean removeLogEntryObjectClassFromFilter = true;
    private boolean synchronizePasswords;
    private String passwordAttributeToSynchronize;
    private GuardedByteArray passwordDecryptionKey;
    private GuardedByteArray passwordDecryptionInitializationVector;
    private String statusManagementClass;
    private String dnAttribute = "entryDN";
    private String syncStrategy = SunDSChangeLogSyncStrategy.class.getName();
    private Class<? extends LdapSyncStrategy> syncStrategyClass = null;
    private Class<? extends LdapSyncStrategy> fallbackSyncStrategyClass = SunDSChangeLogSyncStrategy.class;
    private Class<? extends LdapConnection> connectionClass = LdapConnection.class;
    private SearchScope userSearchScope = SearchScope.subtree;
    private SearchScope groupSearchScope = SearchScope.subtree;
    private SearchScope anyObjectSearchScope = SearchScope.subtree;
    private boolean retrievePasswordsWithSearch;
    private final ObjectClassMappingConfig accountConfig = new ObjectClassMappingConfig(ObjectClass.ACCOUNT, CollectionUtil.newList((Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}), false, CollectionUtil.newList((Object[])new String[]{"uid", "cn"}), LdapConstants.PASSWORD);
    private final ObjectClassMappingConfig groupConfig = new ObjectClassMappingConfig(ObjectClass.GROUP, CollectionUtil.newList((Object[])new String[]{"top", "groupOfUniqueNames"}), false, CollectionUtil.newList((Object[])new String[]{"cn"}), new AttributeInfo[0]);
    private final ObjectClassMappingConfig anyObjectConfig = new ObjectClassMappingConfig(LdapSchema.ANY_OBJECT_CLASS, CollectionUtil.newList((Object[])new String[]{"top"}), false, CollectionUtil.newList((Object[])new String[]{"entryUUID"}), new AttributeInfo[0]);
    private final ObjectClassMappingConfig allConfig = new ObjectClassMappingConfig(ObjectClass.ALL, CollectionUtil.newList((Object[])new String[]{"top"}), false, CollectionUtil.newList((Object[])new String[]{"entryUUID"}), new AttributeInfo[0]);
    private List<LdapName> baseContextsAsLdapNames;
    private List<LdapName> baseContextsToSynchronizeAsLdapNames;
    private Set<LdapName> modifiersNamesToFilterOutAsLdapNames;
    private long readTimeout = 0L;
    private long connectTimeout = 0L;

    public void validate() {
        this.checkNotBlank(this.host, "host.notBlank");
        if (this.port < 0 || this.port > 65535) {
            this.failValidation("port.legalValue", new Object[0]);
        }
        this.checkNotEmpty(this.baseContexts, "baseContexts.notEmpty");
        this.checkNoBlankValues(this.baseContexts, "baseContexts.noBlankValues");
        this.checkNoInvalidLdapNames(this.baseContexts, "baseContexts.noInvalidLdapNames");
        this.checkNotBlank(this.passwordAttribute, "passwordAttribute.notBlank");
        this.checkNotEmpty(this.accountConfig.getLdapClasses(), "accountObjectClasses.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getLdapClasses(), "accountObjectClasses.noBlankValues");
        this.checkNotEmpty(this.accountConfig.getShortNameLdapAttributes(), "accountUserNameAttributes.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getShortNameLdapAttributes(), "accountUserNameAttributes.noBlankValues");
        this.checkNotEmpty(this.groupConfig.getLdapClasses(), "groupObjectClasses.notEmpty");
        this.checkNoBlankValues(this.groupConfig.getLdapClasses(), "groupObjectClasses.noBlankValues");
        this.checkNotEmpty(this.groupConfig.getShortNameLdapAttributes(), "groupNameAttributes.notEmpty");
        this.checkNoBlankValues(this.groupConfig.getShortNameLdapAttributes(), "groupNameAttributes.noBlankValues");
        this.checkNotEmpty(this.anyObjectConfig.getLdapClasses(), "anyObjectClasses.notEmpty");
        this.checkNoBlankValues(this.anyObjectConfig.getLdapClasses(), "anyObjectClasses.noBlankValues");
        this.checkNotEmpty(this.anyObjectConfig.getShortNameLdapAttributes(), "anyObjectNameAttributes.notEmpty");
        this.checkNoBlankValues(this.anyObjectConfig.getShortNameLdapAttributes(), "anyObjectNameAttributes.noBlankValues");
        this.checkNotBlank(this.getUserSearchScope(), "userSearchScope.notBlank");
        this.checkValidScope(this.getUserSearchScope(), "userSearchScope.invalidScope");
        this.checkNotBlank(this.getGroupSearchScope(), "groupSearchScope.notBlank");
        this.checkValidScope(this.getGroupSearchScope(), "groupSearchScope.invalidScope");
        this.checkNotBlank(this.getAnyObjectSearchScope(), "anyObjectSearchScope.notBlank");
        this.checkValidScope(this.getAnyObjectSearchScope(), "anyObjectSearchScope.invalidScope");
        this.checkNotBlank(this.groupMemberAttribute, "groupMemberAttribute.notBlank");
        this.checkNotBlank(this.vlvSortAttribute, "vlvSortAttribute.notBlank");
        if (this.baseContextsToSynchronize != null) {
            this.checkNoBlankValues(this.baseContextsToSynchronize, "baseContextsToSynchronize.noBlankValues");
            this.checkNoInvalidLdapNames(this.baseContextsToSynchronize, "baseContextsToSynchronize.noInvalidLdapNames");
        }
        this.checkNotEmpty(this.objectClassesToSynchronize, "objectClassesToSynchronize.notEmpty");
        this.checkNoBlankValues(this.objectClassesToSynchronize, "objectClassesToSynchronize.noBlankValues");
        if (this.attributesToSynchronize != null) {
            this.checkNoBlankValues(this.attributesToSynchronize, "attributesToSynchronize.noBlankValues");
        }
        if (this.modifiersNamesToFilterOut != null) {
            this.checkNoBlankValues(this.modifiersNamesToFilterOut, "modifiersNamesToFilterOut.noBlankValues");
            this.checkNoInvalidLdapNames(this.modifiersNamesToFilterOut, "modifiersNamesToFilterOut.noInvalidLdapNames");
        }
        this.checkNotBlank(this.changeNumberAttribute, "changeNumberAttribute.notBlank");
        if (this.changeLogBlockSize <= 0) {
            this.failValidation("changeLogBlockSize.legalValue", new Object[0]);
        }
        this.checkNotBlank(this.changeLogContext, "changeLogContext.notBlank");
        if (this.synchronizePasswords) {
            this.checkNotBlank(this.passwordAttributeToSynchronize, "passwordAttributeToSynchronize.notBlank");
            this.checkNotBlank(this.passwordDecryptionKey, "decryptionKey.notBlank");
            this.checkNotBlank(this.passwordDecryptionInitializationVector, "decryptionInitializationVector.notBlank");
        }
        this.checkNotBlank(this.syncStrategy, "syncStrategy.notBlank");
        this.checkLdapSyncStrategy();
    }

    protected void checkNotBlank(String value, String errorMessage) {
        if (StringUtil.isBlank((String)value)) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    protected void checkNotBlank(GuardedByteArray array, String errorMessage) {
        final int[] length = new int[]{0};
        if (array != null) {
            array.access(new GuardedByteArray.Accessor(){

                public void access(byte[] clearBytes) {
                    length[0] = clearBytes.length;
                }
            });
        }
        if (length[0] == 0) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    protected void checkLdapSyncStrategy() {
        try {
            Class<?> clazz = Class.forName(this.syncStrategy);
            if (LdapSyncStrategy.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
                this.syncStrategyClass = clazz;
            } else {
                this.failValidation("syncStrategy.classNotSyncStrategy", new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            this.failValidation("syncStrategy.classNotFound", new Object[0]);
        }
    }

    protected void checkNotEmpty(Collection<?> collection, String errorMessage) {
        if (collection.isEmpty()) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    protected void checkNotEmpty(String[] array, String errorMessage) {
        if (array == null || array.length < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    protected void checkNoBlankValues(Collection<String> collection, String errorMessage) {
        for (String each : collection) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    protected void checkNoBlankValues(String[] array, String errorMessage) {
        for (String each : array) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    protected void checkNoInvalidLdapNames(String[] array, String errorMessage) {
        for (String each : array) {
            try {
                new LdapName(each);
            }
            catch (InvalidNameException e) {
                this.failValidation(errorMessage, each);
            }
        }
    }

    protected void checkValidScope(String scope, String errorMessage) {
        switch (scope) {
            case "object": 
            case "onelevel": 
            case "subtree": {
                break;
            }
            default: {
                this.failValidation(errorMessage, new Object[0]);
            }
        }
    }

    protected void failValidation(String key, Object ... args) {
        String message = this.getConnectorMessages().format(key, null, args);
        throw new ConfigurationException(message);
    }

    public DefaultSearchStrategy newDefaultSearchStrategy(boolean ignoreNonExistingBaseDN) {
        return new DefaultSearchStrategy(ignoreNonExistingBaseDN);
    }

    @ConfigurationProperty(order=1, required=true, displayMessageKey="host.display", helpMessageKey="host.help")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @ConfigurationProperty(order=2, displayMessageKey="port.display", helpMessageKey="port.help")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ConfigurationProperty(order=3, displayMessageKey="ssl.display", helpMessageKey="ssl.help")
    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @ConfigurationProperty(order=4, displayMessageKey="failover.display", helpMessageKey="failover.help")
    public String[] getFailover() {
        return (String[])this.failover.clone();
    }

    public void setFailover(String ... failover) {
        this.failover = failover;
    }

    @ConfigurationProperty(order=5, displayMessageKey="principal.display", helpMessageKey="principal.help")
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @ConfigurationProperty(order=6, confidential=true, displayMessageKey="credentials.display", helpMessageKey="credentials.help")
    public GuardedString getCredentials() {
        return this.credentials;
    }

    public void setCredentials(GuardedString credentials) {
        this.credentials = credentials != null ? credentials.copy() : null;
    }

    @ConfigurationProperty(order=7, required=true, displayMessageKey="baseContexts.display", helpMessageKey="baseContexts.help")
    public String[] getBaseContexts() {
        return (String[])this.baseContexts.clone();
    }

    public void setBaseContexts(String ... baseContexts) {
        this.baseContexts = (String[])baseContexts.clone();
    }

    @ConfigurationProperty(order=8, displayMessageKey="passwordAttribute.display", helpMessageKey="passwordAttribute.help")
    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    @ConfigurationProperty(order=9, displayMessageKey="accountObjectClasses.display", helpMessageKey="accountObjectClasses.help")
    public String[] getAccountObjectClasses() {
        List<String> ldapClasses = this.accountConfig.getLdapClasses();
        return ldapClasses.toArray(new String[0]);
    }

    public void setAccountObjectClasses(String ... accountObjectClasses) {
        this.accountConfig.setLdapClasses(Arrays.asList(accountObjectClasses));
    }

    @ConfigurationProperty(order=10, displayMessageKey="accountUserNameAttributes.display", helpMessageKey="accountUserNameAttributes.help")
    public String[] getAccountUserNameAttributes() {
        List<String> shortNameLdapAttributes = this.accountConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[0]);
    }

    public void setAccountUserNameAttributes(String ... accountUserNameAttributes) {
        this.accountConfig.setShortNameLdapAttributes(Arrays.asList(accountUserNameAttributes));
    }

    @ConfigurationProperty(order=11, displayMessageKey="userSearchScope.display", helpMessageKey="userSearchScope.help")
    public String getUserSearchScope() {
        return this.userSearchScope.toString();
    }

    public void setUserSearchScope(String userSearchScope) {
        this.userSearchScope = SearchScope.valueOf(userSearchScope.toLowerCase());
    }

    @ConfigurationProperty(order=12, displayMessageKey="accountSearchFilter.display", helpMessageKey="accountSearchFilter.help")
    public String getAccountSearchFilter() {
        return this.accountSearchFilter;
    }

    public void setAccountSearchFilter(String accountSearchFilter) {
        this.accountSearchFilter = accountSearchFilter;
    }

    @ConfigurationProperty(order=13, displayMessageKey="groupObjectClasses.display", helpMessageKey="groupObjectClasses.help")
    public String[] getGroupObjectClasses() {
        List<String> ldapClasses = this.groupConfig.getLdapClasses();
        return ldapClasses.toArray(new String[0]);
    }

    public void setGroupObjectClasses(String ... groupObjectClasses) {
        this.groupConfig.setLdapClasses(Arrays.asList(groupObjectClasses));
    }

    @ConfigurationProperty(order=14, displayMessageKey="groupNameAttributes.display", helpMessageKey="groupNameAttributes.help")
    public String[] getGroupNameAttributes() {
        List<String> shortNameLdapAttributes = this.groupConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[0]);
    }

    public void setGroupNameAttributes(String ... groupNameAttributes) {
        this.groupConfig.setShortNameLdapAttributes(Arrays.asList(groupNameAttributes));
    }

    @ConfigurationProperty(order=15, displayMessageKey="groupSearchScope.display", helpMessageKey="groupSearchScope.help")
    public String getGroupSearchScope() {
        return this.groupSearchScope.toString();
    }

    public void setGroupSearchScope(String groupSearchScope) {
        this.groupSearchScope = SearchScope.valueOf(groupSearchScope.toLowerCase());
    }

    @ConfigurationProperty(order=16, displayMessageKey="groupMemberAttribute.display", helpMessageKey="groupMemberAttribute.help")
    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    @ConfigurationProperty(order=17, displayMessageKey="maintainLdapGroupMembership.display", helpMessageKey="maintainLdapGroupMembership.help")
    public boolean isMaintainLdapGroupMembership() {
        return this.maintainLdapGroupMembership;
    }

    public void setMaintainLdapGroupMembership(boolean maintainLdapGroupMembership) {
        this.maintainLdapGroupMembership = maintainLdapGroupMembership;
    }

    @ConfigurationProperty(order=18, displayMessageKey="maintainPosixGroupMembership.display", helpMessageKey="maintainPosixGroupMembership.help")
    public boolean isMaintainPosixGroupMembership() {
        return this.maintainPosixGroupMembership;
    }

    public void setMaintainPosixGroupMembership(boolean maintainPosixGroupMembership) {
        this.maintainPosixGroupMembership = maintainPosixGroupMembership;
    }

    @ConfigurationProperty(order=19, displayMessageKey="addPrincipalToNewGroups.display", helpMessageKey="addPrincipalToNewGroups.help")
    public boolean isAddPrincipalToNewGroups() {
        return this.addPrincipalToNewGroups;
    }

    public void setAddPrincipalToNewGroups(boolean addPrincipalToNewGroups) {
        this.addPrincipalToNewGroups = addPrincipalToNewGroups;
    }

    @ConfigurationProperty(order=20, displayMessageKey="anyObjectClasses.display", helpMessageKey="anyObjectClasses.help")
    public String[] getAnyObjectClasses() {
        List<String> ldapClasses = this.anyObjectConfig.getLdapClasses();
        return ldapClasses.toArray(new String[0]);
    }

    public void setAnyObjectClasses(String ... anyObjectClasses) {
        this.anyObjectConfig.setLdapClasses(Arrays.asList(anyObjectClasses));
    }

    @ConfigurationProperty(order=21, displayMessageKey="anyObjectNameAttributes.display", helpMessageKey="anyObjectNameAttributes.help")
    public String[] getAnyObjectNameAttributes() {
        List<String> shortNameLdapAttributes = this.anyObjectConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[0]);
    }

    public void setAnyObjectNameAttributes(String ... anyObjectNameAttributes) {
        this.anyObjectConfig.setShortNameLdapAttributes(Arrays.asList(anyObjectNameAttributes));
    }

    @ConfigurationProperty(order=22, displayMessageKey="anyObjectSearchFilter.display", helpMessageKey="anyObjectSearchFilter.help")
    public String getAnyObjectSearchFilter() {
        return this.anyObjectSearchFilter;
    }

    public void setAnyObjectSearchFilter(String anyObjectSearchFilter) {
        this.anyObjectSearchFilter = anyObjectSearchFilter;
    }

    @ConfigurationProperty(order=23, displayMessageKey="anyObjectSearchScope.display", helpMessageKey="anyObjectSearchScope.help")
    public String getAnyObjectSearchScope() {
        return this.anyObjectSearchScope.toString();
    }

    public void setAnyObjectSearchScope(String anyObjectSearchScope) {
        this.anyObjectSearchScope = SearchScope.valueOf(anyObjectSearchScope.toLowerCase());
    }

    @ConfigurationProperty(order=24, displayMessageKey="passwordHashAlgorithm.display", helpMessageKey="passwordHashAlgorithm.help")
    public String getPasswordHashAlgorithm() {
        return this.passwordHashAlgorithm;
    }

    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        this.passwordHashAlgorithm = passwordHashAlgorithm;
    }

    @ConfigurationProperty(order=25, displayMessageKey="respectResourcePasswordPolicyChangeAfterReset.display", helpMessageKey="respectResourcePasswordPolicyChangeAfterReset.help")
    public boolean isRespectResourcePasswordPolicyChangeAfterReset() {
        return this.respectResourcePasswordPolicyChangeAfterReset;
    }

    public void setRespectResourcePasswordPolicyChangeAfterReset(boolean respectResourcePasswordPolicyChangeAfterReset) {
        this.respectResourcePasswordPolicyChangeAfterReset = respectResourcePasswordPolicyChangeAfterReset;
    }

    @ConfigurationProperty(order=26, displayMessageKey="useVlvControls.display", helpMessageKey="useVlvControls.help")
    public boolean isUseVlvControls() {
        return this.useVlvControls;
    }

    public void setUseVlvControls(boolean useVlvControls) {
        this.useVlvControls = useVlvControls;
    }

    @ConfigurationProperty(order=27, displayMessageKey="vlvSortAttribute.display", helpMessageKey="vlvSortAttribute.help")
    public String getVlvSortAttribute() {
        return this.vlvSortAttribute;
    }

    public void setVlvSortAttribute(String vlvSortAttribute) {
        this.vlvSortAttribute = vlvSortAttribute;
    }

    @ConfigurationProperty(order=28, displayMessageKey="uidAttribute.display", helpMessageKey="uidAttribute.help")
    public String getUidAttribute() {
        return this.uidAttribute;
    }

    public void setUidAttribute(String uidAttribute) {
        this.uidAttribute = uidAttribute;
    }

    @ConfigurationProperty(order=29, displayMessageKey="gidAttribute.display", helpMessageKey="gidAttribute.help")
    public String getGidAttribute() {
        return this.gidAttribute;
    }

    public void setGidAttribute(String gidAttribute) {
        this.gidAttribute = gidAttribute;
    }

    @ConfigurationProperty(order=30, displayMessageKey="aoidAttribute.display", helpMessageKey="aoidAttribute.help")
    public String getAoidAttribute() {
        return this.aoidAttribute;
    }

    public void setAoidAttribute(String aoidAttribute) {
        this.aoidAttribute = aoidAttribute;
    }

    @ConfigurationProperty(order=31, displayMessageKey="readSchema.display", helpMessageKey="readSchema.help")
    public boolean isReadSchema() {
        return this.readSchema;
    }

    public void setReadSchema(boolean readSchema) {
        this.readSchema = readSchema;
    }

    @ConfigurationProperty(order=32, operations={SyncOp.class}, displayMessageKey="baseContextsToSynchronize.display", helpMessageKey="baseContextsToSynchronize.help")
    public String[] getBaseContextsToSynchronize() {
        return (String[])this.baseContextsToSynchronize.clone();
    }

    public void setBaseContextsToSynchronize(String ... baseContextsToSynchronize) {
        this.baseContextsToSynchronize = (String[])baseContextsToSynchronize.clone();
    }

    @ConfigurationProperty(order=33, operations={SyncOp.class}, displayMessageKey="objectClassesToSynchronize.display", helpMessageKey="objectClassesToSynchronize.help")
    public String[] getObjectClassesToSynchronize() {
        return (String[])this.objectClassesToSynchronize.clone();
    }

    public void setObjectClassesToSynchronize(String ... objectClassesToSynchronize) {
        this.objectClassesToSynchronize = (String[])objectClassesToSynchronize.clone();
    }

    @ConfigurationProperty(order=34, operations={SyncOp.class}, displayMessageKey="attributesToSynchronize.display", helpMessageKey="attributesToSynchronize.help")
    public String[] getAttributesToSynchronize() {
        return (String[])this.attributesToSynchronize.clone();
    }

    public void setAttributesToSynchronize(String ... attributesToSynchronize) {
        this.attributesToSynchronize = (String[])attributesToSynchronize.clone();
    }

    @ConfigurationProperty(order=35, operations={SyncOp.class}, displayMessageKey="modifiersNamesToFilterOut.display", helpMessageKey="modifiersNamesToFilterOut.help")
    public String[] getModifiersNamesToFilterOut() {
        return (String[])this.modifiersNamesToFilterOut.clone();
    }

    public void setModifiersNamesToFilterOut(String ... modifiersNamesToFilterOut) {
        this.modifiersNamesToFilterOut = (String[])modifiersNamesToFilterOut.clone();
    }

    @ConfigurationProperty(order=36, operations={SyncOp.class}, displayMessageKey="accountSynchronizationFilter.display", helpMessageKey="accountSynchronizationFilter.help")
    public String getAccountSynchronizationFilter() {
        return this.accountSynchronizationFilter;
    }

    public void setAccountSynchronizationFilter(String accountSynchronizationFilter) {
        this.accountSynchronizationFilter = accountSynchronizationFilter;
    }

    @ConfigurationProperty(order=37, operations={SyncOp.class}, displayMessageKey="changeLogBlockSize.display", helpMessageKey="changeLogBlockSize.help")
    public int getChangeLogBlockSize() {
        return this.changeLogBlockSize;
    }

    public void setChangeLogBlockSize(int changeLogBlockSize) {
        this.changeLogBlockSize = changeLogBlockSize;
    }

    @ConfigurationProperty(order=38, operations={SyncOp.class}, displayMessageKey="changeNumberAttribute.display", helpMessageKey="changeNumberAttribute.help")
    public String getChangeNumberAttribute() {
        return this.changeNumberAttribute;
    }

    public void setChangeNumberAttribute(String changeNumberAttribute) {
        this.changeNumberAttribute = changeNumberAttribute;
    }

    @ConfigurationProperty(order=39, operations={SyncOp.class}, displayMessageKey="changeLogContext.display", helpMessageKey="changeNumberAttribute.help")
    public String getChangeLogContext() {
        return this.changeLogContext;
    }

    public void setChangeLogContext(String changeLogContext) {
        this.changeLogContext = changeLogContext;
    }

    @ConfigurationProperty(order=40, operations={SyncOp.class}, displayMessageKey="changeLogPagingSupport.display", helpMessageKey="changeLogPagingSupport.help")
    public boolean getChangeLogPagingSupport() {
        return this.changeLogPagingSupport;
    }

    public void setChangeLogPagingSupport(boolean changeLogPagingSupport) {
        this.changeLogPagingSupport = changeLogPagingSupport;
    }

    @ConfigurationProperty(order=41, operations={SyncOp.class}, displayMessageKey="filterWithOrInsteadOfAnd.display", helpMessageKey="filterWithOrInsteadOfAnd.help")
    public boolean isFilterWithOrInsteadOfAnd() {
        return this.filterWithOrInsteadOfAnd;
    }

    public void setFilterWithOrInsteadOfAnd(boolean filterWithOrInsteadOfAnd) {
        this.filterWithOrInsteadOfAnd = filterWithOrInsteadOfAnd;
    }

    @ConfigurationProperty(order=42, operations={SyncOp.class}, displayMessageKey="removeLogEntryObjectClassFromFilter.display", helpMessageKey="removeLogEntryObjectClassFromFilter.help")
    public boolean isRemoveLogEntryObjectClassFromFilter() {
        return this.removeLogEntryObjectClassFromFilter;
    }

    public void setRemoveLogEntryObjectClassFromFilter(boolean removeLogEntryObjectClassFromFilter) {
        this.removeLogEntryObjectClassFromFilter = removeLogEntryObjectClassFromFilter;
    }

    @ConfigurationProperty(order=43, operations={SyncOp.class}, displayMessageKey="synchronizePasswords.display", helpMessageKey="synchronizePasswords.help")
    public boolean isSynchronizePasswords() {
        return this.synchronizePasswords;
    }

    public void setSynchronizePasswords(boolean synchronizePasswords) {
        this.synchronizePasswords = synchronizePasswords;
    }

    @ConfigurationProperty(order=44, operations={SyncOp.class}, displayMessageKey="passwordAttributeToSynchronize.display", helpMessageKey="passwordAttributeToSynchronize.help")
    public String getPasswordAttributeToSynchronize() {
        return this.passwordAttributeToSynchronize;
    }

    public void setPasswordAttributeToSynchronize(String passwordAttributeToSynchronize) {
        this.passwordAttributeToSynchronize = passwordAttributeToSynchronize;
    }

    @ConfigurationProperty(order=45, operations={SyncOp.class}, confidential=true, displayMessageKey="passwordDecryptionKey.display", helpMessageKey="passwordDecryptionKey.help")
    public GuardedByteArray getPasswordDecryptionKey() {
        return this.passwordDecryptionKey;
    }

    public void setPasswordDecryptionKey(GuardedByteArray passwordDecryptionKey) {
        this.passwordDecryptionKey = passwordDecryptionKey != null ? passwordDecryptionKey.copy() : null;
    }

    @ConfigurationProperty(order=46, operations={SyncOp.class}, confidential=true, displayMessageKey="passwordDecryptionInitializationVector.display", helpMessageKey="passwordDecryptionInitializationVector.help")
    public GuardedByteArray getPasswordDecryptionInitializationVector() {
        return this.passwordDecryptionInitializationVector;
    }

    public void setPasswordDecryptionInitializationVector(GuardedByteArray passwordDecryptionInitializationVector) {
        this.passwordDecryptionInitializationVector = passwordDecryptionInitializationVector != null ? passwordDecryptionInitializationVector.copy() : null;
    }

    @ConfigurationProperty(order=47, displayMessageKey="statusManagementClass.display", helpMessageKey="statusManagementClass.help")
    public String getStatusManagementClass() {
        return this.statusManagementClass;
    }

    public void setStatusManagementClass(String statusManagementClass) {
        this.statusManagementClass = statusManagementClass;
    }

    @ConfigurationProperty(order=48, displayMessageKey="retrievePasswordsWithSearch.display", helpMessageKey="retrievePasswordsWithSearch.help")
    public boolean getRetrievePasswordsWithSearch() {
        return this.retrievePasswordsWithSearch;
    }

    public void setRetrievePasswordsWithSearch(boolean retrievePasswordsWithSearch) {
        this.retrievePasswordsWithSearch = retrievePasswordsWithSearch;
    }

    @ConfigurationProperty(order=49, displayMessageKey="dnAttribute.display", helpMessageKey="dnAttribute.help")
    public String getDnAttribute() {
        return this.dnAttribute;
    }

    public void setDnAttribute(String dnAttribute) {
        this.dnAttribute = dnAttribute;
    }

    @ConfigurationProperty(order=50, displayMessageKey="groupSearchFilter.display", helpMessageKey="groupSearchFilter.help")
    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    @ConfigurationProperty(order=51, displayMessageKey="readTimeout.display", helpMessageKey="readTimeout.help")
    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    @ConfigurationProperty(order=52, displayMessageKey="connectTimeout.display", helpMessageKey="connectTimeout.help")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @ConfigurationProperty(order=43, displayMessageKey="startTLSEnabled.display", helpMessageKey="startTLSEnabled.help")
    public boolean isStartTLSEnabled() {
        return this.startTLSEnabled;
    }

    public void setStartTLSEnabled(boolean startTLSEnabled) {
        this.startTLSEnabled = startTLSEnabled;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @ConfigurationProperty(order=53, displayMessageKey="syncStrategy.display", helpMessageKey="syncStrategy.help")
    public String getSyncStrategy() {
        return this.syncStrategy;
    }

    public void setSyncStrategy(String syncStrategy) {
        this.syncStrategy = syncStrategy;
    }

    public Class<? extends LdapSyncStrategy> getSyncStrategyClass() {
        return this.syncStrategyClass;
    }

    protected Class<? extends LdapSyncStrategy> getFallbackSyncStrategyClass() {
        return this.fallbackSyncStrategyClass;
    }

    protected void setFallbackSyncStrategyClass(Class<? extends LdapSyncStrategy> fallbackSyncStrategyClass) {
        this.fallbackSyncStrategyClass = fallbackSyncStrategyClass;
    }

    protected Class<? extends LdapConnection> getConnectionClass() {
        return this.connectionClass;
    }

    protected void setConnectionClass(Class<? extends LdapConnection> connectionClass) {
        this.connectionClass = connectionClass;
    }

    public List<LdapName> getBaseContextsAsLdapNames() {
        if (this.baseContextsAsLdapNames == null) {
            ArrayList<LdapName> result = new ArrayList<LdapName>(this.baseContexts.length);
            try {
                for (String baseContext : this.baseContexts) {
                    result.add(new LdapName(baseContext));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.baseContextsAsLdapNames = result;
        }
        return this.baseContextsAsLdapNames;
    }

    public List<LdapName> getBaseContextsToSynchronizeAsLdapNames() {
        if (this.baseContextsToSynchronizeAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.baseContextsToSynchronize);
            ArrayList<LdapName> result = new ArrayList<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.baseContextsToSynchronizeAsLdapNames = result;
        }
        return this.baseContextsToSynchronizeAsLdapNames;
    }

    public Set<LdapName> getModifiersNamesToFilterOutAsLdapNames() {
        if (this.modifiersNamesToFilterOutAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.modifiersNamesToFilterOut);
            HashSet<LdapName> result = new HashSet<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.modifiersNamesToFilterOutAsLdapNames = result;
        }
        return this.modifiersNamesToFilterOutAsLdapNames;
    }

    public Map<ObjectClass, ObjectClassMappingConfig> getObjectClassMappingConfigs() {
        HashMap<ObjectClass, ObjectClassMappingConfig> result = new HashMap<ObjectClass, ObjectClassMappingConfig>();
        result.put(this.accountConfig.getObjectClass(), this.accountConfig);
        result.put(this.groupConfig.getObjectClass(), this.groupConfig);
        result.put(this.anyObjectConfig.getObjectClass(), this.anyObjectConfig);
        result.put(this.allConfig.getObjectClass(), this.allConfig);
        return result;
    }

    protected EqualsHashCodeBuilder createHashCodeBuilder() {
        EqualsHashCodeBuilder builder = new EqualsHashCodeBuilder();
        builder.append((Object)this.host);
        builder.append((Object)this.port);
        builder.append((Object)this.ssl);
        builder.append((Object)this.failover);
        builder.append((Object)this.principal);
        builder.append((Object)this.credentials);
        for (String baseContext : this.baseContexts) {
            builder.append((Object)baseContext);
        }
        builder.append((Object)this.passwordAttribute);
        builder.append((Object)this.accountSearchFilter);
        builder.append((Object)this.groupMemberAttribute);
        builder.append((Object)this.maintainLdapGroupMembership);
        builder.append((Object)this.maintainPosixGroupMembership);
        builder.append((Object)this.passwordHashAlgorithm);
        builder.append((Object)this.respectResourcePasswordPolicyChangeAfterReset);
        builder.append((Object)this.useVlvControls);
        builder.append((Object)this.vlvSortAttribute);
        builder.append((Object)this.readSchema);
        for (String baseContextToSynchronize : this.baseContextsToSynchronize) {
            builder.append((Object)baseContextToSynchronize);
        }
        for (String objectClassToSynchronize : this.objectClassesToSynchronize) {
            builder.append((Object)objectClassToSynchronize);
        }
        for (String attributeToSynchronize : this.attributesToSynchronize) {
            builder.append((Object)attributeToSynchronize);
        }
        for (String modifiersNameToFilterOut : this.modifiersNamesToFilterOut) {
            builder.append((Object)modifiersNameToFilterOut);
        }
        builder.append((Object)this.accountSynchronizationFilter);
        builder.append((Object)this.changeLogBlockSize);
        builder.append((Object)this.changeNumberAttribute);
        builder.append((Object)this.filterWithOrInsteadOfAnd);
        builder.append((Object)this.removeLogEntryObjectClassFromFilter);
        builder.append((Object)this.synchronizePasswords);
        builder.append((Object)this.passwordAttributeToSynchronize);
        builder.append((Object)this.passwordDecryptionKey);
        builder.append((Object)this.passwordDecryptionInitializationVector);
        builder.append((Object)this.accountConfig);
        builder.append((Object)this.groupConfig);
        builder.append((Object)this.retrievePasswordsWithSearch);
        builder.append((Object)this.groupSearchFilter);
        builder.append((Object)this.connectTimeout);
        builder.append((Object)this.readTimeout);
        return builder;
    }

    public int hashCode() {
        return this.createHashCodeBuilder().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LdapConfiguration) {
            LdapConfiguration that = (LdapConfiguration)((Object)obj);
            if (this == that) {
                return true;
            }
            return this.createHashCodeBuilder().equals((Object)that.createHashCodeBuilder());
        }
        return false;
    }

    public static enum SearchScope {
        object,
        onelevel,
        subtree;

    }
}

