/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.self;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.self.SelfKeymasterClientExceptionMapper;
import org.apache.syncope.common.keymaster.client.self.SelfKeymasterConfParamOps;
import org.apache.syncope.common.keymaster.client.self.SelfKeymasterDomainOps;
import org.apache.syncope.common.keymaster.client.self.SelfKeymasterServiceOps;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@EnableConfigurationProperties(value={KeymasterProperties.class})
@Configuration(proxyBeanMethods=false)
public class SelfKeymasterClientContext {
    private static final Pattern HTTP = Pattern.compile("^http.+");

    @Conditional(value={SelfKeymasterCondition.class})
    @Bean
    @ConditionalOnMissingBean(name={"selfKeymasterRESTClientFactoryBean"})
    public JAXRSClientFactoryBean selfKeymasterRESTClientFactoryBean(KeymasterProperties props) {
        JAXRSClientFactoryBean restClientFactoryBean = new JAXRSClientFactoryBean();
        restClientFactoryBean.setAddress(props.getAddress());
        restClientFactoryBean.setUsername(props.getUsername());
        restClientFactoryBean.setPassword(props.getPassword());
        restClientFactoryBean.setThreadSafe(true);
        restClientFactoryBean.setInheritHeaders(true);
        restClientFactoryBean.getFeatures().add(new LoggingFeature());
        restClientFactoryBean.setProviders(List.of(new JacksonJsonProvider(((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build()), new SelfKeymasterClientExceptionMapper()));
        return restClientFactoryBean;
    }

    @Conditional(value={SelfKeymasterCondition.class})
    @Bean
    @ConditionalOnMissingBean(name={"selfConfParamOps"})
    public ConfParamOps selfConfParamOps(@Qualifier(value="selfKeymasterRESTClientFactoryBean") JAXRSClientFactoryBean selfKeymasterRESTClientFactoryBean) {
        return new SelfKeymasterConfParamOps(selfKeymasterRESTClientFactoryBean);
    }

    @Conditional(value={SelfKeymasterCondition.class})
    @Bean
    @ConditionalOnMissingBean(name={"selfServiceOps"})
    public ServiceOps selfServiceOps(@Qualifier(value="selfKeymasterRESTClientFactoryBean") JAXRSClientFactoryBean selfKeymasterRESTClientFactoryBean) {
        return new SelfKeymasterServiceOps(selfKeymasterRESTClientFactoryBean, 5);
    }

    @Conditional(value={SelfKeymasterCondition.class})
    @Bean
    @ConditionalOnMissingBean(name={"domainOps"})
    public DomainOps domainOps(@Qualifier(value="selfKeymasterRESTClientFactoryBean") JAXRSClientFactoryBean selfKeymasterRESTClientFactoryBean) {
        return new SelfKeymasterDomainOps(selfKeymasterRESTClientFactoryBean);
    }

    static class SelfKeymasterCondition
    extends SpringBootCondition {
        SelfKeymasterCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String keymasterAddress = context.getEnvironment().getProperty("keymaster.address");
            return new ConditionOutcome(keymasterAddress != null && HTTP.matcher(keymasterAddress).matches(), "Keymaster address not set for Self: " + keymasterAddress);
        }
    }
}

