/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.util.Assert;

public class SchedulerDBInit
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerDBInit.class);
    private DataSource dataSource;
    private DatabasePopulator databasePopulator;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    public void afterPropertiesSet() throws Exception {
        boolean existingData;
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must be set");
        Assert.state((this.databasePopulator != null ? 1 : 0) != 0, (String)"DatabasePopulator must be set");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        try {
            existingData = (Integer)jdbcTemplate.queryForObject("SELECT COUNT(0) FROM QRTZ_SCHEDULER_STATE", Integer.class) >= 0;
        }
        catch (BadSqlGrammarException e) {
            LOG.debug("Could not access to table QRTZ_SCHEDULER_STATE", (Throwable)e);
            existingData = false;
        }
        if (existingData) {
            LOG.info("Quartz tables found in the database, leaving untouched");
        } else {
            LOG.info("No Quartz tables found, creating");
            DatabasePopulatorUtils.execute((DatabasePopulator)this.databasePopulator, (DataSource)this.dataSource);
        }
    }
}

