/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class GetEventDefinitionResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String eventDefinitionId;

    public GetEventDefinitionResourceCmd(String eventDefinitionId) {
        if (eventDefinitionId == null || eventDefinitionId.length() < 1) {
            throw new FlowableIllegalArgumentException("The event definition id is mandatory, but '" + eventDefinitionId + "' has been provided.");
        }
        this.eventDefinitionId = eventDefinitionId;
    }

    public InputStream execute(CommandContext commandContext) {
        EventDefinitionEntity eventDefinition = CommandContextUtil.getEventRegistryConfiguration().getDeploymentManager().findDeployedEventDefinitionById(this.eventDefinitionId);
        String deploymentId = eventDefinition.getDeploymentId();
        String resourceName = eventDefinition.getResourceName();
        InputStream eventDefinitionStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return eventDefinitionStream;
    }
}

