/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.pipeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.OutboundEventProcessingPipeline;
import org.flowable.eventregistry.api.OutboundEventSerializer;
import org.flowable.eventregistry.impl.pipeline.DefaultOutboundEventProcessingPipeline;
import org.flowable.eventregistry.impl.serialization.EventPayloadToJsonStringSerializer;
import org.flowable.eventregistry.impl.serialization.EventPayloadToXmlStringSerializer;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;

public class OutboundChannelModelProcessor
implements ChannelModelProcessor {
    protected ObjectMapper objectMapper;

    public OutboundChannelModelProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof OutboundChannelModel;
    }

    public boolean canProcessIfChannelModelAlreadyRegistered(ChannelModel channelModel) {
        return channelModel instanceof OutboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof OutboundChannelModel) {
            this.registerChannelModel((OutboundChannelModel)channelModel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerChannelModel(OutboundChannelModel outboundChannelModel) {
        OutboundEventProcessingPipeline eventProcessingPipeline;
        if (outboundChannelModel.getOutboundEventProcessingPipeline() != null) return;
        if (StringUtils.isNotEmpty((CharSequence)outboundChannelModel.getPipelineDelegateExpression())) {
            eventProcessingPipeline = this.resolveExpression(outboundChannelModel.getPipelineDelegateExpression(), OutboundEventProcessingPipeline.class);
        } else if ("json".equals(outboundChannelModel.getSerializerType())) {
            EventPayloadToJsonStringSerializer eventSerializer = new EventPayloadToJsonStringSerializer();
            eventProcessingPipeline = new DefaultOutboundEventProcessingPipeline(eventSerializer);
        } else if ("xml".equals(outboundChannelModel.getSerializerType())) {
            EventPayloadToXmlStringSerializer eventSerializer = new EventPayloadToXmlStringSerializer();
            eventProcessingPipeline = new DefaultOutboundEventProcessingPipeline(eventSerializer);
        } else {
            if (!"expression".equals(outboundChannelModel.getSerializerType())) return;
            if (!StringUtils.isNotEmpty((CharSequence)outboundChannelModel.getSerializerDelegateExpression())) throw new FlowableException("The channel key " + outboundChannelModel.getKey() + " is using expression deserialization, but pipelineDelegateExpression was not set.");
            OutboundEventSerializer outboundEventSerializer = this.resolveExpression(outboundChannelModel.getSerializerDelegateExpression(), OutboundEventSerializer.class);
            eventProcessingPipeline = new DefaultOutboundEventProcessingPipeline(outboundEventSerializer);
        }
        if (eventProcessingPipeline == null) return;
        outboundChannelModel.setOutboundEventProcessingPipeline((Object)eventProcessingPipeline);
    }

    protected <T> T resolveExpression(String expression, Class<T> type) {
        Object value = CommandContextUtil.getEventRegistryConfiguration().getExpressionManager().createExpression(expression).getValue((VariableContainer)new VariableContainerWrapper(Collections.emptyMap()));
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new FlowableException("expected expression " + expression + " to resolve to " + type + " but it did not. Resolved value is " + value);
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
    }
}

