/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.security.cert.X509Certificate;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.http.credentials.X509Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CredentialsExtractor
implements CredentialsExtractor {
    public static final String CERTIFICATE_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final Logger logger = LoggerFactory.getLogger(X509CredentialsExtractor.class);

    public Optional<Credentials> extract(WebContext context, SessionStore sessionStore) {
        Optional certificates = context.getRequestAttribute(CERTIFICATE_REQUEST_ATTRIBUTE);
        if (certificates.isPresent() && ((X509Certificate[])certificates.get()).length > 0) {
            X509Certificate certificate = ((X509Certificate[])certificates.get())[0];
            logger.debug("X509 certificate: {}", (Object)certificate);
            return Optional.of(new X509Credentials(certificate));
        }
        logger.debug("No X509 certificate in request");
        return Optional.empty();
    }
}

