/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler;

import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerConverter;
import com.googlecode.wicket.kendo.ui.scheduler.ISchedulerListener;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerConverter;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerDataSource;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerEvent;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerModel;
import com.googlecode.wicket.kendo.ui.scheduler.SchedulerModelBehavior;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceList;
import com.googlecode.wicket.kendo.ui.scheduler.resource.ResourceListModel;
import com.googlecode.wicket.kendo.ui.scheduler.views.SchedulerViewType;
import com.googlecode.wicket.kendo.ui.template.KendoTemplateBehavior;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class Scheduler
extends JQueryContainer
implements ISchedulerListener {
    private static final long serialVersionUID = 1L;
    private ISchedulerConverter converter;
    private SchedulerModelBehavior modelBehavior;
    private final ResourceListModel resourceListModel;
    private KendoTemplateBehavior editTemplateBehavior = null;
    private KendoTemplateBehavior eventTemplateBehavior = null;
    protected final Options options;

    public Scheduler(String id) {
        this(id, null, new ResourceListModel(), new Options());
    }

    public Scheduler(String id, Options options) {
        this(id, null, new ResourceListModel(), options);
    }

    public Scheduler(String id, SchedulerModel model) {
        this(id, model, new ResourceListModel(), new Options());
    }

    public Scheduler(String id, SchedulerModel model, Options options) {
        this(id, model, new ResourceListModel(), options);
    }

    public Scheduler(String id, SchedulerModel model, ResourceList resourceList) {
        this(id, model, new ResourceListModel(resourceList), new Options());
    }

    public Scheduler(String id, SchedulerModel model, ResourceList resourceList, Options options) {
        this(id, model, new ResourceListModel(resourceList), options);
    }

    public Scheduler(String id, SchedulerModel model, ResourceListModel resourceListModel) {
        this(id, model, resourceListModel, new Options());
    }

    public Scheduler(String id, SchedulerModel model, ResourceListModel resourceListModel, Options options) {
        super(id, (IModel)model);
        this.resourceListModel = resourceListModel;
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public void add(ResourceList resourceList) {
        this.resourceListModel.add(resourceList);
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoScheduler");
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); $w.refresh(); }", this.widget()));
        this.onRefresh(handler);
    }

    protected SchedulerEvent eventOf(JSONObject object) {
        return this.getConverter().toObject(object, (List)this.getResourceListModel().getObject());
    }

    @Override
    public boolean isEditEnabled() {
        return false;
    }

    public SchedulerModel getModel() {
        return (SchedulerModel)this.getDefaultModel();
    }

    protected CharSequence getCallbackUrl() {
        return this.modelBehavior.getCallbackUrl();
    }

    public String getEditTemplateToken() {
        if (this.editTemplateBehavior != null) {
            return this.editTemplateBehavior.getToken();
        }
        return null;
    }

    public String getEventTemplateToken() {
        if (this.eventTemplateBehavior != null) {
            return this.eventTemplateBehavior.getToken();
        }
        return null;
    }

    protected ZoneOffset getZoneOffset() {
        return ZoneOffset.UTC;
    }

    protected final ISchedulerConverter getConverter() {
        if (this.converter == null) {
            this.converter = this.newConverter(this.getZoneOffset());
        }
        return this.converter;
    }

    public ResourceListModel getResourceListModel() {
        return this.resourceListModel;
    }

    protected GroupOrientation getGroupOrientation() {
        return GroupOrientation.horizontal;
    }

    protected boolean isGroupedByDate() {
        return false;
    }

    protected void onInitialize() {
        IJQueryTemplate eventTemplate;
        super.onInitialize();
        this.modelBehavior = this.newSchedulerModelBehavior(this.getModel(), this.getConverter());
        this.add(new Behavior[]{this.modelBehavior});
        IJQueryTemplate editTemplate = this.newEditTemplate();
        if (editTemplate != null) {
            this.editTemplateBehavior = new KendoTemplateBehavior(editTemplate, "edit-template");
            this.add(new Behavior[]{this.editTemplateBehavior});
        }
        if ((eventTemplate = this.newEventTemplate()) != null) {
            this.eventTemplateBehavior = new KendoTemplateBehavior(eventTemplate, "event-template");
            this.add(new Behavior[]{this.eventTemplateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        behavior.setOption("timezone", (Object)Options.asString((String)"Etc/UTC"));
        List<String> groups = this.resourceListModel.getGroups();
        if (!groups.isEmpty()) {
            Options groupOptions = new Options();
            groupOptions.set("date", (Object)this.isGroupedByDate());
            groupOptions.set("resources", (Object)Options.asString(groups));
            groupOptions.set("orientation", (Object)Options.asString((Object)((Object)this.getGroupOrientation())));
            behavior.setOption("group", (Object)groupOptions);
        }
        if (this.editTemplateBehavior != null) {
            behavior.setOption("editable", (Object)String.format("{ template: jQuery('#%s').html() }", this.getEditTemplateToken()));
        }
        if (this.eventTemplateBehavior != null) {
            behavior.setOption("eventTemplate", (Object)String.format("jQuery('#%s').html()", this.getEventTemplateToken()));
        }
        behavior.setOption("resources", (Object)this.getResourceListModel());
    }

    protected void onConfigure(SchedulerDataSource dataSource) {
    }

    protected void onRefresh(IPartialPageRequestHandler handler) {
    }

    @Override
    public final void onEdit(AjaxRequestTarget target, JSONObject object, SchedulerViewType view) {
        this.onEdit(target, this.eventOf(object), view);
    }

    public void onEdit(AjaxRequestTarget target, SchedulerEvent event, SchedulerViewType view) {
    }

    @Override
    public void onNavigate(AjaxRequestTarget target, SchedulerViewType oldView, SchedulerViewType newView) {
    }

    @Override
    public void onCreate(AjaxRequestTarget target, JSONObject object) {
        this.onCreate(target, this.eventOf(object));
    }

    public void onCreate(AjaxRequestTarget target, SchedulerEvent event) {
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, JSONObject object) {
        this.onUpdate(target, this.eventOf(object));
    }

    public void onUpdate(AjaxRequestTarget target, SchedulerEvent event) {
    }

    @Override
    public void onDelete(AjaxRequestTarget target, JSONObject object) {
        this.onDelete(target, this.eventOf(object));
    }

    public void onDelete(AjaxRequestTarget target, SchedulerEvent event) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SchedulerBehavior(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getDataSourceUrl() {
                return Scheduler.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(SchedulerDataSource dataSource) {
                Scheduler.this.onConfigure(dataSource);
            }
        };
    }

    protected ISchedulerConverter newConverter(ZoneOffset offset) {
        return new SchedulerConverter(offset);
    }

    protected IJQueryTemplate newEditTemplate() {
        return null;
    }

    protected IJQueryTemplate newEventTemplate() {
        return null;
    }

    protected SchedulerModelBehavior newSchedulerModelBehavior(SchedulerModel model, ISchedulerConverter converter) {
        return new SchedulerModelBehavior(model, converter);
    }

    protected static enum GroupOrientation {
        horizontal,
        vertical;

    }
}

