/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LogicInvocationHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(LogicInvocationHandler.class);
    protected final NotificationManager notificationManager;
    protected final AuditManager auditManager;

    public LogicInvocationHandler(NotificationManager notificationManager, AuditManager auditManager) {
        this.notificationManager = notificationManager;
        this.auditManager = auditManager;
    }

    @Around(value="execution(* org.apache.syncope.core.logic.AbstractLogic+.*(..))")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> clazz = joinPoint.getTarget().getClass();
        Object[] input = joinPoint.getArgs();
        String category = clazz.getSimpleName();
        MethodSignature ms = (MethodSignature)joinPoint.getSignature();
        Method method = ms.getMethod();
        String event = joinPoint.getSignature().getName();
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.LOGIC, category, null, event);
        boolean auditRequested = this.auditManager.auditRequested(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.LOGIC, category, null, event);
        AuditElements.Result condition = null;
        Object output = null;
        Object before = null;
        try {
            LOG.debug("Before {}.{}({})", new Object[]{clazz.getSimpleName(), event, input == null || input.length == 0 ? "" : input});
            if (notificationsAvailable || auditRequested) {
                try {
                    before = ((AbstractLogic)joinPoint.getTarget()).resolveBeanReference(method, input);
                }
                catch (UnresolvedReferenceException ignore) {
                    LOG.debug("Unresolved bean reference ...");
                }
            }
            output = joinPoint.proceed();
            condition = AuditElements.Result.SUCCESS;
            LOG.debug("After returning {}.{}: {}", new Object[]{clazz.getSimpleName(), event, output});
            Object ignore = output;
            return ignore;
        }
        catch (Throwable t) {
            output = t;
            condition = AuditElements.Result.FAILURE;
            LOG.debug("After throwing {}.{}", (Object)clazz.getSimpleName(), (Object)event);
            throw t;
        }
        finally {
            if (notificationsAvailable || auditRequested) {
                AfterHandlingEvent afterHandlingEvent = new AfterHandlingEvent(AuthContextUtils.getWho(), AuditElements.EventCategoryType.LOGIC, category, null, event, condition, before, output, input);
                AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> {
                    try {
                        this.notificationManager.createTasks(afterHandlingEvent);
                        this.auditManager.audit(afterHandlingEvent);
                    }
                    catch (Throwable t) {
                        LOG.error("While managing Audit and Notifications", t);
                    }
                    return null;
                });
            }
        }
    }
}

