/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

class MultiParentNode<T> {
    private final T object;
    private final Set<MultiParentNode<T>> children = new HashSet<MultiParentNode<T>>();
    private int level;
    private boolean exploited = false;

    MultiParentNode(T object) {
        this.object = object;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    boolean isExploited() {
        return this.exploited;
    }

    void setExploited(boolean exploited) {
        this.exploited = exploited;
    }

    public T getObject() {
        return this.object;
    }

    public boolean isParent(MultiParentNode<T> child) {
        return this.children.contains(child);
    }

    public boolean isChild(MultiParentNode<T> parent) {
        return parent.isParent(this);
    }

    public Set<MultiParentNode<T>> getChildren() {
        return this.children;
    }

    public void addParent(MultiParentNode<T> parent) {
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public void removeParent(MultiParentNode<T> parent) {
        if (parent != null) {
            parent.children.remove(this);
        }
    }

    public void addChild(MultiParentNode<T> child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public void removeChild(MultiParentNode<T> child) {
        if (child != null) {
            this.children.remove(child);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.object).append(this.children).append(this.level).append(this.exploited).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiParentNode other = (MultiParentNode)obj;
        return new EqualsBuilder().append(this.object, other.object).append(this.children, other.children).append(this.level, other.level).append(this.exploited, other.exploited).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.object).append(this.children).append(this.level).append(this.exploited).build();
    }
}

