/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.transaction.annotation.Transactional;

public class JPAImplementationDAO
extends AbstractDAO<Implementation>
implements ImplementationDAO {
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityCacheDAO entityCacheDAO;

    public JPAImplementationDAO(ExternalResourceDAO resourceDAO, EntityCacheDAO entityCacheDAO) {
        this.resourceDAO = resourceDAO;
        this.entityCacheDAO = entityCacheDAO;
    }

    @Transactional(readOnly=true)
    public Implementation find(String key) {
        return (Implementation)this.entityManager().find(JPAImplementation.class, (Object)key);
    }

    public List<Implementation> findByType(String type) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAImplementation.class.getSimpleName() + " e WHERE e.type=:type ORDER BY e.id ASC", Implementation.class);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public List<Implementation> findByTypeAndKeyword(String type, String keyword) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return this.findByType(type);
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAImplementation.class.getSimpleName() + " e WHERE e.type=:type AND e.id LIKE :keyword ORDER BY e.id ASC", Implementation.class);
        query.setParameter("type", (Object)type);
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }

    public List<Implementation> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAImplementation.class.getSimpleName() + " e", Implementation.class);
        return query.getResultList();
    }

    public Implementation save(Implementation implementation) {
        Implementation merged = (Implementation)this.entityManager().merge((Object)implementation);
        ImplementationManager.purge((String)merged.getKey());
        this.resourceDAO.findByProvisionSorter(merged).forEach(resource -> this.entityCacheDAO.evict(JPAExternalResource.class, resource.getKey()));
        return merged;
    }

    public void delete(String key) {
        Implementation implementation = this.find(key);
        if (implementation == null) {
            return;
        }
        this.entityManager().remove((Object)implementation);
        ImplementationManager.purge((String)key);
    }
}

