/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPropagationPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPullPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushPolicy;
import org.apache.syncope.core.persistence.jpa.validation.entity.ExternalResourceCheck;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="ExternalResource")
@ExternalResourceCheck
@Cacheable
public class JPAExternalResource
extends AbstractProvidedKeyEntity
implements ExternalResource,
PersistenceCapable {
    private static final long serialVersionUID = -6937712883512073278L;
    public static final String TABLE = "ExternalResource";
    protected static final TypeReference<Set<ConnectorCapability>> CAPABILITY_TYPEREF = new TypeReference<Set<ConnectorCapability>>(){};
    protected static final TypeReference<List<Provision>> PROVISION_TYPEREF = new TypeReference<List<Provision>>(){};
    @NotNull
    private Boolean enforceMandatoryCondition = false;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE})
    private JPAConnInstance connector;
    private Integer propagationPriority;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private TraceLevel createTraceLevel = TraceLevel.FAILURES;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private TraceLevel updateTraceLevel = TraceLevel.FAILURES;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private TraceLevel deleteTraceLevel = TraceLevel.FAILURES;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private TraceLevel provisioningTraceLevel = TraceLevel.FAILURES;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAPasswordPolicy passwordPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAAccountPolicy accountPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAPropagationPolicy propagationPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAPullPolicy pullPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAPushPolicy pushPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAImplementation provisionSorter;
    @Lob
    private String jsonConf;
    @NotNull
    private Boolean overrideCapabilities = false;
    @Lob
    private String capabilitiesOverride;
    @Transient
    private final Set<ConnectorCapability> capabilitiesOverrideSet = new HashSet<ConnectorCapability>();
    @Lob
    private String provisions;
    @Transient
    private final List<Provision> provisionList = new ArrayList<Provision>();
    @Lob
    private String orgUnit;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ExternalResourcePropAction", joinColumns={@JoinColumn(name="resource_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"resource_id", "implementation_id"})})
    private List<JPAImplementation> propagationActions = new ArrayList<JPAImplementation>();
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance;
    static /* synthetic */ Class class$Lorg$apache$syncope$common$lib$types$TraceLevel;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPropagationPolicy;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAImplementation;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPullPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPushPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource;

    public boolean isEnforceMandatoryCondition() {
        return JPAExternalResource.pcGetenforceMandatoryCondition(this);
    }

    public void setEnforceMandatoryCondition(boolean enforceMandatoryCondition) {
        JPAExternalResource.pcSetenforceMandatoryCondition(this, enforceMandatoryCondition);
    }

    public ConnInstance getConnector() {
        return JPAExternalResource.pcGetconnector(this);
    }

    public void setConnector(ConnInstance connector) {
        this.checkType(connector, JPAConnInstance.class);
        JPAExternalResource.pcSetconnector(this, (JPAConnInstance)connector);
    }

    public Optional<Provision> getProvisionByAnyType(String anyType) {
        return this.getProvisions().stream().filter(provision -> provision.getAnyType().equals(anyType)).findFirst();
    }

    public Optional<Provision> getProvisionByObjectClass(String objectClass) {
        return this.getProvisions().stream().filter(provision -> provision.getObjectClass().equals(objectClass)).findFirst();
    }

    public List<Provision> getProvisions() {
        return this.provisionList;
    }

    public OrgUnit getOrgUnit() {
        return Optional.ofNullable(JPAExternalResource.pcGetorgUnit(this)).map(ou -> (OrgUnit)POJOHelper.deserialize((String)ou, OrgUnit.class)).orElse(null);
    }

    public void setOrgUnit(OrgUnit orgUnit) {
        JPAExternalResource.pcSetorgUnit(this, orgUnit == null ? null : POJOHelper.serialize((Object)orgUnit));
    }

    public Integer getPropagationPriority() {
        return JPAExternalResource.pcGetpropagationPriority(this);
    }

    public void setPropagationPriority(Integer propagationPriority) {
        JPAExternalResource.pcSetpropagationPriority(this, propagationPriority);
    }

    public TraceLevel getCreateTraceLevel() {
        return JPAExternalResource.pcGetcreateTraceLevel(this);
    }

    public void setCreateTraceLevel(TraceLevel createTraceLevel) {
        JPAExternalResource.pcSetcreateTraceLevel(this, createTraceLevel);
    }

    public TraceLevel getDeleteTraceLevel() {
        return JPAExternalResource.pcGetdeleteTraceLevel(this);
    }

    public void setDeleteTraceLevel(TraceLevel deleteTraceLevel) {
        JPAExternalResource.pcSetdeleteTraceLevel(this, deleteTraceLevel);
    }

    public TraceLevel getUpdateTraceLevel() {
        return JPAExternalResource.pcGetupdateTraceLevel(this);
    }

    public void setUpdateTraceLevel(TraceLevel updateTraceLevel) {
        JPAExternalResource.pcSetupdateTraceLevel(this, updateTraceLevel);
    }

    public TraceLevel getProvisioningTraceLevel() {
        return JPAExternalResource.pcGetprovisioningTraceLevel(this);
    }

    public void setProvisioningTraceLevel(TraceLevel provisioningTraceLevel) {
        JPAExternalResource.pcSetprovisioningTraceLevel(this, provisioningTraceLevel);
    }

    public AccountPolicy getAccountPolicy() {
        return JPAExternalResource.pcGetaccountPolicy(this);
    }

    public void setAccountPolicy(AccountPolicy accountPolicy) {
        this.checkType(accountPolicy, JPAAccountPolicy.class);
        JPAExternalResource.pcSetaccountPolicy(this, (JPAAccountPolicy)accountPolicy);
    }

    public PasswordPolicy getPasswordPolicy() {
        return JPAExternalResource.pcGetpasswordPolicy(this);
    }

    public void setPasswordPolicy(PasswordPolicy passwordPolicy) {
        this.checkType(passwordPolicy, JPAPasswordPolicy.class);
        JPAExternalResource.pcSetpasswordPolicy(this, (JPAPasswordPolicy)passwordPolicy);
    }

    public PropagationPolicy getPropagationPolicy() {
        return JPAExternalResource.pcGetpropagationPolicy(this);
    }

    public void setPropagationPolicy(PropagationPolicy propagationPolicy) {
        this.checkType(propagationPolicy, JPAPropagationPolicy.class);
        JPAExternalResource.pcSetpropagationPolicy(this, (JPAPropagationPolicy)propagationPolicy);
    }

    public PullPolicy getPullPolicy() {
        return JPAExternalResource.pcGetpullPolicy(this);
    }

    public void setPullPolicy(PullPolicy pullPolicy) {
        this.checkType(pullPolicy, JPAPullPolicy.class);
        JPAExternalResource.pcSetpullPolicy(this, (JPAPullPolicy)pullPolicy);
    }

    public PushPolicy getPushPolicy() {
        return JPAExternalResource.pcGetpushPolicy(this);
    }

    public void setPushPolicy(PushPolicy pushPolicy) {
        this.checkType(pushPolicy, JPAPushPolicy.class);
        JPAExternalResource.pcSetpushPolicy(this, (JPAPushPolicy)pushPolicy);
    }

    public Implementation getProvisionSorter() {
        return JPAExternalResource.pcGetprovisionSorter(this);
    }

    public void setProvisionSorter(Implementation provisionSorter) {
        this.checkType(provisionSorter, JPAImplementation.class);
        this.checkImplementationType(provisionSorter, "PROVISION_SORTER");
        JPAExternalResource.pcSetprovisionSorter(this, (JPAImplementation)provisionSorter);
    }

    public Set<ConnConfProperty> getConfOverride() {
        HashSet<ConnConfProperty> confOverride = new HashSet<ConnConfProperty>();
        if (!StringUtils.isBlank((CharSequence)JPAExternalResource.pcGetjsonConf(this))) {
            confOverride.addAll(List.of((ConnConfProperty[])POJOHelper.deserialize((String)JPAExternalResource.pcGetjsonConf(this), ConnConfProperty[].class)));
        }
        return confOverride;
    }

    public void setConfOverride(Set<ConnConfProperty> confOverride) {
        JPAExternalResource.pcSetjsonConf(this, POJOHelper.serialize(new HashSet<ConnConfProperty>(confOverride)));
    }

    public boolean isOverrideCapabilities() {
        return JPAExternalResource.pcGetoverrideCapabilities(this);
    }

    public void setOverrideCapabilities(boolean overrideCapabilities) {
        JPAExternalResource.pcSetoverrideCapabilities(this, overrideCapabilities);
    }

    public Set<ConnectorCapability> getCapabilitiesOverride() {
        return this.capabilitiesOverrideSet;
    }

    public boolean add(Implementation propagationAction) {
        this.checkType(propagationAction, JPAImplementation.class);
        this.checkImplementationType(propagationAction, "PROPAGATION_ACTIONS");
        return JPAExternalResource.pcGetpropagationActions(this).contains((JPAImplementation)propagationAction) || JPAExternalResource.pcGetpropagationActions(this).add((JPAImplementation)propagationAction);
    }

    public List<? extends Implementation> getPropagationActions() {
        return JPAExternalResource.pcGetpropagationActions(this);
    }

    protected void json2list(boolean clearFirst) {
        if (clearFirst) {
            this.getCapabilitiesOverride().clear();
            this.getProvisions().clear();
        }
        if (JPAExternalResource.pcGetcapabilitiesOverride(this) != null) {
            this.getCapabilitiesOverride().addAll((Collection)POJOHelper.deserialize((String)JPAExternalResource.pcGetcapabilitiesOverride(this), CAPABILITY_TYPEREF));
        }
        if (JPAExternalResource.pcGetprovisions(this) != null) {
            this.getProvisions().addAll((Collection)POJOHelper.deserialize((String)JPAExternalResource.pcGetprovisions(this), PROVISION_TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2list(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2list(true);
    }

    @PrePersist
    @PreUpdate
    public void list2json() {
        JPAExternalResource.pcSetcapabilitiesOverride(this, POJOHelper.serialize(this.getCapabilitiesOverride()));
        JPAExternalResource.pcSetprovisions(this, POJOHelper.serialize(this.getProvisions()));
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"accountPolicy", "capabilitiesOverride", "connector", "createTraceLevel", "deleteTraceLevel", "enforceMandatoryCondition", "jsonConf", "orgUnit", "overrideCapabilities", "passwordPolicy", "propagationActions", "propagationPolicy", "propagationPriority", "provisionSorter", "provisioningTraceLevel", "provisions", "pullPolicy", "pushPolicy", "updateTraceLevel"};
        Class[] classArray = new Class[19];
        Class clazz2 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAExternalResource.class$("java.lang.String"));
        classArray[1] = clazz3;
        Class clazz4 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance"));
        classArray[2] = clazz4;
        Class clazz5 = class$Lorg$apache$syncope$common$lib$types$TraceLevel != null ? class$Lorg$apache$syncope$common$lib$types$TraceLevel : (class$Lorg$apache$syncope$common$lib$types$TraceLevel = JPAExternalResource.class$("org.apache.syncope.common.lib.types.TraceLevel"));
        classArray[3] = clazz5;
        classArray[4] = class$Lorg$apache$syncope$common$lib$types$TraceLevel != null ? class$Lorg$apache$syncope$common$lib$types$TraceLevel : (class$Lorg$apache$syncope$common$lib$types$TraceLevel = JPAExternalResource.class$("org.apache.syncope.common.lib.types.TraceLevel"));
        Class clazz6 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPAExternalResource.class$("java.lang.Boolean"));
        classArray[5] = clazz6;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAExternalResource.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAExternalResource.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPAExternalResource.class$("java.lang.Boolean"));
        Class clazz7 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy"));
        classArray[9] = clazz7;
        Class clazz8 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAExternalResource.class$("java.util.List"));
        classArray[10] = clazz8;
        Class clazz9 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPropagationPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPropagationPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPropagationPolicy = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAPropagationPolicy"));
        classArray[11] = clazz9;
        Class clazz10 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = JPAExternalResource.class$("java.lang.Integer"));
        classArray[12] = clazz10;
        Class clazz11 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAImplementation != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAImplementation : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAImplementation = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.JPAImplementation"));
        classArray[13] = clazz11;
        classArray[14] = class$Lorg$apache$syncope$common$lib$types$TraceLevel != null ? class$Lorg$apache$syncope$common$lib$types$TraceLevel : (class$Lorg$apache$syncope$common$lib$types$TraceLevel = JPAExternalResource.class$("org.apache.syncope.common.lib.types.TraceLevel"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAExternalResource.class$("java.lang.String"));
        Class clazz12 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPullPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPullPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPullPolicy = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAPullPolicy"));
        classArray[16] = clazz12;
        Class clazz13 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPushPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPushPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPushPolicy = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushPolicy"));
        classArray[17] = clazz13;
        classArray[18] = class$Lorg$apache$syncope$common$lib$types$TraceLevel != null ? class$Lorg$apache$syncope$common$lib$types$TraceLevel : (class$Lorg$apache$syncope$common$lib$types$TraceLevel = JPAExternalResource.class$("org.apache.syncope.common.lib.types.TraceLevel"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz14 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource"));
        PCRegistry.register((Class)clazz14, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAExternalResource", (PersistenceCapable)new JPAExternalResource());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.accountPolicy = null;
        this.capabilitiesOverride = null;
        this.connector = null;
        this.createTraceLevel = null;
        this.deleteTraceLevel = null;
        this.enforceMandatoryCondition = null;
        this.jsonConf = null;
        this.orgUnit = null;
        this.overrideCapabilities = null;
        this.passwordPolicy = null;
        this.propagationActions = null;
        this.propagationPolicy = null;
        this.propagationPriority = null;
        this.provisionSorter = null;
        this.provisioningTraceLevel = null;
        this.provisions = null;
        this.pullPolicy = null;
        this.pushPolicy = null;
        this.updateTraceLevel = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAExternalResource jPAExternalResource = new JPAExternalResource();
        if (bl) {
            jPAExternalResource.pcClearFields();
        }
        jPAExternalResource.pcStateManager = stateManager;
        jPAExternalResource.pcCopyKeyFieldsFromObjectId(object);
        return jPAExternalResource;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAExternalResource jPAExternalResource = new JPAExternalResource();
        if (bl) {
            jPAExternalResource.pcClearFields();
        }
        jPAExternalResource.pcStateManager = stateManager;
        return jPAExternalResource;
    }

    protected static int pcGetManagedFieldCount() {
        return 19 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accountPolicy = (JPAAccountPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.capabilitiesOverride = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.connector = (JPAConnInstance)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.createTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.deleteTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.enforceMandatoryCondition = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.jsonConf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.orgUnit = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.overrideCapabilities = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.passwordPolicy = (JPAPasswordPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.propagationActions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.propagationPolicy = (JPAPropagationPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.propagationPriority = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.provisionSorter = (JPAImplementation)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.provisioningTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.provisions = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.pullPolicy = (JPAPullPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.pushPolicy = (JPAPushPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.updateTraceLevel = (TraceLevel)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountPolicy);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.capabilitiesOverride);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.connector);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createTraceLevel);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.deleteTraceLevel);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.enforceMandatoryCondition);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jsonConf);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.orgUnit);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.overrideCapabilities);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.passwordPolicy);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.propagationActions);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagationPolicy);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagationPriority);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.provisionSorter);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.provisioningTraceLevel);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.provisions);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pullPolicy);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pushPolicy);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updateTraceLevel);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAExternalResource jPAExternalResource, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAExternalResource, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accountPolicy = jPAExternalResource.accountPolicy;
                return;
            }
            case 1: {
                this.capabilitiesOverride = jPAExternalResource.capabilitiesOverride;
                return;
            }
            case 2: {
                this.connector = jPAExternalResource.connector;
                return;
            }
            case 3: {
                this.createTraceLevel = jPAExternalResource.createTraceLevel;
                return;
            }
            case 4: {
                this.deleteTraceLevel = jPAExternalResource.deleteTraceLevel;
                return;
            }
            case 5: {
                this.enforceMandatoryCondition = jPAExternalResource.enforceMandatoryCondition;
                return;
            }
            case 6: {
                this.jsonConf = jPAExternalResource.jsonConf;
                return;
            }
            case 7: {
                this.orgUnit = jPAExternalResource.orgUnit;
                return;
            }
            case 8: {
                this.overrideCapabilities = jPAExternalResource.overrideCapabilities;
                return;
            }
            case 9: {
                this.passwordPolicy = jPAExternalResource.passwordPolicy;
                return;
            }
            case 10: {
                this.propagationActions = jPAExternalResource.propagationActions;
                return;
            }
            case 11: {
                this.propagationPolicy = jPAExternalResource.propagationPolicy;
                return;
            }
            case 12: {
                this.propagationPriority = jPAExternalResource.propagationPriority;
                return;
            }
            case 13: {
                this.provisionSorter = jPAExternalResource.provisionSorter;
                return;
            }
            case 14: {
                this.provisioningTraceLevel = jPAExternalResource.provisioningTraceLevel;
                return;
            }
            case 15: {
                this.provisions = jPAExternalResource.provisions;
                return;
            }
            case 16: {
                this.pullPolicy = jPAExternalResource.pullPolicy;
                return;
            }
            case 17: {
                this.pushPolicy = jPAExternalResource.pushPolicy;
                return;
            }
            case 18: {
                this.updateTraceLevel = jPAExternalResource.updateTraceLevel;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAExternalResource jPAExternalResource = (JPAExternalResource)object;
        if (jPAExternalResource.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAExternalResource, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAExternalResource = JPAExternalResource.class$("org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource"));
        return clazz;
    }

    private static final JPAAccountPolicy pcGetaccountPolicy(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.accountPolicy;
        }
        int n = pcInheritedFieldCount + 0;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.accountPolicy;
    }

    private static final void pcSetaccountPolicy(JPAExternalResource jPAExternalResource, JPAAccountPolicy jPAAccountPolicy) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.accountPolicy = jPAAccountPolicy;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 0, (Object)jPAExternalResource.accountPolicy, (Object)jPAAccountPolicy, 0);
    }

    private static final String pcGetcapabilitiesOverride(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.capabilitiesOverride;
        }
        int n = pcInheritedFieldCount + 1;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.capabilitiesOverride;
    }

    private static final void pcSetcapabilitiesOverride(JPAExternalResource jPAExternalResource, String string) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.capabilitiesOverride = string;
            return;
        }
        jPAExternalResource.pcStateManager.settingStringField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 1, jPAExternalResource.capabilitiesOverride, string, 0);
    }

    private static final JPAConnInstance pcGetconnector(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.connector;
        }
        int n = pcInheritedFieldCount + 2;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.connector;
    }

    private static final void pcSetconnector(JPAExternalResource jPAExternalResource, JPAConnInstance jPAConnInstance) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.connector = jPAConnInstance;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 2, (Object)jPAExternalResource.connector, (Object)jPAConnInstance, 0);
    }

    private static final TraceLevel pcGetcreateTraceLevel(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.createTraceLevel;
        }
        int n = pcInheritedFieldCount + 3;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.createTraceLevel;
    }

    private static final void pcSetcreateTraceLevel(JPAExternalResource jPAExternalResource, TraceLevel traceLevel) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.createTraceLevel = traceLevel;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 3, (Object)jPAExternalResource.createTraceLevel, (Object)traceLevel, 0);
    }

    private static final TraceLevel pcGetdeleteTraceLevel(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.deleteTraceLevel;
        }
        int n = pcInheritedFieldCount + 4;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.deleteTraceLevel;
    }

    private static final void pcSetdeleteTraceLevel(JPAExternalResource jPAExternalResource, TraceLevel traceLevel) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.deleteTraceLevel = traceLevel;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 4, (Object)jPAExternalResource.deleteTraceLevel, (Object)traceLevel, 0);
    }

    private static final Boolean pcGetenforceMandatoryCondition(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.enforceMandatoryCondition;
        }
        int n = pcInheritedFieldCount + 5;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.enforceMandatoryCondition;
    }

    private static final void pcSetenforceMandatoryCondition(JPAExternalResource jPAExternalResource, Boolean bl) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.enforceMandatoryCondition = bl;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 5, (Object)jPAExternalResource.enforceMandatoryCondition, (Object)bl, 0);
    }

    private static final String pcGetjsonConf(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.jsonConf;
        }
        int n = pcInheritedFieldCount + 6;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.jsonConf;
    }

    private static final void pcSetjsonConf(JPAExternalResource jPAExternalResource, String string) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.jsonConf = string;
            return;
        }
        jPAExternalResource.pcStateManager.settingStringField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 6, jPAExternalResource.jsonConf, string, 0);
    }

    private static final String pcGetorgUnit(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.orgUnit;
        }
        int n = pcInheritedFieldCount + 7;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.orgUnit;
    }

    private static final void pcSetorgUnit(JPAExternalResource jPAExternalResource, String string) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.orgUnit = string;
            return;
        }
        jPAExternalResource.pcStateManager.settingStringField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 7, jPAExternalResource.orgUnit, string, 0);
    }

    private static final Boolean pcGetoverrideCapabilities(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.overrideCapabilities;
        }
        int n = pcInheritedFieldCount + 8;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.overrideCapabilities;
    }

    private static final void pcSetoverrideCapabilities(JPAExternalResource jPAExternalResource, Boolean bl) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.overrideCapabilities = bl;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 8, (Object)jPAExternalResource.overrideCapabilities, (Object)bl, 0);
    }

    private static final JPAPasswordPolicy pcGetpasswordPolicy(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.passwordPolicy;
        }
        int n = pcInheritedFieldCount + 9;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.passwordPolicy;
    }

    private static final void pcSetpasswordPolicy(JPAExternalResource jPAExternalResource, JPAPasswordPolicy jPAPasswordPolicy) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.passwordPolicy = jPAPasswordPolicy;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 9, (Object)jPAExternalResource.passwordPolicy, (Object)jPAPasswordPolicy, 0);
    }

    private static final List pcGetpropagationActions(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.propagationActions;
        }
        int n = pcInheritedFieldCount + 10;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.propagationActions;
    }

    private static final void pcSetpropagationActions(JPAExternalResource jPAExternalResource, List list) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.propagationActions = list;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 10, jPAExternalResource.propagationActions, (Object)list, 0);
    }

    private static final JPAPropagationPolicy pcGetpropagationPolicy(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.propagationPolicy;
        }
        int n = pcInheritedFieldCount + 11;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.propagationPolicy;
    }

    private static final void pcSetpropagationPolicy(JPAExternalResource jPAExternalResource, JPAPropagationPolicy jPAPropagationPolicy) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.propagationPolicy = jPAPropagationPolicy;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 11, (Object)jPAExternalResource.propagationPolicy, (Object)jPAPropagationPolicy, 0);
    }

    private static final Integer pcGetpropagationPriority(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.propagationPriority;
        }
        int n = pcInheritedFieldCount + 12;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.propagationPriority;
    }

    private static final void pcSetpropagationPriority(JPAExternalResource jPAExternalResource, Integer n) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.propagationPriority = n;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 12, (Object)jPAExternalResource.propagationPriority, (Object)n, 0);
    }

    private static final JPAImplementation pcGetprovisionSorter(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.provisionSorter;
        }
        int n = pcInheritedFieldCount + 13;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.provisionSorter;
    }

    private static final void pcSetprovisionSorter(JPAExternalResource jPAExternalResource, JPAImplementation jPAImplementation) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.provisionSorter = jPAImplementation;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 13, (Object)jPAExternalResource.provisionSorter, (Object)jPAImplementation, 0);
    }

    private static final TraceLevel pcGetprovisioningTraceLevel(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.provisioningTraceLevel;
        }
        int n = pcInheritedFieldCount + 14;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.provisioningTraceLevel;
    }

    private static final void pcSetprovisioningTraceLevel(JPAExternalResource jPAExternalResource, TraceLevel traceLevel) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.provisioningTraceLevel = traceLevel;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 14, (Object)jPAExternalResource.provisioningTraceLevel, (Object)traceLevel, 0);
    }

    private static final String pcGetprovisions(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.provisions;
        }
        int n = pcInheritedFieldCount + 15;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.provisions;
    }

    private static final void pcSetprovisions(JPAExternalResource jPAExternalResource, String string) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.provisions = string;
            return;
        }
        jPAExternalResource.pcStateManager.settingStringField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 15, jPAExternalResource.provisions, string, 0);
    }

    private static final JPAPullPolicy pcGetpullPolicy(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.pullPolicy;
        }
        int n = pcInheritedFieldCount + 16;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.pullPolicy;
    }

    private static final void pcSetpullPolicy(JPAExternalResource jPAExternalResource, JPAPullPolicy jPAPullPolicy) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.pullPolicy = jPAPullPolicy;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 16, (Object)jPAExternalResource.pullPolicy, (Object)jPAPullPolicy, 0);
    }

    private static final JPAPushPolicy pcGetpushPolicy(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.pushPolicy;
        }
        int n = pcInheritedFieldCount + 17;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.pushPolicy;
    }

    private static final void pcSetpushPolicy(JPAExternalResource jPAExternalResource, JPAPushPolicy jPAPushPolicy) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.pushPolicy = jPAPushPolicy;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 17, (Object)jPAExternalResource.pushPolicy, (Object)jPAPushPolicy, 0);
    }

    private static final TraceLevel pcGetupdateTraceLevel(JPAExternalResource jPAExternalResource) {
        if (jPAExternalResource.pcStateManager == null) {
            return jPAExternalResource.updateTraceLevel;
        }
        int n = pcInheritedFieldCount + 18;
        jPAExternalResource.pcStateManager.accessingField(n);
        return jPAExternalResource.updateTraceLevel;
    }

    private static final void pcSetupdateTraceLevel(JPAExternalResource jPAExternalResource, TraceLevel traceLevel) {
        if (jPAExternalResource.pcStateManager == null) {
            jPAExternalResource.updateTraceLevel = traceLevel;
            return;
        }
        jPAExternalResource.pcStateManager.settingObjectField((PersistenceCapable)jPAExternalResource, pcInheritedFieldCount + 18, (Object)jPAExternalResource.updateTraceLevel, (Object)traceLevel, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

