/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20ConsentApprovalViewResolver
implements ConsentApprovalViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ConsentApprovalViewResolver.class);
    protected final CasConfigurationProperties casProperties;
    protected final SessionStore sessionStore;

    @Override
    public ModelAndView resolve(WebContext context, OAuthRegisteredService service) throws Exception {
        String bypassApprovalParameter = context.getRequestParameter("bypass_approval_prompt").map(String::valueOf).orElse("");
        if (StringUtils.isBlank((CharSequence)bypassApprovalParameter)) {
            bypassApprovalParameter = this.sessionStore.get(context, "bypass_approval_prompt").map(String::valueOf).orElse("");
        }
        LOGGER.trace("Bypassing approval prompt for service [{}]: [{}]", (Object)service, (Object)bypassApprovalParameter);
        if (Boolean.TRUE.toString().equalsIgnoreCase(bypassApprovalParameter) || this.isConsentApprovalBypassed(context, service)) {
            this.sessionStore.set(context, "bypass_approval_prompt", (Object)Boolean.TRUE.toString());
            return new ModelAndView();
        }
        return this.redirectToApproveView(context, service);
    }

    protected boolean isConsentApprovalBypassed(WebContext context, OAuthRegisteredService service) {
        return service.isBypassApprovalPrompt() || this.casProperties.getAuthn().getOauth().getCore().isBypassApprovalPrompt();
    }

    protected ModelAndView redirectToApproveView(WebContext ctx, OAuthRegisteredService svc) throws Exception {
        String callbackUrl = ctx.getFullRequestURL();
        LOGGER.trace("callbackUrl: [{}]", (Object)callbackUrl);
        URIBuilder url = new URIBuilder(callbackUrl);
        url.addParameter("bypass_approval_prompt", Boolean.TRUE.toString());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("service", svc);
        model.put("callbackUrl", url.toString());
        model.put("serviceName", svc.getName());
        model.put("deniedApprovalUrl", svc.getAccessStrategy().getUnauthorizedRedirectUrl());
        this.prepareApprovalViewModel(model, ctx, svc);
        return this.getApprovalModelAndView(model);
    }

    protected ModelAndView getApprovalModelAndView(Map<String, Object> model) {
        return new ModelAndView(this.getApprovalViewName(), model);
    }

    protected String getApprovalViewName() {
        return "oauthConfirmView";
    }

    protected void prepareApprovalViewModel(Map<String, Object> model, WebContext ctx, OAuthRegisteredService svc) throws Exception {
    }

    @Generated
    public OAuth20ConsentApprovalViewResolver(CasConfigurationProperties casProperties, SessionStore sessionStore) {
        this.casProperties = casProperties;
        this.sessionStore = sessionStore;
    }
}

