/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCandidateProfile;
import org.apereo.cas.authentication.principal.DelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationFailureEvaluator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnEvaluator;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.actions.AbstractAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationAction
extends AbstractAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationAction.class);
    protected final DelegatedClientAuthenticationConfigurationContext configContext;
    private final DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager;
    private final DelegatedClientAuthenticationFailureEvaluator failureEvaluator;
    private final DelegatedAuthenticationSingleSignOnEvaluator ssoEvaluator;

    public DelegatedClientAuthenticationAction(DelegatedClientAuthenticationConfigurationContext context, DelegatedClientAuthenticationWebflowManager delegatedClientAuthenticationWebflowManager, DelegatedClientAuthenticationFailureEvaluator failureEvaluator) {
        super(context.getInitialAuthenticationAttemptWebflowEventResolver(), context.getServiceTicketRequestWebflowEventResolver(), context.getAdaptiveAuthenticationPolicy());
        this.configContext = context;
        this.failureEvaluator = failureEvaluator;
        this.delegatedClientAuthenticationWebflowManager = delegatedClientAuthenticationWebflowManager;
        this.ssoEvaluator = new DelegatedAuthenticationSingleSignOnEvaluator(context);
    }

    protected static boolean isLogoutRequest(HttpServletRequest request) {
        return request.getParameter("logoutendpoint") != null;
    }

    public Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        JEEContext webContext = new JEEContext(request, response);
        try {
            boolean isSingleSignOnSessionActive;
            String clientName = this.retrieveClientName((WebContext)webContext);
            LOGGER.trace("Delegated authentication is handled by client name [{}]", (Object)clientName);
            Service service = null;
            boolean bl = isSingleSignOnSessionActive = !DelegatedClientAuthenticationAction.isLogoutRequest(request) && !WebUtils.hasDelegatedClientAuthenticationCandidateProfile((RequestContext)context) && this.ssoEvaluator.singleSignOnSessionExists(context) && StringUtils.isNotBlank((CharSequence)clientName);
            if (isSingleSignOnSessionActive) {
                LOGGER.trace("Found an existing single sign-on session");
                service = this.populateContextWithService(context, webContext, clientName);
                if (this.ssoEvaluator.singleSignOnSessionAuthorizedForService(context)) {
                    Set providers = this.configContext.getDelegatedClientIdentityProvidersProducer().produce(context);
                    LOGGER.debug("Skipping delegation and routing back to CAS authentication flow with providers [{}]", (Object)providers);
                    return super.doExecute(context);
                }
                Service resolvedService = this.ssoEvaluator.resolveServiceFromRequestContext(context);
                LOGGER.debug("Single sign-on session in unauthorized for service [{}]", (Object)resolvedService);
                String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)context);
                this.configContext.getTicketRegistry().deleteTicket(tgt);
            }
            if (this.failureEvaluator.evaluate(request, response.getStatus()).isPresent()) {
                throw new IllegalArgumentException("Delegated authentication has failed with client " + clientName);
            }
            if (WebUtils.hasDelegatedClientAuthenticationCandidateProfile((RequestContext)context)) {
                DelegatedAuthenticationCandidateProfile profile = (DelegatedAuthenticationCandidateProfile)WebUtils.getDelegatedClientAuthenticationCandidateProfile((RequestContext)context, DelegatedAuthenticationCandidateProfile.class);
                UserProfile up = profile.toUserProfile(clientName);
                ClientCredential clientCredential = new ClientCredential(clientName, up);
                WebUtils.putCredential((RequestContext)context, (Credential)clientCredential);
                return super.doExecute(context);
            }
            if (StringUtils.isNotBlank((CharSequence)clientName)) {
                service = Optional.ofNullable(service).orElseGet(() -> this.populateContextWithService(context, webContext, clientName));
                BaseClient client = this.findDelegatedClientByName(context, clientName, service);
                WebUtils.putDelegatedAuthenticationClientName((RequestContext)context, (String)client.getName());
                ClientCredential clientCredentials = this.populateContextWithClientCredential(client, webContext, context);
                return this.finalizeDelegatedClientAuthentication(context, clientCredentials);
            }
        }
        catch (HttpAction e) {
            FunctionUtils.doIf((boolean)LOGGER.isDebugEnabled(), o -> LOGGER.debug(e.getMessage(), (Throwable)e), o -> LOGGER.info(e.getMessage())).accept(e);
            JEEHttpActionAdapter.INSTANCE.adapt(e, (WebContext)webContext);
            return DelegatedClientAuthenticationAction.isLogoutRequest(request) ? this.getFinalEvent() : this.success();
        }
        catch (UnauthorizedServiceException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.stopWebflow(e, context);
        }
        return this.getFinalEvent();
    }

    protected Event finalizeDelegatedClientAuthentication(RequestContext context, ClientCredential credentials) {
        ArrayList strategies = new ArrayList(this.configContext.getApplicationContext().getBeansOfType(DelegatedClientAuthenticationCredentialResolver.class).values());
        AnnotationAwareOrderComparator.sortIfNecessary(strategies);
        List candidateMatches = strategies.stream().filter(BeanSupplier::isNotProxy).filter(strategy -> strategy.supports(credentials)).map(strategy -> strategy.resolve(context, credentials)).flatMap(Collection::stream).collect(Collectors.toList());
        if (candidateMatches.isEmpty()) {
            return super.doExecute(context);
        }
        WebUtils.putDelegatedClientAuthenticationResolvedCredentials((RequestContext)context, candidateMatches);
        return new Event((Object)this, "select");
    }

    private Event getFinalEvent() {
        return new Event((Object)this, "generate");
    }

    protected String retrieveClientName(WebContext webContext) {
        return this.configContext.getDelegatedClientNameExtractor().extract(webContext).orElse("");
    }

    protected Event doPreExecute(RequestContext context) throws Exception {
        SessionReplicationProperties replicationProps = this.configContext.getCasProperties().getAuthn().getPac4j().getCore().getSessionReplication();
        if (replicationProps.isReplicateSessions() && replicationProps.getCookie().isAutoConfigureCookiePath()) {
            String contextPath = context.getExternalContext().getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            String path = this.configContext.getDelegatedClientDistributedSessionCookieGenerator().getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for distributed session cookie generator to: [{}]", cookiePath);
                this.configContext.getDelegatedClientDistributedSessionCookieGenerator().setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("Delegated authentication cookie domain is [{}] with path [{}]", (Object)this.configContext.getDelegatedClientDistributedSessionCookieGenerator().getCookieDomain(), (Object)path);
            }
        }
        return super.doPreExecute(context);
    }

    protected Service populateContextWithService(RequestContext context, JEEContext webContext, String clientName) {
        Service service = this.restoreAuthenticationRequestInContext(context, webContext, clientName);
        Service resolvedService = this.configContext.getAuthenticationRequestServiceSelectionStrategies().resolveService(service);
        LOGGER.trace("Authentication is resolved by service request from [{}]", (Object)service);
        RegisteredService registeredService = this.configContext.getServicesManager().findServiceBy(resolvedService);
        LOGGER.trace("Located registered service [{}] mapped to resolved service [{}]", (Object)registeredService, (Object)resolvedService);
        WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
        return service;
    }

    protected ClientCredential populateContextWithClientCredential(BaseClient client, JEEContext webContext, RequestContext requestContext) {
        LOGGER.debug("Fetching credentials from delegated client [{}]", (Object)client);
        Credentials credentials = this.getCredentialsFromDelegatedClient(webContext, client);
        ClientCredential clientCredential = new ClientCredential(credentials, client.getName());
        LOGGER.info("Credentials are successfully authenticated using the delegated client [{}]", (Object)client.getName());
        WebUtils.putCredential((RequestContext)requestContext, (Credential)clientCredential);
        return clientCredential;
    }

    protected Credentials getCredentialsFromDelegatedClient(JEEContext webContext, BaseClient client) {
        Optional credentials = client.getCredentials((WebContext)webContext, this.configContext.getSessionStore());
        LOGGER.debug("Retrieved credentials from client as [{}]", (Object)credentials);
        if (credentials.isEmpty()) {
            throw new IllegalArgumentException("Unable to determine credentials from the context with client " + client.getName());
        }
        return (Credentials)credentials.get();
    }

    protected BaseClient findDelegatedClientByName(RequestContext requestContext, String clientName, Service service) {
        Optional clientResult = this.configContext.getClients().findClient(clientName);
        if (clientResult.isEmpty()) {
            LOGGER.warn("Delegated client [{}] can not be located", (Object)clientName);
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        BaseClient client = (BaseClient)BaseClient.class.cast(clientResult.get());
        LOGGER.debug("Delegated authentication client is [{}] with service [{}]", (Object)client, (Object)service);
        if (service != null) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            request.setAttribute("service", (Object)service);
        }
        if (!this.isDelegatedClientAuthorizedForService((Client)client, service, requestContext)) {
            LOGGER.warn("Delegated client [{}] is not authorized by service [{}]", (Object)client, (Object)service);
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        client.init();
        return client;
    }

    protected Event stopWebflow(Exception e, RequestContext requestContext) {
        requestContext.getFlashScope().put("rootCauseException", (Object)e);
        return new Event((Object)this, "stop", (AttributeMap)new LocalAttributeMap("error", (Object)e));
    }

    protected Service restoreAuthenticationRequestInContext(RequestContext requestContext, JEEContext webContext, String clientName) {
        boolean logoutEndpoint = DelegatedClientAuthenticationAction.isLogoutRequest(webContext.getNativeRequest());
        if (logoutEndpoint) {
            return null;
        }
        try {
            Optional clientResult = this.configContext.getClients().findClient(clientName);
            if (clientResult.isPresent()) {
                return this.delegatedClientAuthenticationWebflowManager.retrieve(requestContext, (WebContext)webContext, (Client)BaseClient.class.cast(clientResult.get()));
            }
            LOGGER.warn("Unable to locate client [{}] in registered clients", (Object)clientName);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new UnauthorizedServiceException("screen.service.error.message", "");
    }

    protected boolean isDelegatedClientAuthorizedForService(Client client, Service service, RequestContext requestContext) {
        return this.configContext.getDelegatedClientIdentityProviderAuthorizers().stream().allMatch(authz -> authz.isDelegatedClientAuthorizedForService(client, service, requestContext));
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigContext() {
        return this.configContext;
    }

    @Generated
    public DelegatedClientAuthenticationWebflowManager getDelegatedClientAuthenticationWebflowManager() {
        return this.delegatedClientAuthenticationWebflowManager;
    }

    @Generated
    public DelegatedClientAuthenticationFailureEvaluator getFailureEvaluator() {
        return this.failureEvaluator;
    }

    @Generated
    public DelegatedAuthenticationSingleSignOnEvaluator getSsoEvaluator() {
        return this.ssoEvaluator;
    }
}

