/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.HealthCheckState;
import com.unboundid.ldap.sdk.unboundidds.monitors.LoadBalancingAlgorithmServerAvailabilityData;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LoadBalancingAlgorithmMonitorEntry
extends MonitorEntry {
    @NotNull
    protected static final String LOAD_BALANCING_ALGORITHM_MONITOR_OC = "ds-load-balancing-algorithm-monitor-entry";
    @NotNull
    private static final String ATTR_ALGORITHM_NAME = "algorithm-name";
    @NotNull
    private static final String ATTR_CONFIG_ENTRY_DN = "config-entry-dn";
    @NotNull
    private static final String ATTR_HEALTH_CHECK_STATE = "health-check-state";
    @NotNull
    private static final String ATTR_LDAP_EXTERNAL_SERVER = "ldap-external-server";
    @NotNull
    private static final String ATTR_LOCAL_SERVERS_HEALTH_CHECK_STATE = "local-servers-health-check-state";
    @NotNull
    private static final String ATTR_NON_LOCAL_SERVERS_HEALTH_CHECK_STATE = "non-local-servers-health-check-state";
    @NotNull
    private static final String ATTR_NUM_AVAILABLE = "num-available-servers";
    @NotNull
    private static final String ATTR_NUM_DEGRADED = "num-degraded-servers";
    @NotNull
    private static final String ATTR_NUM_UNAVAILABLE = "num-unavailable-servers";
    private static final long serialVersionUID = -5251924301718025205L;
    @Nullable
    private final HealthCheckState healthCheckState;
    @Nullable
    private final HealthCheckState localServersHealthCheckState;
    @Nullable
    private final HealthCheckState nonLocalServersHealthCheckState;
    @NotNull
    private final List<LoadBalancingAlgorithmServerAvailabilityData> serverAvailabilityData;
    @Nullable
    private final Long numAvailableServers;
    @Nullable
    private final Long numDegradedServers;
    @Nullable
    private final Long numUnavailableServers;
    @Nullable
    private final String algorithmName = this.getString("algorithm-name");
    @Nullable
    private final String configEntryDN = this.getString("config-entry-dn");

    public LoadBalancingAlgorithmMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.numAvailableServers = this.getLong(ATTR_NUM_AVAILABLE);
        this.numDegradedServers = this.getLong(ATTR_NUM_DEGRADED);
        this.numUnavailableServers = this.getLong(ATTR_NUM_UNAVAILABLE);
        String hcStateStr = this.getString(ATTR_HEALTH_CHECK_STATE);
        this.healthCheckState = hcStateStr == null ? null : HealthCheckState.forName(hcStateStr);
        String localHCStateStr = this.getString(ATTR_LOCAL_SERVERS_HEALTH_CHECK_STATE);
        this.localServersHealthCheckState = localHCStateStr == null ? null : HealthCheckState.forName(localHCStateStr);
        String nonLocalHCStateStr = this.getString(ATTR_NON_LOCAL_SERVERS_HEALTH_CHECK_STATE);
        this.nonLocalServersHealthCheckState = nonLocalHCStateStr == null ? null : HealthCheckState.forName(nonLocalHCStateStr);
        List<String> externalServerStrings = this.getStrings(ATTR_LDAP_EXTERNAL_SERVER);
        ArrayList<LoadBalancingAlgorithmServerAvailabilityData> serverData = new ArrayList<LoadBalancingAlgorithmServerAvailabilityData>(externalServerStrings.size());
        for (String s : externalServerStrings) {
            try {
                serverData.add(new LoadBalancingAlgorithmServerAvailabilityData(s));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.serverAvailabilityData = Collections.unmodifiableList(serverData);
    }

    @Nullable
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Nullable
    public String getConfigEntryDN() {
        return this.configEntryDN;
    }

    @Nullable
    public HealthCheckState getHealthCheckState() {
        return this.healthCheckState;
    }

    @Nullable
    public HealthCheckState getLocalServersHealthCheckState() {
        return this.localServersHealthCheckState;
    }

    @Nullable
    public HealthCheckState getNonLocalServersHealthCheckState() {
        return this.nonLocalServersHealthCheckState;
    }

    @NotNull
    public List<LoadBalancingAlgorithmServerAvailabilityData> getServerAvailabilityData() {
        return this.serverAvailabilityData;
    }

    @Nullable
    public Long getNumAvailableServers() {
        return this.numAvailableServers;
    }

    @Nullable
    public Long getNumDegradedServers() {
        return this.numDegradedServers;
    }

    @Nullable
    public Long getNumUnavailableServers() {
        return this.numUnavailableServers;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(9));
        if (this.algorithmName != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_ALGORITHM_NAME, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_ALGORITHM_NAME.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_ALGORITHM_NAME.get(), this.algorithmName);
        }
        if (this.configEntryDN != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_CONFIG_ENTRY_DN, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_CONFIG_ENTRY_DN.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_CONFIG_ENTRY_DN.get(), this.configEntryDN);
        }
        if (this.healthCheckState != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_HEALTH_CHECK_STATE, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_HEALTH_CHECK_STATE.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_HEALTH_CHECK_STATE.get(), this.healthCheckState.name());
        }
        if (this.localServersHealthCheckState != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_LOCAL_SERVERS_HEALTH_CHECK_STATE, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_L_HEALTH_CHECK_STATE.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_L_HEALTH_CHECK_STATE.get(), this.localServersHealthCheckState.name());
        }
        if (this.nonLocalServersHealthCheckState != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_NON_LOCAL_SERVERS_HEALTH_CHECK_STATE, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_NL_HEALTH_CHECK_STATE.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_NL_HEALTH_CHECK_STATE.get(), this.nonLocalServersHealthCheckState.name());
        }
        if (this.serverAvailabilityData != null && !this.serverAvailabilityData.isEmpty()) {
            ArrayList<String> availabilityStrings = new ArrayList<String>(this.serverAvailabilityData.size());
            for (LoadBalancingAlgorithmServerAvailabilityData d : this.serverAvailabilityData) {
                availabilityStrings.add(d.toCompactString());
            }
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_LDAP_EXTERNAL_SERVER, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_SERVER_DATA.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_SERVER_DATA.get(), availabilityStrings);
        }
        if (this.numAvailableServers != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_AVAILABLE, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_NUM_AVAILABLE.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_NUM_AVAILABLE.get(), this.numAvailableServers);
        }
        if (this.numDegradedServers != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_DEGRADED, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_NUM_DEGRADED.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_NUM_DEGRADED.get(), this.numDegradedServers);
        }
        if (this.numUnavailableServers != null) {
            LoadBalancingAlgorithmMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_UNAVAILABLE, MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DISPNAME_NUM_UNAVAILABLE.get(), MonitorMessages.INFO_LOAD_BALANCING_ALGORITHM_DESC_NUM_UNAVAILABLE.get(), this.numUnavailableServers);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

