/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.template;

import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.template.JQueryAbstractTemplateBehavior;
import com.googlecode.wicket.jquery.core.template.JQueryTemplateResourceStream;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;

public class JQueryTemplateBehavior
extends JQueryAbstractTemplateBehavior {
    private static final long serialVersionUID = 1L;
    public static final PackageResourceReference TMPL_JS = new JQueryPluginResourceReference(JQueryTemplateBehavior.class, "jquery.tmpl.min.js");
    private String token = null;
    private final IJQueryTemplate template;

    public JQueryTemplateBehavior(IJQueryTemplate template) {
        this.template = template;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)TMPL_JS)));
    }

    public void bind(Component component) {
        super.bind(component);
        this.token = String.format("%s-template", component.getMarkupId());
    }

    public String getToken() {
        return this.token;
    }

    protected JQueryTemplateResourceStream newResourceStream() {
        return new JQueryTemplateResourceStream(this.template.getText(), this.getToken());
    }
}

