/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.job.service.impl.persistence.entity.AbstractJobServiceEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class HistoryJobEntityImpl
extends AbstractJobServiceEntity
implements HistoryJobEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int retries;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration;
    protected ByteArrayRef customValuesByteArrayRef;
    protected ByteArrayRef advancedJobHandlerConfigurationByteArrayRef;
    protected ByteArrayRef exceptionByteArrayRef;
    protected String exceptionMessage;
    protected String lockOwner;
    protected Date lockExpirationTime;
    protected Date createTime;
    protected String scopeType;
    protected String tenantId = "";

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("retries", this.retries);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("jobHandlerType", this.jobHandlerType);
        this.putByteArrayRefIdToMap("exceptionByteArrayId", this.exceptionByteArrayRef, persistentState);
        this.putByteArrayRefIdToMap("customValuesByteArrayRef", this.customValuesByteArrayRef, persistentState);
        this.putByteArrayRefIdToMap("advancedJobHandlerConfigurationByteArrayRef", this.advancedJobHandlerConfigurationByteArrayRef, persistentState);
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("scopeType", this.scopeType);
        return persistentState;
    }

    private void putByteArrayRefIdToMap(String key, ByteArrayRef jobByteArrayRef, Map<String, Object> map) {
        if (jobByteArrayRef != null) {
            map.put(key, jobByteArrayRef.getId());
        }
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setRetries(int retries) {
        this.retries = retries;
    }

    @Override
    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    @Override
    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    @Override
    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    @Override
    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public String getCustomValues() {
        return this.getJobByteArrayRefAsString(this.customValuesByteArrayRef);
    }

    @Override
    public void setCustomValues(String customValues) {
        if (this.customValuesByteArrayRef == null) {
            this.customValuesByteArrayRef = new ByteArrayRef();
        }
        this.customValuesByteArrayRef.setValue("jobCustomValues", customValues, this.getEngineType());
    }

    @Override
    public ByteArrayRef getCustomValuesByteArrayRef() {
        return this.customValuesByteArrayRef;
    }

    @Override
    public void setCustomValuesByteArrayRef(ByteArrayRef customValuesByteArrayRef) {
        this.customValuesByteArrayRef = customValuesByteArrayRef;
    }

    @Override
    public ByteArrayRef getAdvancedJobHandlerConfigurationByteArrayRef() {
        return this.advancedJobHandlerConfigurationByteArrayRef;
    }

    @Override
    public String getAdvancedJobHandlerConfiguration() {
        return this.getJobByteArrayRefAsString(this.advancedJobHandlerConfigurationByteArrayRef);
    }

    @Override
    public void setAdvancedJobHandlerConfigurationByteArrayRef(ByteArrayRef configurationByteArrayRef) {
        this.advancedJobHandlerConfigurationByteArrayRef = configurationByteArrayRef;
    }

    @Override
    public void setAdvancedJobHandlerConfiguration(String jobHandlerConfiguration) {
        if (this.advancedJobHandlerConfigurationByteArrayRef == null) {
            this.advancedJobHandlerConfigurationByteArrayRef = new ByteArrayRef();
        }
        this.advancedJobHandlerConfigurationByteArrayRef.setValue("cfg", jobHandlerConfiguration, this.getEngineType());
    }

    @Override
    public void setAdvancedJobHandlerConfigurationBytes(byte[] bytes) {
        if (this.advancedJobHandlerConfigurationByteArrayRef == null) {
            this.advancedJobHandlerConfigurationByteArrayRef = new ByteArrayRef();
        }
        this.advancedJobHandlerConfigurationByteArrayRef.setValue("cfg", bytes, this.getEngineType());
    }

    @Override
    public void setExceptionByteArrayRef(ByteArrayRef exceptionByteArrayRef) {
        this.exceptionByteArrayRef = exceptionByteArrayRef;
    }

    @Override
    public ByteArrayRef getExceptionByteArrayRef() {
        return this.exceptionByteArrayRef;
    }

    @Override
    public String getExceptionStacktrace() {
        return this.getJobByteArrayRefAsString(this.exceptionByteArrayRef);
    }

    @Override
    public void setExceptionStacktrace(String exception) {
        if (this.exceptionByteArrayRef == null) {
            this.exceptionByteArrayRef = new ByteArrayRef();
        }
        this.exceptionByteArrayRef.setValue("stacktrace", exception, this.getEngineType());
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = StringUtils.abbreviate((String)exceptionMessage, (int)2000);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public void setLockOwner(String claimedBy) {
        this.lockOwner = claimedBy;
    }

    @Override
    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    @Override
    public void setLockExpirationTime(Date claimedUntil) {
        this.lockExpirationTime = claimedUntil;
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    protected String getJobByteArrayRefAsString(ByteArrayRef jobByteArrayRef) {
        if (jobByteArrayRef == null) {
            return null;
        }
        return jobByteArrayRef.asString(this.getEngineType());
    }

    protected String getEngineType() {
        if (StringUtils.isNotEmpty((CharSequence)this.scopeType)) {
            return this.scopeType;
        }
        return "bpmn";
    }

    public String toString() {
        return "HistoryJobEntity [id=" + this.id + "]";
    }
}

