/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.api.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Domain
implements Serializable {
    private static final long serialVersionUID = -5881851479361505961L;
    private static final Logger LOG = LoggerFactory.getLogger(Domain.class);
    private String key;
    private String jdbcDriver;
    private String jdbcURL;
    private String dbSchema;
    private String dbUsername;
    private String dbPassword;
    private TransactionIsolation transactionIsolation = TransactionIsolation.TRANSACTION_READ_COMMITTED;
    private int poolMaxActive = 10;
    private int poolMinIdle = 2;
    private String auditSql = "audit.sql";
    private String orm = "META-INF/spring-orm.xml";
    private String databasePlatform;
    private String adminPassword;
    private CipherAlgorithm adminCipherAlgorithm = CipherAlgorithm.SHA512;
    private String content;
    private String keymasterConfParams;

    public String getKey() {
        return this.key;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getPoolMaxActive() {
        return this.poolMaxActive;
    }

    public void setPoolMaxActive(int poolMaxActive) {
        this.poolMaxActive = poolMaxActive;
    }

    public int getPoolMinIdle() {
        return this.poolMinIdle;
    }

    public void setPoolMinIdle(int poolMinIdle) {
        this.poolMinIdle = poolMinIdle;
    }

    public String getAuditSql() {
        return this.auditSql;
    }

    public String getOrm() {
        return this.orm;
    }

    public String getDatabasePlatform() {
        return this.databasePlatform;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public CipherAlgorithm getAdminCipherAlgorithm() {
        return this.adminCipherAlgorithm;
    }

    public void setAdminCipherAlgorithm(CipherAlgorithm adminCipherAlgorithm) {
        this.adminCipherAlgorithm = adminCipherAlgorithm;
    }

    private String read(String filename) {
        String read = null;
        try {
            read = IOUtils.toString((InputStream)Domain.class.getResourceAsStream("/" + filename));
        }
        catch (IOException e) {
            LOG.error("Could not read {}", (Object)filename, (Object)e);
        }
        return read;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.read("defaultContent.xml");
        }
        return this.content;
    }

    public String getKeymasterConfParams() {
        if (this.keymasterConfParams == null) {
            this.keymasterConfParams = this.read("defaultKeymasterConfParams.json");
        }
        return this.keymasterConfParams;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.jdbcDriver).append((Object)this.jdbcURL).append((Object)this.dbSchema).append((Object)this.dbUsername).append((Object)this.dbPassword).append((Object)this.transactionIsolation).append(this.poolMaxActive).append(this.poolMinIdle).append((Object)this.auditSql).append((Object)this.orm).append((Object)this.databasePlatform).append((Object)this.adminPassword).append((Object)this.adminCipherAlgorithm).append((Object)this.content).append((Object)this.keymasterConfParams).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Domain other = (Domain)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.jdbcDriver, (Object)other.jdbcDriver).append((Object)this.jdbcURL, (Object)other.jdbcURL).append((Object)this.dbSchema, (Object)other.dbSchema).append((Object)this.dbUsername, (Object)other.dbUsername).append((Object)this.dbPassword, (Object)other.dbPassword).append((Object)this.transactionIsolation, (Object)other.transactionIsolation).append(this.poolMaxActive, other.poolMaxActive).append(this.poolMinIdle, other.poolMinIdle).append((Object)this.auditSql, (Object)other.auditSql).append((Object)this.orm, (Object)other.orm).append((Object)this.databasePlatform, (Object)other.databasePlatform).append((Object)this.adminPassword, (Object)other.adminPassword).append((Object)this.adminCipherAlgorithm, (Object)other.adminCipherAlgorithm).append((Object)this.content, (Object)other.content).append((Object)this.keymasterConfParams, (Object)other.keymasterConfParams).build();
    }

    public String toString() {
        return "Domain{key=" + this.key + ", jdbcDriver=" + this.jdbcDriver + ", jdbcURL=" + this.jdbcURL + ", dbSchema=" + this.dbSchema + ", dbUsername=" + this.dbUsername + ", dbPassword=" + this.dbPassword + ", transactionIsolation=" + String.valueOf((Object)this.transactionIsolation) + ", poolMaxSize=" + this.poolMaxActive + ", poolMinIdle=" + this.poolMinIdle + ", auditSql=" + this.auditSql + ", orm=" + this.orm + ", databasePlatform=" + this.databasePlatform + ", adminPassword=" + this.adminPassword + ", adminCipherAlgorithm=" + String.valueOf(this.adminCipherAlgorithm) + ", content=" + this.content + ", keymasterConfParams=" + this.keymasterConfParams + "}";
    }

    public static class Builder {
        private final Domain domain = new Domain();

        public Builder(String key) {
            this.domain.key = key;
        }

        public Builder jdbcDriver(String jdbcDriver) {
            this.domain.jdbcDriver = jdbcDriver;
            return this;
        }

        public Builder jdbcURL(String jdbcURL) {
            this.domain.jdbcURL = jdbcURL;
            return this;
        }

        public Builder dbSchema(String dbSchema) {
            if (StringUtils.isNotBlank((CharSequence)dbSchema)) {
                this.domain.dbSchema = dbSchema;
            }
            return this;
        }

        public Builder dbUsername(String dbUsername) {
            this.domain.dbUsername = dbUsername;
            return this;
        }

        public Builder dbPassword(String dbPassword) {
            this.domain.dbPassword = dbPassword;
            return this;
        }

        public Builder transactionIsolation(TransactionIsolation transactionIsolation) {
            this.domain.transactionIsolation = transactionIsolation;
            return this;
        }

        public Builder poolMaxActive(int poolMaxActive) {
            this.domain.poolMaxActive = poolMaxActive;
            return this;
        }

        public Builder poolMinIdle(int poolMinIdle) {
            this.domain.poolMinIdle = poolMinIdle;
            return this;
        }

        public Builder auditSql(String auditSql) {
            this.domain.auditSql = auditSql;
            return this;
        }

        public Builder orm(String orm) {
            this.domain.orm = orm;
            return this;
        }

        public Builder databasePlatform(String databasePlatform) {
            this.domain.databasePlatform = databasePlatform;
            return this;
        }

        public Builder adminPassword(String adminPassword) {
            this.domain.adminPassword = adminPassword;
            return this;
        }

        public Builder adminCipherAlgorithm(CipherAlgorithm adminCipherAlgorithm) {
            this.domain.adminCipherAlgorithm = adminCipherAlgorithm;
            return this;
        }

        public Builder content(String content) {
            this.domain.content = content;
            return this;
        }

        public Builder keymasterConfParams(String keymasterConfParams) {
            this.domain.keymasterConfParams = keymasterConfParams;
            return this;
        }

        public Domain build() {
            return this.domain;
        }
    }

    public static enum TransactionIsolation {
        TRANSACTION_NONE,
        TRANSACTION_READ_COMMITTED,
        TRANSACTION_READ_UNCOMMITTED,
        TRANSACTION_REPEATABLE_READ,
        TRANSACTION_SERIALIZABLE;

    }
}

