/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.EvaluationState;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.MethodNotFoundException;
import org.flowable.common.engine.impl.javax.el.PropertyNotFoundException;
import org.flowable.common.engine.impl.javax.el.ValueExpression;

public class JuelExpression
implements Expression {
    private static final long serialVersionUID = 1L;
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected ExpressionManager expressionManager;

    public JuelExpression(ExpressionManager expressionManager, ValueExpression valueExpression, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
        this.expressionManager = expressionManager;
    }

    public Object getValue(VariableContainer variableContainer) {
        ELContext elContext = this.expressionManager.getElContext(variableContainer);
        Object originalVariableContainer = elContext.getContext(VariableContainer.class);
        elContext.putContext(VariableContainer.class, variableContainer);
        Object originalValueContext = elContext.getContext(EvaluationState.class);
        elContext.putContext(EvaluationState.class, (Object)EvaluationState.READ);
        try {
            Object object = this.resolveGetValueExpression(elContext);
            return object;
        }
        catch (PropertyNotFoundException pnfe) {
            throw new FlowableException("Unknown property used in expression: " + this.expressionText, (Throwable)pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new FlowableException("Unknown method used in expression: " + this.expressionText, (Throwable)mnfe);
        }
        catch (FlowableException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
        finally {
            elContext.putContext(EvaluationState.class, originalValueContext);
            elContext.putContext(VariableContainer.class, originalVariableContainer);
        }
    }

    protected Object resolveGetValueExpression(ELContext elContext) {
        return this.valueExpression.getValue(elContext);
    }

    public void setValue(Object value, VariableContainer variableContainer) {
        ELContext elContext = this.expressionManager.getElContext(variableContainer);
        Object originalVariableContainer = elContext.getContext(VariableContainer.class);
        elContext.putContext(VariableContainer.class, variableContainer);
        Object originalValueContext = elContext.getContext(EvaluationState.class);
        elContext.putContext(EvaluationState.class, (Object)EvaluationState.WRITE);
        try {
            this.resolveSetValueExpression(value, elContext);
        }
        catch (Exception e) {
            throw new FlowableException("Error while evaluating expression: " + this.expressionText, (Throwable)e);
        }
        finally {
            elContext.putContext(EvaluationState.class, originalValueContext);
            elContext.putContext(VariableContainer.class, originalVariableContainer);
        }
    }

    protected void resolveSetValueExpression(Object value, ELContext elContext) {
        this.valueExpression.setValue(elContext, value);
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    public String getExpressionText() {
        return this.expressionText;
    }
}

