/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.NoOpRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.RevocationChecker;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.crypto.CertUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CredentialsAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CredentialsAuthenticationHandler.class);
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private final Pattern regExTrustedIssuerDnPattern;
    private final int maxPathLength;
    private final boolean maxPathLengthAllowUnspecified;
    private final boolean checkKeyUsage;
    private final boolean requireKeyUsage;
    private final Pattern regExSubjectDnPattern;
    private final RevocationChecker revocationChecker;

    public X509CredentialsAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Pattern regExTrustedIssuerDnPattern, int maxPathLength, boolean maxPathLengthAllowUnspecified, boolean checkKeyUsage, boolean requireKeyUsage, Pattern regExSubjectDnPattern, RevocationChecker revocationChecker, Integer order) {
        super(name, servicesManager, principalFactory, order);
        this.regExTrustedIssuerDnPattern = regExTrustedIssuerDnPattern;
        this.maxPathLength = maxPathLength;
        this.maxPathLengthAllowUnspecified = maxPathLengthAllowUnspecified;
        this.checkKeyUsage = checkKeyUsage;
        this.requireKeyUsage = requireKeyUsage;
        this.regExSubjectDnPattern = regExSubjectDnPattern;
        this.revocationChecker = revocationChecker;
    }

    public X509CredentialsAuthenticationHandler(Pattern regExTrustedIssuerDnPattern) {
        this(regExTrustedIssuerDnPattern, new NoOpRevocationChecker());
    }

    public X509CredentialsAuthenticationHandler(Pattern regExTrustedIssuerDnPattern, boolean maxPathLengthAllowUnspecified, Pattern regExSubjectDnPattern) {
        this("", null, null, regExTrustedIssuerDnPattern, Integer.MAX_VALUE, maxPathLengthAllowUnspecified, false, false, regExSubjectDnPattern, new NoOpRevocationChecker(), null);
    }

    public X509CredentialsAuthenticationHandler(Pattern regExTrustedIssuerDnPattern, boolean maxPathLengthAllowUnspecified, int maxPathLength) {
        this("", null, null, regExTrustedIssuerDnPattern, maxPathLength, maxPathLengthAllowUnspecified, false, false, null, new NoOpRevocationChecker(), null);
    }

    public X509CredentialsAuthenticationHandler(Pattern regExTrustedIssuerDnPattern, boolean maxPathLengthAllowUnspecified, boolean checkKeyUsage, boolean requireKeyUsage) {
        this("", null, null, regExTrustedIssuerDnPattern, Integer.MAX_VALUE, maxPathLengthAllowUnspecified, checkKeyUsage, requireKeyUsage, null, new NoOpRevocationChecker(), null);
    }

    public X509CredentialsAuthenticationHandler(Pattern regExTrustedIssuerDnPattern, RevocationChecker revocationChecker) {
        this("", null, null, regExTrustedIssuerDnPattern, Integer.MAX_VALUE, false, false, false, null, revocationChecker, null);
    }

    private static boolean isCritical(X509Certificate certificate, String extensionOid) {
        Set<String> criticalOids = certificate.getCriticalExtensionOIDs();
        return criticalOids != null && !criticalOids.isEmpty() && criticalOids.contains(extensionOid);
    }

    private static boolean doesNameMatchPattern(Principal principal, Pattern pattern) {
        if (pattern != null) {
            String name = principal.getName();
            boolean result = pattern.matcher(name).matches();
            LOGGER.debug("[{}] matches [{}] == [{}]", new Object[]{pattern.pattern(), name, result});
            return result;
        }
        return true;
    }

    public boolean supports(Credential credential) {
        return credential != null && X509CertificateCredential.class.isAssignableFrom(credential.getClass());
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return X509CertificateCredential.class.isAssignableFrom(clazz);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws GeneralSecurityException {
        X509CertificateCredential x509Credential = (X509CertificateCredential)credential;
        X509Certificate[] certificates = x509Credential.getCertificates();
        X509Certificate clientCert = null;
        boolean hasTrustedIssuer = false;
        for (int i = certificates.length - 1; i >= 0; --i) {
            int pathLength;
            X509Certificate certificate = certificates[i];
            LOGGER.debug("Evaluating [{}]", (Object)CertUtils.toString((X509Certificate)certificate));
            this.validate(certificate);
            if (!hasTrustedIssuer) {
                hasTrustedIssuer = this.isCertificateFromTrustedIssuer(certificate);
            }
            if ((pathLength = certificate.getBasicConstraints()) < 0) {
                LOGGER.debug("Found valid client certificate");
                clientCert = certificate;
                continue;
            }
            LOGGER.debug("Found valid CA certificate");
        }
        if (hasTrustedIssuer && clientCert != null) {
            x509Credential.setCertificate(clientCert);
            return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (CredentialMetaData)x509Credential, this.principalFactory.createPrincipal(x509Credential.getId()));
        }
        LOGGER.warn("Either client certificate could not be determined, or a trusted issuer could not be located");
        throw new FailedLoginException();
    }

    private void validate(X509Certificate cert) throws GeneralSecurityException {
        cert.checkValidity();
        this.revocationChecker.check(cert);
        int pathLength = cert.getBasicConstraints();
        if (pathLength < 0) {
            if (!this.isCertificateAllowed(cert)) {
                String msg = "Certificate subject does not match pattern " + this.regExSubjectDnPattern.pattern();
                LOGGER.error(msg);
                throw new FailedLoginException(msg);
            }
            if (this.checkKeyUsage && !this.isValidKeyUsage(cert)) {
                String msg = "Certificate keyUsage constraint forbids SSL client authentication.";
                LOGGER.error("Certificate keyUsage constraint forbids SSL client authentication.");
                throw new FailedLoginException("Certificate keyUsage constraint forbids SSL client authentication.");
            }
        } else {
            if (pathLength == Integer.MAX_VALUE && !this.maxPathLengthAllowUnspecified) {
                String msg = "Unlimited certificate path length not allowed by configuration.";
                LOGGER.error("Unlimited certificate path length not allowed by configuration.");
                throw new FailedLoginException("Unlimited certificate path length not allowed by configuration.");
            }
            if (pathLength > this.maxPathLength && pathLength < Integer.MAX_VALUE) {
                String msg = String.format("Certificate path length %s exceeds maximum value %s.", pathLength, this.maxPathLength);
                LOGGER.error(msg);
                throw new FailedLoginException(msg);
            }
        }
    }

    private boolean isValidKeyUsage(X509Certificate certificate) {
        LOGGER.debug("Checking certificate keyUsage extension");
        boolean[] keyUsage = certificate.getKeyUsage();
        if (keyUsage == null) {
            LOGGER.warn("Configuration specifies checkKeyUsage but keyUsage extension not found in certificate.");
            return !this.requireKeyUsage;
        }
        Function func = FunctionUtils.doIf(c -> X509CredentialsAuthenticationHandler.isCritical(certificate, KEY_USAGE_OID) || this.requireKeyUsage, t -> {
            LOGGER.debug("KeyUsage extension is marked critical or required by configuration.");
            return keyUsage[0];
        }, f -> {
            LOGGER.debug("KeyUsage digitalSignature=%s, Returning true since keyUsage validation not required by configuration.");
            return Boolean.TRUE;
        });
        return (Boolean)func.apply(certificate);
    }

    private boolean isCertificateAllowed(X509Certificate cert) {
        return this.regExSubjectDnPattern == null || X509CredentialsAuthenticationHandler.doesNameMatchPattern(cert.getSubjectDN(), this.regExSubjectDnPattern);
    }

    private boolean isCertificateFromTrustedIssuer(X509Certificate cert) {
        return X509CredentialsAuthenticationHandler.doesNameMatchPattern(cert.getIssuerDN(), this.regExTrustedIssuerDnPattern);
    }
}

