/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.Collection;
import java.util.Map;
import org.apache.openjpa.conf.CacheMarshallersValue;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.MapConfigurationProvider;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;

public class MetaDataCacheMaintenance {
    private final BrokerFactory factory;
    private final OpenJPAConfiguration conf;
    private final boolean devpath;
    private Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options opts = new Options();
        args = opts.setFromCmdLine(args);
        boolean devpath = opts.getBooleanProperty("scanDevPath", "ScanDevPath", true);
        MapConfigurationProvider cp = new MapConfigurationProvider((Map)opts);
        try (BrokerFactory factory = Bootstrap.newBrokerFactory((ConfigurationProvider)cp, null);){
            MetaDataCacheMaintenance maint = new MetaDataCacheMaintenance(factory, devpath);
            if (args.length != 1) {
                MetaDataCacheMaintenance.usage();
                return;
            }
            if ("store".equals(args[0])) {
                maint.store();
            } else if ("dump".equals(args[0])) {
                maint.dump();
            } else {
                MetaDataCacheMaintenance.usage();
            }
        }
    }

    @Deprecated
    public MetaDataCacheMaintenance(BrokerFactory factory, boolean devpath, boolean verbose) {
        this(factory, devpath);
    }

    public MetaDataCacheMaintenance(BrokerFactory factory, boolean devpath) {
        this.factory = factory;
        this.conf = factory.getConfiguration();
        this.devpath = devpath;
        this.log = this.conf.getLog("openjpa.Tool");
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private static int usage() {
        System.err.println("Usage: java MetaDataCacheMaintenance [-scanDevPath t|f] [-<openjpa.PropertyName> value] store | dump");
        return -1;
    }

    public void store() {
        MetaDataRepository repos = this.conf.getMetaDataRepositoryInstance();
        repos.setSourceMode(31);
        Collection<Class<?>> types = repos.loadPersistentTypes(this.devpath, null);
        for (Class<?> type : types) {
            repos.getMetaData(type, null, true);
        }
        this.loadQueries();
        this.log.info((Object)"The following data will be stored: ");
        this.log(repos, this.conf.getQueryCompilationCacheInstance());
        CacheMarshallersValue.getMarshallerById(this.conf, this.getClass().getName()).store(new Object[]{repos, this.conf.getQueryCompilationCacheInstance()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQueries() {
        try (Broker broker = this.factory.newBroker();){
            QueryMetaData[] qmds;
            for (QueryMetaData qmd : qmds = this.conf.getMetaDataRepositoryInstance().getQueryMetaDatas()) {
                this.loadQuery(broker, qmd);
            }
        }
    }

    private void loadQuery(Broker broker, QueryMetaData qmd) {
        try {
            Query q = broker.newQuery(qmd.getLanguage(), null);
            qmd.setInto(q);
            q.compile();
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.warn((Object)("Skipping named query " + qmd.getName() + ": " + e.getMessage()), (Throwable)e);
            }
            this.log.warn((Object)("Skipping named query " + qmd.getName() + ": " + e.getMessage()));
        }
    }

    public void dump() {
        Object[] os = (Object[])CacheMarshallersValue.getMarshallerById(this.conf, this.getClass().getName()).load();
        if (os == null) {
            this.log.info((Object)"No cached data was found");
            return;
        }
        MetaDataRepository repos = (MetaDataRepository)os[0];
        Map qcc = (Map)os[1];
        this.log.info((Object)"The following data was found: ");
        this.log(repos, qcc);
    }

    private void log(MetaDataRepository repos, Map qcc) {
        ClassMetaData[] metas = repos.getMetaDatas();
        this.log.info((Object)("  Types: " + metas.length));
        if (this.log.isTraceEnabled()) {
            for (ClassMetaData meta : metas) {
                this.log.trace((Object)("    " + meta.getDescribedType().getName()));
            }
        }
        QueryMetaData[] qmds = repos.getQueryMetaDatas();
        this.log.info((Object)("  Queries: " + qmds.length));
        if (this.log.isTraceEnabled()) {
            for (QueryMetaData qmd : qmds) {
                this.log.trace((Object)("    " + qmd.getName() + ": " + qmd.getQueryString()));
            }
        }
        SequenceMetaData[] smds = repos.getSequenceMetaDatas();
        this.log.info((Object)("  Sequences: " + smds.length));
        if (this.log.isTraceEnabled()) {
            for (SequenceMetaData smd : smds) {
                this.log.trace((Object)("    " + smd.getName()));
            }
        }
        this.log.info((Object)("  Compiled queries: " + (qcc == null ? "0" : "" + qcc.size())));
        if (this.log.isTraceEnabled() && qcc != null) {
            for (Object o : qcc.keySet()) {
                this.log.trace((Object)("    " + o));
            }
        }
    }
}

