/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.SurrogatePrincipal;
import org.apereo.cas.authentication.principal.DefaultPrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogatePrincipalElectionStrategy
extends DefaultPrincipalElectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogatePrincipalElectionStrategy.class);
    private static final long serialVersionUID = -3112906686072339162L;

    protected Map<String, List<Object>> getPrincipalAttributesForPrincipal(Principal principal, Map<String, List<Object>> principalAttributes) {
        return principal.getAttributes();
    }

    protected Principal getPrincipalFromAuthentication(Collection<Authentication> authentications) {
        LOGGER.trace("Calculating principal from authentications [{}]", authentications);
        Optional<SurrogatePrincipal> result = authentications.stream().map(Authentication::getPrincipal).filter(SurrogatePrincipal.class::isInstance).map(SurrogatePrincipal.class::cast).findFirst();
        if (result.isPresent()) {
            Principal surrogate = result.get().getSurrogate();
            LOGGER.debug("Found surrogate principal [{}]", (Object)surrogate);
            return surrogate;
        }
        return super.getPrincipalFromAuthentication(authentications);
    }

    public Principal nominate(List<Principal> principals, Map<String, List<Object>> attributes) {
        LOGGER.debug("Calculating principal from principals [{}]", principals);
        Optional<SurrogatePrincipal> result = principals.stream().filter(SurrogatePrincipal.class::isInstance).map(SurrogatePrincipal.class::cast).findFirst();
        if (result.isPresent()) {
            SurrogatePrincipal surrogate = result.get();
            principals.removeIf(SurrogatePrincipal.class::isInstance);
            LinkedHashMap primaryAttributes = new LinkedHashMap(surrogate.getPrimary().getAttributes());
            principals.forEach(principal -> {
                Map merged = CoreAuthenticationUtils.mergeAttributes((Map)primaryAttributes, (Map)principal.getAttributes(), (IAttributeMerger)this.getAttributeMerger());
                primaryAttributes.putAll(merged);
            });
            surrogate.getPrimary().getAttributes().putAll(primaryAttributes);
            LOGGER.debug("Found surrogate principal [{}]", (Object)surrogate);
            return surrogate;
        }
        return super.nominate(principals, attributes);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

